/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.sql.Connection;
import java.util.Date;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.DBInfoBasic;
import quadbase.common.util.internal.IOUtil;

public class TestDBConnectionSlave {
    MessageThread messageThread;
    Server server;
    IConnection client_socket;
    protected DBInfoBasic dbInfo;

    public TestDBConnectionSlave(MessageThread messageThread, Server server, IConnection socket) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
        this.dbInfo = messageThread.dbInfo;
    }

    public void run() {
        try {
            Connection con = this.dbInfo.openConnection();
            if (con != null) {
                this.sendReply();
            }
        }
        catch (Exception ex) {
            this.cleanup(3, "Server failed to read data :" + ex.toString() + "\n");
        }
    }

    void acknowledge(int code, String s) {
        try {
            DataOutputStream dout2 = new DataOutputStream(this.client_socket.getOutputStream());
            dout2.writeInt(code);
            IOUtil.writeString(dout2, s);
            dout2.close();
        }
        catch (Exception ex) {
            this.server.writeLog(this.getHeader() + "Failed to acknowledge client " + ex.toString(), true);
        }
    }

    void sendReply() throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeInt(0);
        try {
            this.client_socket.getOutputStream().write(bstream.toByteArray());
            this.client_socket.getOutputStream().flush();
            this.client_socket.getOutputStream().write(0);
            this.client_socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            this.client_socket.close();
            throw ex;
        }
    }

    void cleanup(int code, String err) {
        this.cleanup(code, err, true);
    }

    void cleanup(int code, String err, boolean ack) {
        if (ack) {
            this.acknowledge(code, err);
        }
        try {
            this.client_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nInput : " + this.messageThread.infile + " -- ";
    }
}

