/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.net.URL;
import java.util.Date;
import java.util.Vector;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.IOUtil;
import quadbase.util.internal.ICompareObject;
import quadbase.util.internal.SortObject;
import quadbase.util.internal.StringCompare;

public class URLSlave {
    MessageThread messageThread;
    Server server;
    IConnection client_socket;
    Vector filenameList;
    Vector lastModifiedList;
    private static final String GO_UP = ".." + System.getProperty("file.separator");
    private boolean debug = false;

    public URLSlave(MessageThread messageThread, Server server, IConnection socket) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
        this.filenameList = new Vector();
        this.lastModifiedList = new Vector();
    }

    boolean authenticate(int messageType) {
        this.server.userCounter(true);
        try {
            String mess = this.server.userCheck(3, null, null, this.client_socket.getPeerAddress(), messageType);
            if (!mess.equals("OK")) {
                this.cleanup(5, mess);
                return false;
            }
        }
        catch (Exception ex) {
            this.cleanup(5, ex.toString());
            return false;
        }
        return true;
    }

    public void run() {
        if (this.authenticate(30158)) {
            try {
                this.getFileList(this.messageThread.infile, this.messageThread.isGoUpEnabled, this.messageThread.defaultDir, this.messageThread.readLastModifiedTime, this.messageThread.includeDir);
                this.sendReply();
            }
            catch (Exception ex) {
                this.cleanup(3, "Server failed to read data :" + ex.toString() + "\n");
            }
        }
    }

    void acknowledge(int code, String s) {
        try {
            DataOutputStream dout2 = new DataOutputStream(this.client_socket.getOutputStream());
            dout2.writeInt(code);
            IOUtil.writeString(dout2, s);
            dout2.close();
        }
        catch (Exception ex) {
            this.server.writeLog(this.getHeader() + "Failed to acknowledge client " + ex.toString(), true);
        }
    }

    public void getFileList(String loc, boolean isGoUpEnabled, String defaultDir, boolean readLastModifiedTime, boolean includeDir) throws Exception {
        if (this.debug) {
            Server.println(this.server, "URLSlave loc = " + loc);
        }
        if (this.debug) {
            Server.println(this.server, "URLSlave mainPath = " + this.server.mainPath);
        }
        String urlStr = IOUtil.nameToURL(null, this.server.mainPath, loc);
        if (this.debug) {
            Server.println(this.server, "URLSlave urlStr = " + urlStr);
        }
        URL urldir = new URL(urlStr);
        if (this.debug) {
            Server.println(this.server, "URLSlave urldir = " + urldir);
        }
        File temp = this.urlToFile(urldir);
        String s = temp.getAbsolutePath();
        if (this.debug) {
            Server.println(this.server, "URLSlave ABSOLUTE PATH = " + s);
        }
        if (!temp.exists()) {
            return;
        }
        if (temp.isFile()) {
            return;
        }
        if (!isGoUpEnabled) {
            String defStr = IOUtil.nameToURL(null, this.server.mainPath, defaultDir);
            URL defdir = new URL(defStr);
            File temp1 = this.urlToFile(defdir);
            String absDef = temp1.getAbsolutePath();
            if (temp != null && temp.exists() && !temp.isFile() && s.startsWith(absDef) && !s.equals(absDef)) {
                isGoUpEnabled = true;
            }
        }
        s = temp.getAbsolutePath();
        String[] list = temp.list();
        if (list == null) {
            throw new Exception("You don't currently have permission to access this folder.");
        }
        ICompareObject[] compareList = new StringCompare[list.length];
        for (int i = 0; i < list.length; ++i) {
            compareList[i] = new StringCompare(list[i].toUpperCase(), i);
        }
        int[] order = SortObject.sortIndex(compareList, true);
        int lastDirIndex = 0;
        if (includeDir && isGoUpEnabled && temp.getParent() != null && !temp.getParent().trim().equals("")) {
            File[] roots = File.listRoots();
            boolean isRoot = false;
            for (File root : roots) {
                if (!root.getPath().equals(temp.getCanonicalPath())) continue;
                isRoot = true;
            }
            if (!isRoot) {
                this.filenameList.insertElementAt(GO_UP, 0);
                if (readLastModifiedTime) {
                    this.lastModifiedList.insertElementAt(0L, 0);
                }
                ++lastDirIndex;
            }
        }
        for (int element : order) {
            String listv = list[element];
            String temp1 = s.endsWith(System.getProperty("file.separator")) ? s + listv : s + System.getProperty("file.separator") + listv;
            File file1 = new File(temp1);
            if (file1.isDirectory() && includeDir) {
                this.filenameList.insertElementAt(listv + System.getProperty("file.separator"), lastDirIndex);
                if (readLastModifiedTime) {
                    this.lastModifiedList.insertElementAt(file1.lastModified(), lastDirIndex);
                }
                if (this.debug) {
                    Server.println(this.server, "URLSlave DIR = " + listv);
                }
                ++lastDirIndex;
                continue;
            }
            if (!file1.isFile() || !this.hasValidExtension(listv)) continue;
            if (this.debug) {
                Server.println(this.server, "URLSlave FILE = " + listv);
            }
            this.filenameList.addElement(listv);
            if (!readLastModifiedTime) continue;
            this.lastModifiedList.addElement(file1.lastModified());
        }
    }

    public boolean hasValidExtension(String filename) {
        String filenameUpper = filename.toUpperCase();
        String[] validExtension = this.messageThread.validExtension;
        if (validExtension[0].equals("*")) {
            return true;
        }
        for (String element : validExtension) {
            if (!filenameUpper.endsWith(element.toUpperCase())) continue;
            return true;
        }
        return false;
    }

    void sendReply() throws Exception {
        ByteArrayOutputStream bstream = new ByteArrayOutputStream(50);
        DataOutputStream dout = new DataOutputStream(bstream);
        dout.writeInt(0);
        int nFile = this.filenameList.size();
        dout.writeInt(nFile);
        boolean writeLastModifiedTime = nFile == this.lastModifiedList.size();
        for (int i = 0; i < nFile; ++i) {
            IOUtil.writeString(dout, (String)this.filenameList.elementAt(i));
            if (!writeLastModifiedTime) continue;
            dout.writeLong((Long)this.lastModifiedList.elementAt(i));
        }
        try {
            this.client_socket.getOutputStream().write(bstream.toByteArray());
            this.client_socket.getOutputStream().flush();
            this.client_socket.getOutputStream().write(0);
            this.client_socket.getOutputStream().flush();
        }
        catch (Exception ex) {
            this.client_socket.close();
            throw ex;
        }
    }

    void cleanup(int code, String err) {
        this.cleanup(code, err, true);
    }

    void cleanup(int code, String err, boolean ack) {
        if (ack) {
            this.acknowledge(code, err);
        }
        try {
            this.client_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nInput : " + this.messageThread.infile + " -- ";
    }

    private File urlToFile(URL url) {
        String filename = url.getFile() + (url.getRef() != null ? "#" + url.getRef() : "");
        StringBuffer sb = new StringBuffer(128);
        int i = 0;
        if (filename.length() > 3 && filename.charAt(0) == '/' && filename.charAt(2) == '|') {
            sb.append(filename.charAt(1));
            sb.append(':');
            i = 3;
        }
        String slashReplacement = System.getProperty("file.separator");
        while (i < filename.length()) {
            if (filename.charAt(i) == '/' && filename.charAt(i) == '\\') {
                sb.append(slashReplacement);
            } else {
                sb.append(filename.charAt(i));
            }
            ++i;
        }
        return new File(sb.toString());
    }
}

