/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.DataOutputStream;
import java.io.IOException;
import quadbase.common.network.IConnection;
import quadbase.common.pak.FileUnpacker;
import quadbase.common.pak.FileUnpackerFactory;
import quadbase.common.pak.PakEntry;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.IOUtil;

public class UnpakSlave {
    public static final int GET_PAK_ENTRIES = 1;
    public static final int UNPACK_FILES = 2;
    public static final int UPDATE_REFERENCES = 3;
    MessageThread messageThread;
    Server server;
    IConnection client_socket;

    public UnpakSlave(MessageThread messageThread, Server server, IConnection socket) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        block17: {
            try {
                DataOutputStream dout = new DataOutputStream(this.client_socket.getOutputStream());
                try {
                    FileUnpacker unpacker;
                    if (this.messageThread.format == 1) {
                        unpacker = FileUnpackerFactory.getDashboardUnpacker(this.messageThread.infile);
                    } else if (this.messageThread.format == 2) {
                        unpacker = FileUnpackerFactory.getMapUnpacker(this.messageThread.infile);
                    } else if (this.messageThread.format == 3) {
                        unpacker = FileUnpackerFactory.getRegistryUnpacker(this.messageThread.infile);
                    } else {
                        throw new Exception("Unknown PAK format: " + this.messageThread.format);
                    }
                    if (this.messageThread.jobRequest == 1) {
                        PakEntry[] entries = unpacker.getPakEntries();
                        dout.writeInt(0);
                        dout.writeInt(entries.length);
                        for (PakEntry entrie : entries) {
                            entrie.write(dout);
                        }
                        break block17;
                    }
                    if (this.messageThread.jobRequest == 2) {
                        unpacker.unpackFiles(this.messageThread.pakEntries);
                        dout.writeInt(0);
                        break block17;
                    }
                    if (this.messageThread.jobRequest == 3) {
                        unpacker.updateReferences(this.messageThread.pakEntries);
                        dout.writeInt(0);
                        break block17;
                    }
                    throw new Exception("Unknown jobRequest: " + this.messageThread.jobRequest);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    dout.writeInt(6);
                    IOUtil.writeString(dout, e.getMessage());
                }
                finally {
                    dout.close();
                    this.client_socket.close();
                }
            }
            catch (IOException iOException) {
                // empty catch block
            }
        }
    }
}

