/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.DataOutputStream;
import java.io.File;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;

public class UpdateFileLockSlave
extends Thread {
    boolean lock;
    String infile;
    Server server;
    IConnection client_socket;
    String machine = null;
    boolean acknowledge = true;

    public UpdateFileLockSlave(MessageThread messageThread, Server server, IConnection socket) {
        this.lock = messageThread.lock;
        this.infile = messageThread.infile;
        this.machine = messageThread.remoteAddr;
        this.server = server;
        this.client_socket = socket;
    }

    @Override
    public void run() {
        int code = 6;
        try {
            String absPath = new File(this.server.getPath(this.infile)).getAbsolutePath().toUpperCase();
            if (this.lock) {
                this.server.lockedFiles.put(absPath, this.machine);
                System.out.println("lockedFiles.put(" + absPath + "," + this.machine + ")");
                code = 0;
            } else {
                String removed = this.server.lockedFiles.get(absPath);
                if (removed != null) {
                    this.server.lockedFiles.remove(absPath);
                    System.out.println("lockedFiles.remove(" + absPath + ")");
                    code = 0;
                }
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        if (this.acknowledge) {
            try {
                DataOutputStream dout = new DataOutputStream(this.client_socket.getOutputStream());
                dout.writeInt(code);
                dout.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
            try {
                this.client_socket.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }
}

