/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.server.StreamSlave;
import quadbase.common.util.internal.XMLFileQueryInfo;
import quadbase.util.IResultSet;
import quadbase.util.XMLQueryResultSet;
import quadbase.util.internal.IQueryProcInfo;
import quadbase.util.internal.TransposeRS;

public class XMLDataParserSlave
extends StreamSlave {
    public XMLDataParserSlave(MessageThread messageThread, Server server, IConnection socket) {
        super(messageThread, server, socket);
    }

    @Override
    IQueryProcInfo getPreprocessInfo() {
        return this.messageThread.tsInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        InputStream in = null;
        try {
            if (this.authenticate(24327)) {
                IResultSet irs = null;
                if (this.messageThread.infile != null && !this.messageThread.infile.equals("")) {
                    in = this.getInputStream();
                    irs = new XMLQueryResultSet(this.messageThread.xmlFileQueryInfo);
                } else {
                    XMLFileQueryInfo info = this.messageThread.xmlFileQueryInfo;
                    irs = new XMLQueryResultSet(new ByteArrayInputStream(info.getData()), info.getFieldInfo(), info.getCondition(), info.getConditionInfo(), info.getInSet());
                }
                if (this.messageThread.transposeData) {
                    irs = TransposeRS.doTranspose(irs, this.messageThread.transposeCol);
                }
                byte[] outdata = null;
                if (this.messageThread.preProcessData) {
                    IResultSet ors = this.preprocess(irs);
                    irs.close();
                    outdata = this.writeToBuffer(ors);
                    ors.close();
                } else {
                    outdata = this.writeToBuffer(irs);
                }
                if (in != null) {
                    in.close();
                }
                this.writeOutput(outdata);
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.cleanup(3, "Server failed to read data :" + ex.toString() + "\n");
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.cleanup(-2, ex.toString() + "\n");
        }
        catch (OutOfMemoryError err) {
            err.printStackTrace();
            this.cleanup(2, err.toString() + "\n");
        }
        catch (Error err) {
            err.printStackTrace();
            this.cleanup(-1, err.toString() + "\n");
        }
        finally {
            try {
                if (in != null) {
                    in.close();
                }
            }
            catch (Exception ex) {}
        }
    }
}

