/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.server.StreamSlave;
import quadbase.common.util.internal.IOUtil;
import quadbase.common.util.internal.XMLQueryResultSet;

public class XMLDataSheetSlave
extends StreamSlave {
    public XMLDataSheetSlave(MessageThread messageThread, Server server, IConnection socket) {
        super(messageThread, server, socket);
    }

    @Override
    public void run() {
        try {
            XMLQueryResultSet rs = new XMLQueryResultSet(this.messageThread.xmlDataSheetInfo);
            int startIndex = this.messageThread.xmlStartIndex;
            int displayRow = this.messageThread.xmlDisplayRow;
            byte[] outdata = null;
            outdata = this.writeToBuffer(rs, startIndex, displayRow);
            this.writeOutput(outdata);
        }
        catch (Exception ex) {
            this.cleanup(3, "Server failed to read data :" + ex.toString() + "\n");
        }
        catch (Error err) {
            this.cleanup(6, err.toString() + "\n");
        }
    }

    private byte[] writeToBuffer(XMLQueryResultSet rs, int startIndex, int displayRow) throws Exception {
        int i;
        ByteArrayOutputStream bStream = new ByteArrayOutputStream(1024);
        DataOutputStream dStream = new DataOutputStream(bStream);
        int nCol = rs.getColumnCount();
        int nRow = 0;
        int rowCt = 0;
        int[] columnType = new int[nCol];
        for (i = 1; i <= nCol; ++i) {
            String columnName = rs.getColumnName(i);
            columnType[i - 1] = rs.getColumnType(i);
            IOUtil.writeString(dStream, columnName);
            dStream.writeInt(columnType[i - 1]);
        }
        while (!ServerMessage.exceedLimit(nRow) && rs.next() && (displayRow < 0 || nRow < startIndex + displayRow)) {
            if (nRow >= startIndex) {
                for (i = 1; i <= nCol; ++i) {
                    Object temp = rs.getObject(i);
                    this.writeData(dStream, temp);
                }
                ++rowCt;
            }
            ++nRow;
        }
        dStream.close();
        byte[] outBuf = bStream.toByteArray();
        bStream.close();
        ByteArrayOutputStream bStream2 = new ByteArrayOutputStream(1024);
        DataOutputStream dStream2 = new DataOutputStream(bStream2);
        dStream2.writeInt(rowCt);
        dStream2.writeInt(nCol);
        dStream2.write(outBuf, 0, outBuf.length);
        dStream2.close();
        return bStream2.toByteArray();
    }
}

