/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.Date;
import quadbase.common.network.IConnection;
import quadbase.common.server.DataSlave;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.IOUtil;
import quadbase.reportdesigner.report.ImportFontMappingHelper;

public class XMLFontMappingSlave
extends DataSlave {
    FileOutputStream fstream = null;
    String urlfile = null;

    public XMLFontMappingSlave(MessageThread messageThread, Server server, IConnection socket) {
        super(messageThread, server, socket);
        this.urlfile = messageThread.infile;
    }

    InputStream getInputStream() throws IOException {
        InputStream conn = null;
        this.urlfile = IOUtil.nameToURL(this.server.mainPath, this.messageThread.infile);
        this.server.writeLog(this.getHeader() + "start...\n");
        if (this.urlfile.startsWith("http://") || this.urlfile.startsWith("https://")) {
            conn = new URL(this.urlfile).openStream();
        } else if (this.messageThread.infile.startsWith("/") || this.messageThread.infile.indexOf(":/") >= 0) {
            conn = new FileInputStream(this.messageThread.infile);
        } else {
            File connFile = new File(this.server.mainPath, this.messageThread.infile);
            conn = new FileInputStream(connFile);
        }
        return conn;
    }

    @Override
    byte[] readData() {
        byte[] indata;
        try {
            indata = new ImportFontMappingHelper().getInputStream(this.server.getPath(this.urlfile));
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.cleanup(3, "Server failed to read data :" + ex.toString() + "\n");
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.cleanup(-2, ex.toString() + "\n");
            return null;
        }
        catch (OutOfMemoryError err) {
            err.printStackTrace();
            this.cleanup(2, err.toString() + "\n");
            return null;
        }
        catch (Error err) {
            err.printStackTrace();
            this.cleanup(-1, err.toString() + "\n");
            return null;
        }
        return indata;
    }

    @Override
    void cleanup(int code, String err, boolean ack) {
        if (ack) {
            this.acknowledge(code, err);
        }
        try {
            this.client_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.fstream != null) {
            try {
                this.fstream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    @Override
    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nInput : " + this.urlfile + " -- ";
    }

    @Override
    boolean authenticate(int messageType) {
        boolean passed = super.authenticate(messageType);
        return passed;
    }
}

