/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.util.Date;
import quadbase.common.network.IConnection;
import quadbase.common.server.DataSlave;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.reportdesigner.report.LoadXMLReport;
import quadbase.reportdesigner.report.LoadXMLReportHelper;
import quadbase.reportdesigner.report.Report;
import quadbase.reportdesigner.report.SaveReport;

public class XMLReportDataSlave
extends DataSlave {
    FileOutputStream fstream = null;

    public XMLReportDataSlave(MessageThread messageThread, Server server, IConnection socket) {
        super(messageThread, server, socket);
    }

    @Override
    byte[] readData() {
        byte[] indata;
        try {
            DataInputStream instream = new DataInputStream(this.client_socket.getInputStream());
            indata = new byte[this.messageThread.packageLen];
            instream.readFully(indata, 0, this.messageThread.packageLen);
            LoadXMLReport loadXML = new LoadXMLReport();
            loadXML.setInServer(true);
            ByteArrayInputStream istream = new ByteArrayInputStream(indata);
            DataInputStream in = new DataInputStream(istream);
            LoadXMLReportHelper helper = new LoadXMLReportHelper(loadXML);
            Report report = helper.loadReport(in, null);
            in.close();
            istream.close();
            SaveReport save = new SaveReport(report);
            save.setDrillDownNode(loadXML.getDrillDownNode());
            save.setSubReports(loadXML.getSubReports());
            ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
            DataOutputStream out = new DataOutputStream(fstream);
            save.saveToFile("TEMP", out);
            out.close();
            fstream.close();
            indata = fstream.toByteArray();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            this.cleanup(3, "Server failed to read data :" + ex.toString() + "\n");
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            this.cleanup(-2, ex.toString() + "\n");
            return null;
        }
        catch (OutOfMemoryError err) {
            err.printStackTrace();
            this.cleanup(2, err.toString() + "\n");
            return null;
        }
        catch (Error err) {
            err.printStackTrace();
            this.cleanup(-1, err.toString() + "\n");
            return null;
        }
        return indata;
    }

    @Override
    void cleanup(int code, String err, boolean ack) {
        if (ack) {
            this.acknowledge(code, err);
        }
        try {
            this.client_socket.close();
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (this.fstream != null) {
            try {
                this.fstream.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        this.server.writeLog(this.getHeader() + err, code != 0);
        this.server.userCounter(false);
    }

    @Override
    String getHeader() {
        return "[" + new Date().toString() + " from " + (this.client_socket != null ? this.client_socket.getPeerHost() : "Unknown") + "]\nInput : byte array data -- ";
    }

    @Override
    boolean authenticate(int messageType) {
        return super.authenticate(messageType);
    }
}

