/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.awt.Component;
import java.awt.Frame;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import quadbase.chart.Chart;
import quadbase.chart.SaveChart;
import quadbase.chart.xml.XMLChart;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.server.StreamSlave;
import quadbase.common.util.internal.IOUtil;
import quadbase.util.internal.IQueryProcInfo;

public class XMLTemplateSlave
extends StreamSlave {
    public XMLTemplateSlave(MessageThread messageThread, Server server, IConnection socket) {
        super(messageThread, server, socket);
    }

    @Override
    IQueryProcInfo getPreprocessInfo() {
        return this.messageThread.tsInfo;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        ByteArrayOutputStream fstream = new ByteArrayOutputStream(2048);
        DataOutputStream out = new DataOutputStream(fstream);
        try {
            if (this.authenticate(24578)) {
                new SaveChart(this.createXMLChart()).saveToDataOutput(out, false);
                this.writeOutput(fstream.toByteArray());
                if (out != null) {
                    out.close();
                }
                if (fstream != null) {
                    fstream.close();
                }
            }
        }
        catch (Exception ex) {
            this.cleanup(3, "Server failed to read data :" + ex.toString() + "\n");
        }
        catch (Error err) {
            this.cleanup(6, err.toString() + "\n");
        }
        finally {
            try {
                if (out != null) {
                    out.close();
                }
                if (fstream != null) {
                    fstream.close();
                }
            }
            catch (Exception ex) {}
        }
    }

    Chart createXMLChart() throws Exception {
        Frame comp = new Frame();
        comp.addNotify();
        this.urlfile = IOUtil.nameToURL(this.server.mainPath, this.messageThread.infile);
        Chart chart = this.urlfile.startsWith("http://") || this.urlfile.startsWith("https://") ? new XMLChart(this.urlfile, (Component)comp).createChart() : (this.messageThread.infile.startsWith("/") || this.messageThread.infile.indexOf(":/") >= 0 ? new XMLChart(new File(this.messageThread.infile), (Component)comp).createChart(this.messageThread.chart) : new XMLChart(new File(this.server.mainPath, this.messageThread.infile), (Component)comp).createChart(this.messageThread.chart));
        comp.removeNotify();
        return chart;
    }
}

