/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server;

import java.io.DataOutputStream;
import quadbase.common.network.IConnection;
import quadbase.common.server.MessageThread;
import quadbase.common.server.Server;
import quadbase.common.util.internal.CloseUtils;
import quadbase.common.util.internal.XMLVerifierHandler;
import quadbase.util.internal.IOUtil;

public class XMLVerifySlave {
    private MessageThread messageThread;
    private Server server;
    private IConnection client_socket;

    public XMLVerifySlave(MessageThread messageThread, Server server, IConnection socket) {
        this.messageThread = messageThread;
        this.server = server;
        this.client_socket = socket;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public void run() {
        String externalFile;
        int type;
        String xmlFile = this.server.getPath(this.messageThread.xmlFile);
        XMLVerifierHandler handler = new XMLVerifierHandler(xmlFile, type = this.messageThread.verifyType, externalFile = this.server.getPath(this.messageThread.externalFile));
        String msg = handler.verify();
        int code = msg == null ? 0 : 6;
        DataOutputStream dout = null;
        try {
            dout = new DataOutputStream(this.client_socket.getOutputStream());
            dout.writeInt(code);
            if (code != 0) {
                IOUtil.writeString(dout, msg);
            }
            dout.close();
        }
        catch (Exception exception) {
            CloseUtils.close(dout);
            CloseUtils.close(this.client_socket);
            catch (Throwable throwable) {
                CloseUtils.close(dout);
                CloseUtils.close(this.client_socket);
                throw throwable;
            }
        }
        CloseUtils.close(dout);
        CloseUtils.close(this.client_socket);
    }
}

