/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server.appl;

import java.awt.BorderLayout;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.util.Vector;
import javax.swing.BoxLayout;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.client.ServerMessage;
import quadbase.common.swing.ExtensionFilter;
import quadbase.common.swing.SpinBox;
import quadbase.common.util.internal.LanguageEncoder;

public class ServerAppl
extends JFrame
implements ActionListener,
ItemListener {
    JCheckBox log;
    JCheckBox showMonitor;
    JCheckBox runInBackground;
    JCheckBox enableSchedThreadLimit;
    JCheckBox enablePaging;
    JCheckBox singleTableForDistinctParamValue;
    JCheckBox enableSchedBuffer;
    JCheckBox enableRecordLimit;
    boolean isLog;
    boolean isShowMonitor = true;
    boolean isRunInBackground;
    boolean isEnableSchedThreadLimit;
    boolean isEnablePaging;
    boolean isSingleTableForDistinctParamValue;
    boolean isEnableSchedBuffer;
    boolean isEnableRecordLimit;
    SpinBox schedThreadLimit;
    SpinBox schedulerBuffer;
    SpinBox pagingThreshold;
    SpinBox pageBufferSize;
    SpinBox maxFieldSize;
    SpinBox totalPageBufferSize;
    SpinBox pageCleanUpHH;
    SpinBox pageCleanUpDD;
    SpinBox pageCleanUpMM;
    SpinBox recordLimit;
    SpinBox htmlDpi;
    SpinBox memHeapSize;
    JButton addClasspath;
    JButton globalFormatBrowse;
    JButton fontMappingBrowse;
    JButton applyBut;
    JButton closeBut;
    JTextField schedCallBackClass;
    JTextField listenerManagerClass;
    JTextField globalFormat;
    JTextField fontMapping;
    JTextField classpath;
    String listenerManagerPath = "";
    String schedCallBackPath = "";
    String globalFormatPath = "";
    String fontMappingPath = "";
    String classpathText = "";
    static String fileName = "espressmanager" + ServerAppl.appendExtension();
    int recordLimitVal = 100000;
    int pagingThresholdVal = -1;
    int pageBufferSizeVal = 500;
    int maxFieldSizeVal = 1;
    int totalPageBufferSizeVal = 250;
    int htmlDpiVal = 96;
    int schedThreadLimitVal = 10;
    int schedulerBufferVal = 10;
    int pageCleanUpHHVal = 1;
    int pageCleanUpDDVal = 0;
    int pageCleanUpMMVal = 0;
    Vector paths = new Vector();
    Vector additionalCP = new Vector();
    Vector originalCP = new Vector();
    String[] existingCP = new String[]{"EspressManager.jar", "axercesImpl.jar", "xml-apis.jar", "ExportLib.jar", "qblicense.jar", "."};
    String cpSep = ";";
    String javaExec = "";
    int memHeapSizeVal = 64;

    public static void main(String[] args) {
        if (args != null && args.length > 0) {
            String filename = null;
            String enc = null;
            for (String arg : args) {
                if (arg.startsWith("-file:")) {
                    filename = arg.substring(6);
                    continue;
                }
                if (!arg.startsWith("-enc:")) continue;
                enc = arg.substring(5);
            }
            if (filename != null && enc != null) {
                ServerMessage.useServer = false;
                try {
                    LanguageEncoder.load(filename, enc);
                }
                catch (Exception e) {
                    System.out.println(e.getMessage());
                }
            }
        }
        new ServerAppl();
    }

    public static String appendExtension() {
        String extension = ".";
        String OS = System.getProperty("os.name");
        extension = OS.toLowerCase().indexOf("windows") > -1 ? extension + "bat" : extension + "sh";
        return extension;
    }

    public ServerAppl() {
        if (this.parseFile()) {
            this.initUI();
            this.setPosition();
            this.setVisible(true);
        }
    }

    void initUI() {
        this.setTitle(LanguageEncoder.getText("EspressManager Config"));
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BoxLayout(contentPane, 1));
        JPanel p1 = new JPanel();
        p1.setLayout(new BoxLayout(p1, 1));
        p1.add(this.getBasicPanel());
        p1.add(this.getRecordFilePanel());
        p1.add(this.getJVMPanel());
        JPanel p2 = new JPanel();
        p2.setLayout(new GridLayout(2, 1));
        p2.add(this.getOthersPanel());
        p2.add(this.getSchedulerPanel());
        JPanel p4 = new JPanel();
        p4.setLayout(new BorderLayout());
        p4.add("Center", p2);
        p4.add("South", this.getDefaultReportSettingPanel());
        JPanel p3 = new JPanel();
        p3.setLayout(new BorderLayout());
        p3.add("Center", p1);
        p3.add("East", p4);
        contentPane.add(p3);
        contentPane.add(this.getButtonPanel());
        this.itemStateChanged(null);
    }

    private BufferedReader getInputReader(String fileName) throws IOException {
        return new BufferedReader(new FileReader(fileName));
    }

    void parseClasspath(String[] argv) {
        for (String element : argv) {
            if (this.isClasspathExisted(element)) {
                this.originalCP.add(element);
                continue;
            }
            this.additionalCP.add(element);
        }
        for (int i = 0; i < this.additionalCP.size(); ++i) {
            this.classpathText = i == 0 ? this.additionalCP.elementAt(i).toString() : this.classpathText + this.cpSep + this.additionalCP.elementAt(i).toString();
        }
    }

    boolean isClasspathExisted(String cp) {
        for (String element : this.existingCP) {
            if (!cp.toLowerCase().endsWith(element)) continue;
            return true;
        }
        return false;
    }

    void parseCommands(String[] argv) {
        for (String element : argv) {
            try {
                String str;
                if (element.equals("-log")) {
                    this.isLog = true;
                    continue;
                }
                if (element.startsWith("-SchedulerCallBackClass:")) {
                    this.schedCallBackPath = element.substring(24);
                    continue;
                }
                if (element.startsWith("-PageCleanUpTime:")) {
                    str = element.substring(17);
                    this.pageCleanUpDDVal = Integer.valueOf(str.substring(0, 2));
                    this.pageCleanUpHHVal = Integer.valueOf(str.substring(2, 4));
                    this.pageCleanUpMMVal = Integer.valueOf(str.substring(4, 6));
                    continue;
                }
                if (element.startsWith("-monitor:")) {
                    str = element.substring(9).trim();
                    if (str.equals("ON")) {
                        this.isShowMonitor = true;
                        continue;
                    }
                    if (!str.equals("OFF")) continue;
                    this.isShowMonitor = false;
                    continue;
                }
                if (element.startsWith("-recordLimit:")) {
                    this.recordLimitVal = Integer.valueOf(element.substring(13));
                    this.isEnableRecordLimit = this.recordLimitVal > 0;
                    continue;
                }
                if (element.startsWith("-PagingThreshold:")) {
                    this.pagingThresholdVal = Integer.valueOf(element.substring(17));
                    this.isEnablePaging = this.pagingThresholdVal > 0;
                    continue;
                }
                if (element.startsWith("-PageBufferSize:")) {
                    this.pageBufferSizeVal = Integer.valueOf(element.substring(16));
                    continue;
                }
                if (element.startsWith("-MaxFieldSize:")) {
                    this.maxFieldSizeVal = Integer.valueOf(element.substring(14));
                    continue;
                }
                if (element.startsWith("-TotalPageBufferSize:")) {
                    this.totalPageBufferSizeVal = Integer.valueOf(element.substring(21));
                    continue;
                }
                if (element.startsWith("-runInBackground:")) {
                    str = element.substring(17).trim();
                    if (str.equals("ON")) {
                        this.isRunInBackground = true;
                        continue;
                    }
                    if (!str.equals("OFF")) continue;
                    this.isRunInBackground = false;
                    continue;
                }
                if (element.startsWith("-globalFormat:")) {
                    this.globalFormatPath = element.substring(14, element.length());
                    continue;
                }
                if (element.startsWith("-fontMapping:")) {
                    this.fontMappingPath = element.substring(13, element.length());
                    continue;
                }
                if (element.startsWith("-htmlDpi:")) {
                    this.htmlDpiVal = Integer.parseInt(element.substring(9, element.length()));
                    continue;
                }
                if (element.startsWith("-ListenerManagerClass:")) {
                    this.listenerManagerPath = element.substring(22);
                    continue;
                }
                if (element.startsWith("-schedulerThreadLimit:")) {
                    this.schedThreadLimitVal = Integer.parseInt(element.substring(22));
                    this.isEnableSchedThreadLimit = this.schedThreadLimitVal > 0;
                    continue;
                }
                if (element.startsWith("-schedulerBuffer:")) {
                    this.schedulerBufferVal = Integer.parseInt(element.substring(17));
                    this.isEnableSchedBuffer = this.schedulerBufferVal > 0;
                    continue;
                }
                if (!element.equals("-singleTableForDistinctParamValue")) continue;
                this.isSingleTableForDistinctParamValue = true;
            }
            catch (Exception ex) {
                System.out.println("Cannot parse - " + element);
            }
        }
    }

    boolean parseFile() {
        try {
            BufferedReader reader = this.getInputReader(fileName);
            String cmd = reader.readLine().trim();
            int strIndex = -1;
            while ((strIndex = cmd.indexOf("-classpath ")) == -1) {
                this.paths.add(cmd);
                cmd = reader.readLine().trim();
            }
            reader.close();
            int endIndex = cmd.indexOf(" quadbase.common");
            System.out.println("START INDEX = " + strIndex);
            System.out.println("END INDEX = " + endIndex);
            String cp = cmd.substring(strIndex + 11, endIndex).replaceAll("\"", "");
            System.out.println("CLASSPATH = '" + cp + "'");
            String[] cps = cp.split(";");
            if (cps == null || cps.length <= 1) {
                cps = cp.split(":");
                this.cpSep = ":";
            }
            endIndex = cmd.indexOf(" -Xmx");
            this.javaExec = cmd.substring(0, endIndex);
            this.memHeapSizeVal = Integer.valueOf(cmd.substring(endIndex + 5, strIndex - 2));
            this.parseClasspath(cps);
            strIndex = cmd.indexOf("server.Server");
            cmd = cmd.substring(strIndex + 14);
            System.out.println("CMD = '" + cmd + "'");
            this.parseCommands(cmd.split("\\s"));
            return true;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return false;
        }
    }

    String rebuildClasspath() {
        String val = this.classpath.getText();
        for (int i = this.originalCP.size() - 1; i >= 0; --i) {
            val = this.originalCP.elementAt(i).toString() + this.cpSep + val;
        }
        return val;
    }

    String rebuildCommands() {
        String strDHM;
        String tmp;
        String val = "";
        if (this.log.isSelected()) {
            val = val + " -log";
        }
        if ((tmp = this.schedCallBackClass.getText()) != null && !tmp.equals("")) {
            val = val + " -SchedulerCallBackClass:" + tmp;
        }
        if ((strDHM = this.pageCleanUpMM.getValue() + "").length() == 1) {
            strDHM = "0" + strDHM;
        }
        if ((strDHM = this.pageCleanUpHH.getValue() + strDHM).length() == 3) {
            strDHM = "0" + strDHM;
        }
        if ((strDHM = this.pageCleanUpDD.getValue() + strDHM).length() == 5) {
            strDHM = "0" + strDHM;
        }
        if (!strDHM.equals("000100")) {
            val = val + " -PageCleanUpTime:" + strDHM;
        }
        if (!this.showMonitor.isSelected()) {
            val = val + " -monitor:OFF";
        }
        if (this.enableRecordLimit.isSelected()) {
            val = val + " -recordLimit:" + this.recordLimit.getValue();
        }
        if (this.enablePaging.isSelected()) {
            val = val + " -PagingThreshold:" + this.pagingThreshold.getValue();
            val = val + " -PageBufferSize:" + this.pageBufferSize.getValue();
            val = val + " -MaxFieldSize:" + this.maxFieldSize.getValue();
            val = val + " -TotalPageBufferSize:" + this.totalPageBufferSize.getValue();
        }
        if (this.runInBackground.isSelected()) {
            val = val + " -runInBackground:ON";
        }
        if ((tmp = this.globalFormat.getText()) != null && !tmp.equals("")) {
            val = val + " -globalFormat:" + tmp;
        }
        if ((tmp = this.fontMapping.getText()) != null && !tmp.equals("")) {
            val = val + " -fontMapping:" + tmp;
        }
        if (this.htmlDpi.getValue() != 96) {
            val = val + " -htmlDpi:" + this.htmlDpi.getValue();
        }
        if ((tmp = this.listenerManagerClass.getText()) != null && !tmp.equals("")) {
            val = val + " -ListenerManagerClass:" + tmp;
        }
        if (this.enableSchedThreadLimit.isSelected()) {
            val = val + " -schedulerThreadLimit:" + this.schedThreadLimit.getValue();
        }
        if (this.enableSchedBuffer.isSelected()) {
            val = val + " -schedulerBuffer:" + this.schedulerBuffer.getValue();
        }
        if (this.singleTableForDistinctParamValue.isSelected()) {
            val = val + " -singleTableForDistinctParamValue";
        }
        return val;
    }

    void rebuildFile() {
        try {
            FileWriter dout = new FileWriter(fileName);
            for (int i = 0; i < this.paths.size(); ++i) {
                String tmp = this.paths.elementAt(i).toString() + "\n";
                dout.write(tmp, 0, tmp.length());
            }
            String stat = "";
            String newClasspath = this.rebuildClasspath();
            String newCommands = this.rebuildCommands();
            stat = this.cpSep.equals(";") ? this.javaExec + " -Xmx" + this.memHeapSize.getValue() + "M -classpath \"" + newClasspath + "\" quadbase.common.server.Server " + newCommands + " %1 %2 %3 %4 %5 %6 %7 %8 %9" : this.javaExec + " -Xmx" + this.memHeapSize.getValue() + "M -classpath \"" + newClasspath + "\" quadbase.common.server.Server " + newCommands;
            dout.write(stat, 0, stat.length());
            dout.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    void setPosition() {
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        if (dim.width >= screenSize.width * 3 / 4) {
            dim.width = screenSize.width * 3 / 4;
        }
        this.setSize(dim);
        this.setLocationRelativeTo(this.getParent());
    }

    JPanel getButtonPanel() {
        JPanel p11 = new JPanel();
        p11.setLayout(new GridLayout(1, 2));
        this.applyBut = new JButton(LanguageEncoder.getText("Apply"));
        p11.add(this.applyBut);
        this.closeBut = new JButton(LanguageEncoder.getText("Close"));
        p11.add(this.closeBut);
        this.applyBut.addActionListener(this);
        this.closeBut.addActionListener(this);
        return p11;
    }

    JPanel getBasicPanel() {
        JPanel main = new JPanel();
        main.setBorder(new TitledBorder(LanguageEncoder.getText("Basic Options")));
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(0));
        this.log = new JCheckBox(LanguageEncoder.getText("Log"), this.isLog);
        p1.add(this.log);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(0));
        this.showMonitor = new JCheckBox(LanguageEncoder.getText("Show Monitor"), this.isShowMonitor);
        p2.add(this.showMonitor);
        JPanel p3 = new JPanel();
        p3.setLayout(new FlowLayout(0));
        this.runInBackground = new JCheckBox(LanguageEncoder.getText("Run In Background"), this.isRunInBackground);
        p3.add(this.runInBackground);
        JPanel p5 = new JPanel();
        p5.setLayout(new FlowLayout(0));
        p5.add(new JLabel(LanguageEncoder.getText("Additional Classpath :")));
        JPanel p6 = new JPanel();
        p6.setLayout(new BorderLayout());
        this.classpath = new JTextField(this.classpathText);
        p6.add("Center", this.classpath);
        this.addClasspath = new JButton(LanguageEncoder.getText("Insert"));
        p6.add("East", this.addClasspath);
        this.addClasspath.addActionListener(this);
        main.setLayout(new BoxLayout(main, 1));
        main.add(p1);
        main.add(p2);
        main.add(p3);
        main.add(p5);
        main.add(p6);
        return main;
    }

    JPanel getJVMPanel() {
        JPanel main = new JPanel();
        main.setBorder(new TitledBorder(LanguageEncoder.getText("JVM Options")));
        main.setLayout(new FlowLayout(0));
        main.add(new JLabel(LanguageEncoder.getText("Memory Heap Size :")));
        this.memHeapSize = new SpinBox(1, 9999, 1, 4);
        main.add(this.memHeapSize);
        this.memHeapSize.setValue(this.memHeapSizeVal);
        return main;
    }

    JPanel getOthersPanel() {
        JPanel main = new JPanel();
        main.setBorder(new TitledBorder(LanguageEncoder.getText("Other Options")));
        JPanel p11 = new JPanel();
        p11.setLayout(new GridLayout(2, 1));
        this.enableRecordLimit = new JCheckBox(LanguageEncoder.getText("Record Limit :"), this.isEnableRecordLimit);
        p11.add(this.enableRecordLimit);
        this.enableRecordLimit.addItemListener(this);
        p11.add(new JLabel(LanguageEncoder.getText("HTML DPI :")));
        JPanel p12 = new JPanel();
        p12.setLayout(new GridLayout(2, 1));
        this.recordLimit = new SpinBox(1, 9999999, 1, 7);
        p12.add(this.recordLimit);
        this.recordLimit.setValue(this.recordLimitVal);
        this.htmlDpi = new SpinBox(1, 99, 1, 2);
        p12.add(this.htmlDpi);
        this.htmlDpi.setValue(this.htmlDpiVal);
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout(1, 2));
        p1.add(p11);
        p1.add(p12);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(0));
        p2.add(new JLabel(LanguageEncoder.getText("Page Clean up Time :")));
        this.pageCleanUpDD = new SpinBox(0, 99, 1, 2);
        p2.add(this.pageCleanUpDD);
        p2.add(new JLabel(LanguageEncoder.getText("day")));
        this.pageCleanUpDD.setValue(this.pageCleanUpDDVal);
        this.pageCleanUpHH = new SpinBox(0, 99, 1, 2);
        p2.add(this.pageCleanUpHH);
        p2.add(new JLabel(LanguageEncoder.getText("hour")));
        this.pageCleanUpHH.setValue(this.pageCleanUpHHVal);
        this.pageCleanUpMM = new SpinBox(0, 99, 1, 2);
        p2.add(this.pageCleanUpMM);
        p2.add(new JLabel(LanguageEncoder.getText("minute")));
        this.pageCleanUpMM.setValue(this.pageCleanUpMMVal);
        JPanel p3 = new JPanel();
        p3.setLayout(new FlowLayout(0));
        this.singleTableForDistinctParamValue = new JCheckBox(LanguageEncoder.getText("Enable Single Table For Distinct Param Value"), this.isSingleTableForDistinctParamValue);
        p3.add(this.singleTableForDistinctParamValue);
        main.setLayout(new BoxLayout(main, 1));
        main.add(p1);
        main.add(p2);
        main.add(p3);
        return main;
    }

    JPanel getRecordFilePanel() {
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout(4, 1));
        p1.add(new JLabel(LanguageEncoder.getText("Paging Threshold : (in MB)")));
        p1.add(new JLabel(LanguageEncoder.getText("Page Buffer Size : (in MB)")));
        p1.add(new JLabel(LanguageEncoder.getText("Max Field Size :")));
        p1.add(new JLabel(LanguageEncoder.getText("Total Page Buffer Size : (in MB)")));
        JPanel p2 = new JPanel();
        p2.setLayout(new GridLayout(4, 1));
        this.pagingThreshold = new SpinBox(1, 9999999, 1, 7);
        p2.add(this.pagingThreshold);
        this.pagingThreshold.setValue(this.pagingThresholdVal);
        this.pageBufferSize = new SpinBox(1, 9999999, 1, 7);
        p2.add(this.pageBufferSize);
        this.pageBufferSize.setValue(this.pageBufferSizeVal);
        this.maxFieldSize = new SpinBox(1, 999, 1, 3);
        p2.add(this.maxFieldSize);
        this.maxFieldSize.setValue(this.maxFieldSizeVal);
        this.totalPageBufferSize = new SpinBox(1, 9999999, 1, 7);
        p2.add(this.totalPageBufferSize);
        this.totalPageBufferSize.setValue(this.totalPageBufferSizeVal);
        JPanel p4 = new JPanel();
        p4.setLayout(new FlowLayout(0));
        this.enablePaging = new JCheckBox(LanguageEncoder.getText("Enable Paging Feature"), this.isEnablePaging);
        p4.add(this.enablePaging);
        this.enablePaging.addItemListener(this);
        JPanel main = new JPanel();
        main.setBorder(new TitledBorder(LanguageEncoder.getText("Paging Options")));
        main.setLayout(new BorderLayout());
        main.add("Center", p1);
        main.add("East", p2);
        main.add("South", p4);
        return main;
    }

    JPanel getDefaultReportSettingPanel() {
        JPanel main = new JPanel();
        main.setBorder(new TitledBorder(LanguageEncoder.getText("Default Report Setting")));
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout(2, 1));
        p1.add(new JLabel(LanguageEncoder.getText("Default Global Format :")));
        p1.add(new JLabel(LanguageEncoder.getText("Default PDF Font Mapping :")));
        JPanel p2 = new JPanel();
        p2.setLayout(new GridLayout(2, 1));
        this.globalFormat = new JTextField(this.globalFormatPath);
        p2.add(this.globalFormat);
        this.fontMapping = new JTextField(this.fontMappingPath);
        p2.add(this.fontMapping);
        JPanel p3 = new JPanel();
        p3.setLayout(new GridLayout(2, 1));
        this.globalFormatBrowse = new JButton(LanguageEncoder.getText("Browse"));
        p3.add(this.globalFormatBrowse);
        this.globalFormatBrowse.addActionListener(this);
        this.fontMappingBrowse = new JButton(LanguageEncoder.getText("Browse"));
        p3.add(this.fontMappingBrowse);
        this.fontMappingBrowse.addActionListener(this);
        main.setLayout(new BorderLayout());
        main.add("West", p1);
        main.add("Center", p2);
        main.add("East", p3);
        return main;
    }

    JPanel getSchedulerPanel() {
        JPanel main = new JPanel();
        main.setBorder(new TitledBorder(LanguageEncoder.getText("Scheduler and Call Back Options")));
        JPanel p1 = new JPanel();
        p1.setLayout(new GridLayout(3, 2));
        p1.add(new JLabel(LanguageEncoder.getText("Scheduler Call Back Class :")));
        this.schedCallBackClass = new JTextField(this.schedCallBackPath);
        p1.add(this.schedCallBackClass);
        p1.add(new JLabel(LanguageEncoder.getText("Listener Manager Class :")));
        this.listenerManagerClass = new JTextField(this.listenerManagerPath);
        p1.add(this.listenerManagerClass);
        JPanel p4 = new JPanel();
        p4.setLayout(new GridLayout(2, 2));
        this.enableSchedThreadLimit = new JCheckBox(LanguageEncoder.getText("Enable Schedule Thread Limit"), this.isEnableSchedThreadLimit);
        p4.add(this.enableSchedThreadLimit);
        this.schedThreadLimit = new SpinBox(1, 9999, 1, 4);
        p4.add(this.schedThreadLimit);
        this.schedThreadLimit.setValue(this.schedThreadLimitVal);
        this.enableSchedThreadLimit.addItemListener(this);
        this.enableSchedBuffer = new JCheckBox(LanguageEncoder.getText("Scheduler Buffer :"), this.isEnableSchedBuffer);
        p4.add(this.enableSchedBuffer);
        this.schedulerBuffer = new SpinBox(1, 9999, 1, 4);
        p4.add(this.schedulerBuffer);
        this.schedulerBuffer.setValue(this.schedulerBufferVal);
        this.enableSchedBuffer.addItemListener(this);
        main.setLayout(new BoxLayout(main, 1));
        main.add(p1);
        main.add(p4);
        return main;
    }

    private String loadFile(String[] ext) {
        JFileChooser fileChooser = new JFileChooser(LanguageEncoder.getText("Select file"));
        if (ext != null) {
            ExtensionFilter fileFilter = new ExtensionFilter(ext);
            fileChooser.addChoosableFileFilter(fileFilter);
        }
        fileChooser.setCurrentDirectory(new File("."));
        fileChooser.showDialog(this, null);
        if (fileChooser.getSelectedFile() == null) {
            return null;
        }
        return fileChooser.getSelectedFile().getAbsolutePath();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object btn = e.getSource();
        if (btn == this.addClasspath) {
            String tmp = this.loadFile(null);
            System.out.println("SELECTED FILE = " + tmp);
            if (tmp != null) {
                String txt = this.classpath.getText();
                if (txt.endsWith("\"")) {
                    txt = txt.substring(0, txt.length() - 1);
                }
                if (!txt.endsWith(";")) {
                    txt = txt + ";";
                }
                this.classpath.setText(txt + tmp + "\"");
            }
        } else if (btn == this.applyBut) {
            System.out.println("APPLY BUTTON...");
            this.rebuildFile();
        } else if (btn == this.globalFormatBrowse) {
            String tmp = this.loadFile(new String[]{"XML"});
            System.out.println("SELECTED FILE = " + tmp);
            if (tmp != null) {
                this.globalFormat.setText(tmp);
            }
        } else if (btn == this.fontMappingBrowse) {
            String tmp = this.loadFile(new String[]{"XML"});
            System.out.println("SELECTED FILE = " + tmp);
            if (tmp != null) {
                this.fontMapping.setText(tmp);
            }
        } else if (btn == this.closeBut) {
            this.setVisible(false);
            this.dispose();
            System.exit(1);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.schedThreadLimit.setEnabled(this.enableSchedThreadLimit.isSelected());
        this.pagingThreshold.setEnabled(this.enablePaging.isSelected());
        this.pageBufferSize.setEnabled(this.enablePaging.isSelected());
        this.maxFieldSize.setEnabled(this.enablePaging.isSelected());
        this.totalPageBufferSize.setEnabled(this.enablePaging.isSelected());
        this.schedulerBuffer.setEnabled(this.enableSchedBuffer.isSelected());
        this.recordLimit.setEnabled(this.enableRecordLimit.isSelected());
    }
}

