/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server.datareg;

import java.io.ByteArrayOutputStream;
import java.io.DataInputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.common.client.ServerMessage;
import quadbase.common.network.IConnection;
import quadbase.common.server.datareg.DataRegResult;
import quadbase.common.server.datareg.DataRegState;
import quadbase.common.server.datareg.XmlNodePath;
import quadbase.common.util.internal.IOUtil;
import quadbase.datasourcemanager.manager.ReadXMLTable;

public class DataRegClient {
    private static String dataRegLoc;
    static DefaultMutableTreeNode root;
    static DefaultMutableTreeNode nodeInEdit;
    static XmlNodePath nodePathInEdit;
    static IConnection socket;
    static ByteArrayOutputStream bstream;
    static DataOutputStream dout;
    static DataInputStream din;
    static ReadXMLTable readXml;
    static boolean DEBUG;

    public static void setDataRegLoc(String loc) {
        dataRegLoc = loc;
    }

    public static DefaultMutableTreeNode getRoot() {
        return root;
    }

    public static DataRegResult editNode(DefaultMutableTreeNode node) throws Exception {
        DataRegClient.debug("editNode(node)");
        DataRegClient.openRequest();
        DataRegClient.writeCommand((short)101);
        nodePathInEdit = XmlNodePath.valueOf(node);
        DataRegClient.writeArg(nodePathInEdit);
        DataRegClient.flushRequest();
        DataRegClient.openResponse();
        root = DataRegClient.readNode();
        boolean canEdit = DataRegClient.readBoolean();
        DataRegClient.debug("editNode canEdit = " + canEdit);
        String lockedUserHostAddr = IOUtil.readString(din, true);
        String lockedNodePath = IOUtil.readString(din, true);
        if (canEdit) {
            nodeInEdit = DataRegState.findNode(root, nodePathInEdit);
        }
        DataRegResult result = new DataRegResult(canEdit, nodeInEdit, lockedUserHostAddr, lockedNodePath);
        return result;
    }

    public static void closeEditNode() throws Exception {
        String overrideHost = DataRegClient.isNodeLockOverrided(nodePathInEdit.toString());
        if (!overrideHost.equals("")) {
            return;
        }
        if (nodeInEdit == null) {
            return;
        }
        DataRegClient.debug("closeEditNode");
        DataRegClient.openRequest();
        DataRegClient.writeCommand((short)102);
        DataRegClient.debug("writeArg original nodePath = " + nodePathInEdit);
        DataRegClient.writeArg(nodePathInEdit);
        DataRegClient.debug("writeArg nodeInEdit = " + nodeInEdit);
        DataRegClient.writeArg(nodeInEdit);
        DataRegClient.flushRequest();
        DataRegClient.openResponse();
    }

    public static DataRegResult addNode(DefaultMutableTreeNode node) throws Exception {
        DataRegClient.debug("addNode(node)");
        DataRegClient.openRequest();
        DataRegClient.writeCommand((short)103);
        XmlNodePath nodePath = XmlNodePath.valueOf(node);
        DataRegClient.writeArg(nodePath);
        DataRegClient.flushRequest();
        DataRegClient.openResponse();
        root = DataRegClient.readNode();
        boolean canAdd = DataRegClient.readBoolean();
        DataRegClient.debug("addNode canAdd = " + canAdd);
        nodeInEdit = canAdd ? DataRegState.findNode(root, nodePath) : null;
        String lockedUserHostAddr = IOUtil.readString(din, true);
        String lockedNodePath = IOUtil.readString(din, true);
        DataRegResult result = new DataRegResult(canAdd, nodeInEdit, lockedUserHostAddr, lockedNodePath);
        return result;
    }

    public static void closeAddNode(DefaultMutableTreeNode node) throws Exception {
        DataRegClient.debug("closeAddNode");
        DataRegClient.openRequest();
        if (node == null) {
            DataRegClient.writeCommand((short)105);
        } else {
            DataRegClient.writeCommand((short)104);
        }
        XmlNodePath nodePath = XmlNodePath.valueOf(nodeInEdit);
        DataRegClient.debug("writeArg nodePath = " + nodePath);
        DataRegClient.writeArg(nodePath);
        DataRegClient.debug("writeArg node = " + node);
        if (node != null) {
            DataRegClient.writeArg(node);
        }
        DataRegClient.flushRequest();
        DataRegClient.openResponse();
    }

    public static void addNodeNoClose(DefaultMutableTreeNode node) throws Exception {
        DataRegClient.debug("addNodeNoClose");
        DataRegClient.openRequest();
        DataRegClient.writeCommand((short)108);
        XmlNodePath nodePath = XmlNodePath.valueOf(nodeInEdit);
        DataRegClient.debug("writeArg nodePath = " + nodePath);
        DataRegClient.writeArg(nodePath);
        DataRegClient.debug("writeArg node = " + node);
        DataRegClient.writeArg(node);
        DataRegClient.flushRequest();
        DataRegClient.openResponse();
        root = DataRegClient.readNode();
    }

    public static boolean removeNode(DefaultMutableTreeNode node) throws Exception {
        DataRegClient.debug("removeNode(node)");
        DataRegClient.openRequest();
        DataRegClient.writeCommand((short)106);
        XmlNodePath nodePath = XmlNodePath.valueOf(node);
        DataRegClient.writeArg(nodePath);
        DataRegClient.flushRequest();
        DataRegClient.openResponse();
        root = DataRegClient.readNode();
        return DataRegClient.readBoolean();
    }

    public static boolean copyNode(DefaultMutableTreeNode src, DefaultMutableTreeNode destParent, String destName, String destFile, String srcFile) throws Exception {
        DataRegClient.debug("copyNode(node)");
        DataRegClient.openRequest();
        DataRegClient.writeCommand((short)107);
        XmlNodePath srcPath = XmlNodePath.valueOf(src);
        XmlNodePath destPath = XmlNodePath.valueOf(destParent);
        destPath.add(destName);
        DataRegClient.writeArg(srcPath);
        DataRegClient.writeArg(destPath);
        DataRegClient.writeArg(destFile);
        DataRegClient.writeArg(srcFile);
        DataRegClient.flushRequest();
        DataRegClient.openResponse();
        root = DataRegClient.readNode();
        return DataRegClient.readBoolean();
    }

    public static String getNodeLockString(DefaultMutableTreeNode node) throws Exception {
        DataRegClient.openRequest();
        DataRegClient.writeCommand((short)109);
        XmlNodePath nodePath = XmlNodePath.valueOf(node);
        DataRegClient.writeArg(nodePath);
        DataRegClient.flushRequest();
        DataRegClient.openResponse();
        return IOUtil.readString(din, true);
    }

    public static String overrideNodeLockOnServer(XmlNodePath nodePath) throws Exception {
        if (!ServerMessage.useServer) {
            return "";
        }
        DataRegClient.openRequest();
        DataRegClient.writeCommand((short)110);
        DataRegClient.writeArg(nodePath);
        DataRegClient.flushRequest();
        DataRegClient.openResponse();
        return IOUtil.readString(din, true);
    }

    public static String isNodeLockOverrided(String nodePathStr) throws Exception {
        if (!ServerMessage.useServer) {
            return "";
        }
        DataRegClient.openRequest();
        DataRegClient.writeCommand((short)111);
        IOUtil.writeString(dout, nodePathStr);
        DataRegClient.flushRequest();
        DataRegClient.openResponse();
        return IOUtil.readString(din, true);
    }

    public static String isNodeLockOverrided(DefaultMutableTreeNode node) throws Exception {
        XmlNodePath nodePath = XmlNodePath.valueOf(node);
        return DataRegClient.isNodeLockOverrided(nodePath.toString());
    }

    public static String clearOverrideLock() throws Exception {
        DataRegClient.openRequest();
        DataRegClient.writeCommand((short)112);
        DataRegClient.flushRequest();
        DataRegClient.openResponse();
        String result = IOUtil.readString(din, true);
        return result;
    }

    static void openRequest() throws IOException {
        socket = ServerMessage.createConnection();
        bstream = new ByteArrayOutputStream(50);
        dout = new DataOutputStream(bstream);
        dout.writeShort(23801);
        dout.writeBoolean(false);
        IOUtil.writeString(dout, dataRegLoc);
    }

    static void flushRequest() throws IOException {
        try {
            byte[] array = bstream.toByteArray();
            socket.setContentLength(array.length);
            socket.getOutputStream().write(array);
            socket.getOutputStream().flush();
        }
        catch (IOException e) {
            socket.close();
            throw e;
        }
    }

    static void openResponse() throws IOException {
        din = new DataInputStream(socket.getInputStream());
    }

    static void closeResponse() throws IOException {
        din.close();
    }

    static void writeCommand(short command) throws IOException {
        dout.writeShort(command);
    }

    static void writeArg(XmlNodePath path) throws IOException {
        XmlNodePath dummy = new XmlNodePath("dummy");
        dummy.setNext(path);
        int totalNodes = 0;
        XmlNodePath temp = dummy;
        while (!temp.isLeaf()) {
            ++totalNodes;
            temp = temp.next();
        }
        dout.writeShort(totalNodes);
        while ((dummy = dummy.next()) != null) {
            String name = dummy.nodeName();
            IOUtil.writeString(dout, name);
        }
    }

    static void writeArg(DefaultMutableTreeNode node) throws Exception {
        ReadXMLTable.writeNode(node, dout);
    }

    static void writeArg(String str) throws Exception {
        IOUtil.writeString(dout, str);
    }

    static DefaultMutableTreeNode readNode() throws Exception {
        return readXml.readNode(din);
    }

    static boolean readBoolean() throws IOException {
        return din.readBoolean();
    }

    static void debug(String d) {
        if (DEBUG) {
            System.out.println("DEBUG: DataRegClient - " + d);
        }
    }

    static {
        readXml = new ReadXMLTable();
        DEBUG = false;
    }
}

