/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server.datareg;

import java.util.StringTokenizer;
import java.util.Vector;
import quadbase.common.server.datareg.DataRegUser;

class DataRegNode {
    private boolean locked = false;
    private DataRegUser lockedUser;
    private Vector lockedChildren;

    DataRegNode() {
    }

    synchronized boolean lock(DataRegUser user) {
        try {
            if (this.lockedUser == null) {
                this.locked = true;
                this.lockedUser = user;
                return true;
            }
            if (this.locked && this.lockedUser.getInfo().isLoggedIn()) {
                String userToken;
                if (this.lockedUser.getHostAddr() == null || user.getHostAddr() == null) {
                    return this.lockedUser.userId() == user.userId();
                }
                if (this.lockedUser.getHostAddr().equals(user.getHostAddr())) {
                    return true;
                }
                String lockedToken = this.getUserToken(this.lockedUser.getHostAddr());
                return lockedToken.equals(userToken = this.getUserToken(user.getHostAddr()));
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.locked = true;
        this.lockedUser = user;
        return true;
    }

    synchronized void unlock(int user) {
        if (this.lockedUser == null || this.lockedUser.userId() != user) {
            return;
        }
        this.locked = false;
        this.lockedUser = null;
    }

    synchronized boolean getState() {
        return this.locked;
    }

    void setLockedChildren(Vector children) {
        this.lockedChildren = children;
    }

    Vector getLockedChildren() {
        return this.lockedChildren;
    }

    private String getUserToken(String hostAddr) {
        int loc = hostAddr.indexOf(63);
        String args = hostAddr.substring(loc + 1);
        StringTokenizer st = new StringTokenizer(args, "&");
        while (st.hasMoreTokens()) {
            String kv = st.nextToken();
            loc = kv.indexOf(61);
            String key = kv.substring(0, loc);
            String val = kv.substring(loc + 1);
            if (!key.equalsIgnoreCase("OrgUserToken")) continue;
            return val;
        }
        return "";
    }

    public DataRegUser getLockedUser() {
        System.out.println("DataRegNode.getLockedUser()-->" + this.lockedUser);
        return this.lockedUser;
    }
}

