/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server.datareg;

import java.util.Hashtable;
import javax.swing.tree.DefaultMutableTreeNode;
import quadbase.common.server.UserInfo;
import quadbase.common.server.datareg.DataRegResult;
import quadbase.common.server.datareg.DataRegState;
import quadbase.common.server.datareg.DataRegUser;
import quadbase.common.server.datareg.NodeLockInfo;
import quadbase.common.server.datareg.XmlNodePath;

public class DataRegServer {
    public static final short OPEN = 100;
    public static final short EDIT_NODE = 101;
    public static final short CLOSE_EDIT_NODE = 102;
    public static final short ADD_NODE = 103;
    public static final short CLOSE_ADD_NODE = 104;
    public static final short CLOSE_ADD_NODE_CANCEL = 105;
    public static final short ADD_NODE_NO_CLOSE = 108;
    public static final short REMOVE_NODE = 106;
    public static final short COPY_NODE = 107;
    public static final short GET_NODE_LOCK = 109;
    public static final short OVERRIDE_NODE_LOCK = 110;
    public static final short GET_OVERRIDE_LOCK_INFO = 111;
    public static final short CLEAR_OVERRIDE = 112;
    static int nextUsr = 0;
    static Hashtable users = new Hashtable();
    static Hashtable dataRegs = new Hashtable();
    static boolean DEBUG = false;

    public static DataRegUser createUser(UserInfo info) {
        DataRegUser u = new DataRegUser(nextUsr);
        u.setInfo(info);
        users.put(nextUsr, u);
        ++nextUsr;
        return u;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DefaultMutableTreeNode openDataReg(DataRegUser usr, String file, String encoding, boolean fromLoadBalancer) {
        file = file.replace('\\', '/');
        DefaultMutableTreeNode root = null;
        DataRegState drState = null;
        Hashtable hashtable = dataRegs;
        synchronized (hashtable) {
            drState = (DataRegState)dataRegs.get(file);
            if (drState == null) {
                DataRegServer.debug("allocating new DataRegState for data registry [" + file + "]");
                drState = new DataRegState(file);
                dataRegs.put(file, drState);
            }
        }
        try {
            drState.setEncoding(encoding);
            root = drState.read(fromLoadBalancer);
            drState.write(root, fromLoadBalancer);
        }
        catch (Exception e) {
            e.printStackTrace();
            return null;
        }
        users.put(usr, drState);
        return root;
    }

    public static DataRegResult editNode(DataRegUser usr, XmlNodePath nodePath, boolean fromLoadBalancer) throws Exception {
        DataRegServer.debug("editNode(usr [" + usr.userId() + "], nodePath [" + nodePath + "])");
        DataRegState drState = (DataRegState)users.get(usr);
        if (drState == null) {
            DataRegServer.debug("editNode did not find DataRegState for user [" + usr.userId() + "]");
            return null;
        }
        DataRegServer.debug("usr [" + usr.userId() + "] obtaining node lock ...");
        NodeLockInfo nodeLockInfo = drState.getNodeLock(usr, nodePath, true, fromLoadBalancer);
        if (nodeLockInfo.canAccess) {
            DataRegServer.debug("usr [" + usr.userId() + "] OBTAINED node lock ...");
            return new DataRegResult(true, drState.read(fromLoadBalancer));
        }
        String lockedUserHostAddr = nodeLockInfo.userHostAddr;
        return new DataRegResult(false, drState.read(fromLoadBalancer), lockedUserHostAddr, nodeLockInfo.nodePath);
    }

    public static void closeEditNode(DataRegUser usr, XmlNodePath nodePath, DefaultMutableTreeNode changedNode, boolean fromLoadBalancer) throws Exception {
        DataRegServer.debug("closeEditNode(usr [" + usr.userId() + "], nodePath [" + nodePath + "], changedNode)");
        DataRegState drState = (DataRegState)users.get(usr);
        DataRegServer.debug("getting DataRegState ...");
        if (drState == null) {
            return;
        }
        DataRegServer.debug("usr [" + usr.userId() + "] WRITING data registry ...");
        drState.write(nodePath, changedNode, false, fromLoadBalancer);
        DataRegServer.debug("usr [" + usr.userId() + "] WRITEEN data registry ...");
        drState.releaseNodeLock(usr.userId(), nodePath, true);
    }

    public static DataRegResult addNode(DataRegUser usr, XmlNodePath parentNodePath, boolean fromLoadBalancer) throws Exception {
        DataRegServer.debug("addNode(usr [" + usr.userId() + "], parentNodePath [" + parentNodePath + "])");
        DataRegState drState = (DataRegState)users.get(usr);
        if (drState == null) {
            DataRegServer.debug("addNode did not find DataRegState for user [" + usr.userId() + "]");
            return null;
        }
        DataRegServer.debug("usr [" + usr.userId() + "] obtaining node lock ...");
        NodeLockInfo nodeLockInfo = drState.getNodeLock(usr, parentNodePath, false, fromLoadBalancer);
        if (nodeLockInfo.canAccess) {
            DataRegServer.debug("usr [" + usr.userId() + "] OBTAINED node lock ...");
            return new DataRegResult(true, drState.read(fromLoadBalancer));
        }
        if (nodeLockInfo.nodePath.indexOf(parentNodePath.toString()) == 0) {
            DataRegServer.debug("usr [" + usr.userId() + "] OBTAINED node lock ...");
            return new DataRegResult(true, drState.read(fromLoadBalancer));
        }
        String lockedUserHostAddr = nodeLockInfo.userHostAddr;
        return new DataRegResult(false, drState.read(fromLoadBalancer), lockedUserHostAddr, nodeLockInfo.nodePath);
    }

    public static void endAddNode(DataRegUser usr, XmlNodePath parentNodePath, DefaultMutableTreeNode childNode, boolean fromLoadBalancer) throws Exception {
        DataRegServer.debug("endAddNode(usr [" + usr.userId() + "], parentNodePath [" + parentNodePath + "], changedNode)");
        DataRegState drState = (DataRegState)users.get(usr);
        DataRegServer.debug("getting DataRegState ...");
        if (drState == null) {
            return;
        }
        DataRegServer.debug("usr [" + usr.userId() + "] WRITING data registry ...");
        if (childNode != null) {
            drState.write(parentNodePath, childNode, true, fromLoadBalancer);
        }
        DataRegServer.debug("usr [" + usr.userId() + "] WRITEEN data registry ...");
        drState.releaseNodeLock(usr.userId(), parentNodePath, false);
    }

    public static DataRegResult addNodeNoClose(DataRegUser usr, XmlNodePath parentNodePath, DefaultMutableTreeNode childNode, boolean fromLoadBalancer) throws Exception {
        DataRegServer.debug("addNodeNoClose(usr [" + usr.userId() + "], parentNodePath [" + parentNodePath + "], changedNode)");
        DataRegState drState = (DataRegState)users.get(usr);
        DataRegServer.debug("getting DataRegState ...");
        if (drState == null) {
            return new DataRegResult(false, drState.read(fromLoadBalancer));
        }
        DataRegServer.debug("usr [" + usr.userId() + "] WRITING data registry ...");
        if (childNode != null) {
            drState.write(parentNodePath, childNode, true, fromLoadBalancer);
        }
        DataRegServer.debug("usr [" + usr.userId() + "] WRITEEN data registry ...");
        return new DataRegResult(true, drState.read(fromLoadBalancer));
    }

    public static DataRegResult removeNode(DataRegUser usr, XmlNodePath nodePath, boolean fromLoadBalancer) throws Exception {
        DataRegServer.debug("removeNode(usr [" + usr.userId() + "], nodePath [" + nodePath + "])");
        DataRegState drState = (DataRegState)users.get(usr);
        if (drState == null) {
            DataRegServer.debug("removeNode did not find DataRegState for user [" + usr.userId() + "]");
            return new DataRegResult(false, drState.read(fromLoadBalancer));
        }
        DataRegServer.debug("usr [" + usr.userId() + "] obtaining node lock ...");
        NodeLockInfo lockInfo = drState.getNodeLock(usr, nodePath, true, fromLoadBalancer);
        if (!lockInfo.canAccess) {
            return new DataRegResult(false, drState.read(fromLoadBalancer));
        }
        DataRegServer.debug("usr [" + usr.userId() + "] OBTAINED node lock ...");
        DataRegServer.debug("usr [" + usr.userId() + "] WRITING data registry ...");
        try {
            drState.write(nodePath, fromLoadBalancer);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DataRegServer.debug("usr [" + usr.userId() + "] WRITEEN data registry ...");
        drState.releaseNodeLock(usr.userId(), nodePath, true);
        return new DataRegResult(true, drState.read(fromLoadBalancer));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static DataRegResult copyNode(DataRegUser usr, XmlNodePath srcNodePath, XmlNodePath destNodePath, String destFile, String srcFile, boolean fromLoadBalancer) throws Exception {
        XmlNodePath parentSrcPath;
        DataRegServer.debug("copyNode(usr [" + usr.userId() + "], src [" + srcNodePath + "], dest [" + destNodePath + "])");
        DataRegServer.debug("[DataRegServer] destFile is " + destFile);
        DataRegState drState = new DataRegState(srcFile);
        if (drState == null) {
            DataRegServer.debug("copyNode did not find DataRegState for user [" + usr.userId() + "]");
            return new DataRegResult(false, drState.read(fromLoadBalancer));
        }
        DataRegServer.debug("usr [" + usr.userId() + "] obtaining node lock ...");
        XmlNodePath tmp = parentSrcPath = srcNodePath.copy();
        while (!tmp.next().isLeaf()) {
            tmp = tmp.next();
        }
        tmp.setNext(null);
        DataRegServer.debug("parentSrcPath [" + parentSrcPath + "]");
        NodeLockInfo nodeLockInfo = drState.getNodeLock(usr, parentSrcPath, false, fromLoadBalancer);
        if (!nodeLockInfo.canAccess) {
            return new DataRegResult(false, drState.read(fromLoadBalancer));
        }
        DataRegState destState = new DataRegState(destFile);
        DataRegServer.debug("usr [" + usr.userId() + "] OBTAINED node lock ...");
        boolean success = false;
        try {
            DataRegServer.debug("usr [" + usr.userId() + "] COPYING node ...");
            DefaultMutableTreeNode root = destState.read(fromLoadBalancer);
            DefaultMutableTreeNode node = DataRegState.findNode(root, destNodePath);
            if (node == null) {
                drState.writeCopy(srcNodePath, destNodePath, destFile, srcFile, fromLoadBalancer);
                success = true;
            }
            DataRegServer.debug("usr [" + usr.userId() + "] COPIED node ...");
        }
        finally {
            drState.releaseNodeLock(usr.userId(), parentSrcPath, true);
        }
        return new DataRegResult(success, drState.read(fromLoadBalancer));
    }

    public static void updateDataReg(DataRegUser usr, DefaultMutableTreeNode root, boolean fromLoadBalancer) throws Exception {
        DataRegServer.debug("updateDataReg(usr [" + usr.userId() + "], root)");
        DataRegState drState = (DataRegState)users.get(usr);
        DataRegServer.debug("getting DataRegState ...");
        if (drState == null) {
            return;
        }
        DataRegServer.debug("usr [" + usr.userId() + "] WRITING data registry ...");
        drState.write(root, fromLoadBalancer);
        DataRegServer.debug("usr [" + usr.userId() + "] WRITEEN data registry ...");
    }

    public static String getUserForLock(DataRegUser user, XmlNodePath nodePath) {
        DataRegState drState = (DataRegState)users.get(user);
        if (drState == null) {
            return "";
        }
        String lockedUser = drState.getLockedUser(nodePath.toString());
        return lockedUser;
    }

    public static String overrideNodeLock(DataRegUser user, XmlNodePath nodePath) {
        DataRegState drState = (DataRegState)users.get(user);
        if (drState == null) {
            return "";
        }
        String result = drState.overrideNodeLock(nodePath, user.getHostAddr());
        return result;
    }

    public static String getOverrideNodeInfo(DataRegUser user, String nodePathStr) {
        DataRegState drState = (DataRegState)users.get(user);
        if (drState == null) {
            return "";
        }
        String userHost = drState.getOverrideNodeInfo(nodePathStr, user.getHostAddr());
        return userHost;
    }

    public static String clearOverrideNode(DataRegUser user) {
        DataRegState drState = (DataRegState)users.get(user);
        if (drState == null) {
            return "";
        }
        String result = drState.clearOverrideNode(user.getHostAddr());
        return result;
    }

    public static Hashtable getUsers() {
        return users;
    }

    static void debug(String s) {
        if (DEBUG) {
            System.out.println("DEBUG: DataRegServer - " + s);
        }
    }
}

