/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server.datareg;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.StringTokenizer;
import java.util.Vector;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeNode;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.server.datareg.DataRegNode;
import quadbase.common.server.datareg.DataRegUser;
import quadbase.common.server.datareg.Lock;
import quadbase.common.server.datareg.NodeLockInfo;
import quadbase.common.server.datareg.NodeStateTable;
import quadbase.common.server.datareg.XmlNodePath;
import quadbase.common.util.internal.CopyFile;
import quadbase.datasourcemanager.manager.BigDataNode;
import quadbase.datasourcemanager.manager.DataViewNode;
import quadbase.datasourcemanager.manager.DataViewQueryNode;
import quadbase.datasourcemanager.manager.DatabaseNode;
import quadbase.datasourcemanager.manager.DefaultDataSourceNode;
import quadbase.datasourcemanager.manager.QueryNode;
import quadbase.datasourcemanager.manager.ReadXMLTable;
import quadbase.datasourcemanager.manager.WriteXMLDataSources;
import quadbase.querybuilder.designer.QueryMain;
import quadbase.reportorganizer.data.OrganizerDataImpl;

public class DataRegState {
    static boolean DEBUG = false;
    private NodeStateTable nodeStates = new NodeStateTable();
    private String filename;
    private File file;
    private String encoding = ServerMessage.xmlEncoding;
    private Lock lock = new Lock();
    private ReadXMLTable readXML = new ReadXMLTable();
    private DefaultMutableTreeNode root;
    private long lastRead = 0L;
    private static final String DATAVIEWFILEEXT = ".dvw";
    private static final String QUERYFILEEXT = ".qry";
    private Hashtable lockedNodeTable = new Hashtable();
    private Hashtable overrideNodeTable = new Hashtable();

    DataRegState(String filename) {
        this.filename = filename;
        this.file = new File(filename);
    }

    void setEncoding(String encoding) {
        this.encoding = encoding;
    }

    String encoding() {
        return this.encoding;
    }

    DefaultMutableTreeNode read(boolean fromLoadBalancer) throws Exception {
        DataRegState.debug("getting read lock...");
        this.lock.getReadLock();
        DataRegState.debug("got read lock");
        try {
            this.readLatest(fromLoadBalancer);
        }
        finally {
            DataRegState.debug("releasing read lock ...");
            this.lock.releaseReadLock();
            DataRegState.debug("released read lock");
        }
        return this.root;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(XmlNodePath nodePath, DefaultMutableTreeNode changedNode, boolean addNode, boolean fromLoadBalancer) throws Exception {
        DataRegState.debug("getting write lock...");
        this.lock.getWriteLock();
        DataRegState.debug("got write lock...");
        try {
            DefaultMutableTreeNode root = this.readXML.getDataSources(this.filename);
            DataRegState.modifyNode(root, nodePath, changedNode, addNode);
            DataRegState.debug("writeDataReg");
            WriteXMLDataSources.writeDataSources(this.filename + "~", root, false, this.encoding, fromLoadBalancer);
            DataRegState.copy(this.filename + "~", this.filename);
            DataRegState.debug("writeDataReg end");
        }
        finally {
            DataRegState.debug("releasing write lock ...");
            this.lock.releaseWriteLock();
            DataRegState.debug("released write lock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void write(XmlNodePath nodePath, boolean fromLoadBalancer) throws Exception {
        DataRegState.debug("getting write lock...");
        this.lock.getWriteLock();
        DataRegState.debug("got write lock...");
        try {
            DefaultMutableTreeNode root = this.readXML.getDataSources(this.filename, fromLoadBalancer);
            DataRegState.removeNode(root, nodePath);
            DataRegState.debug("writeDataReg");
            WriteXMLDataSources.writeDataSources(this.filename + "~", root, false, this.encoding, fromLoadBalancer);
            DataRegState.copy(this.filename + "~", this.filename);
            DataRegState.debug("writeDataReg end");
        }
        finally {
            DataRegState.debug("releasing write lock ...");
            this.lock.releaseWriteLock();
            DataRegState.debug("released write lock");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void writeCopy(XmlNodePath src, XmlNodePath dest, String destFile, String srcFile, boolean fromLoadBalancer) throws Exception {
        DataRegState.debug("getting write lock...");
        this.lock.getWriteLock();
        DataRegState.debug("got write lock...");
        try {
            this.readLatest(fromLoadBalancer);
            DefaultMutableTreeNode srcRoot = this.readXML.getDataSources(srcFile);
            DefaultMutableTreeNode srcNode = DataRegState.findNode(srcRoot, src);
            DefaultMutableTreeNode destNode = this.copyNode(srcNode, dest.getLeafName());
            this.root = this.readXML.getDataSources(destFile);
            this.insertNode(dest, destNode);
            DataRegState.debug("writeDataReg");
            WriteXMLDataSources.writeDataSources(destFile + "~", this.root, false, this.encoding, fromLoadBalancer);
            DataRegState.copy(destFile + "~", destFile);
            DataRegState.debug("writeDataReg end");
        }
        finally {
            DataRegState.debug("releasing write lock ...");
            this.lock.releaseWriteLock();
            DataRegState.debug("released write lock");
        }
    }

    void write(DefaultMutableTreeNode root, boolean fromLoadBalancer) throws Exception {
        DataRegState.debug("getting write lock...");
        this.lock.getWriteLock();
        DataRegState.debug("got write lock...");
        try {
            DataRegState.debug("writeDataReg");
            WriteXMLDataSources.writeDataSources(this.filename + "~", root, false, this.encoding, fromLoadBalancer);
            DataRegState.copy(this.filename + "~", this.filename);
            DataRegState.debug("writeDataReg end");
        }
        finally {
            DataRegState.debug("releasing write lock ...");
            this.lock.releaseWriteLock();
            DataRegState.debug("released write lock");
        }
    }

    String getFilename() {
        return this.filename;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    synchronized NodeLockInfo getNodeLock(DataRegUser user, XmlNodePath nodePath, boolean lockChildren, boolean fromLoadBalancer) throws Exception {
        this.lock.getReadLock();
        NodeLockInfo nodeLockInfo = new NodeLockInfo("", "", true);
        try {
            String lockedUserHost;
            this.readLatest(fromLoadBalancer);
            DefaultMutableTreeNode node = DataRegState.findNode(this.root, nodePath);
            if (node == null) {
                nodeLockInfo.canAccess = false;
            }
            Object obj = this.lockedNodeTable.get(nodePath.toString());
            if (nodeLockInfo.canAccess && obj != null && !(lockedUserHost = ((String[])obj)[0]).equals(user.getHostAddr())) {
                nodeLockInfo.canAccess = false;
                nodeLockInfo.userHostAddr = ((String[])obj)[0];
                nodeLockInfo.nodePath = nodePath.toString();
            }
            String testPathStr = nodePath.toString();
            Enumeration pathEnum = this.lockedNodeTable.keys();
            while (nodeLockInfo.canAccess && pathEnum.hasMoreElements()) {
                String lockedUserHost2;
                String pathStr = (String)pathEnum.nextElement();
                obj = this.lockedNodeTable.get(pathStr);
                if (obj == null || (lockedUserHost2 = ((String[])obj)[0]).equals(user.getHostAddr())) continue;
                if (lockChildren && pathStr.indexOf(testPathStr + "/") == 0) {
                    nodeLockInfo.canAccess = false;
                    nodeLockInfo.userHostAddr = ((String[])obj)[0];
                    nodeLockInfo.nodePath = pathStr;
                    break;
                }
                if (testPathStr.indexOf(pathStr + "/") != 0) continue;
                String[] userInfo = (String[])this.lockedNodeTable.get(pathStr);
                nodeLockInfo.userHostAddr = userInfo[0];
                nodeLockInfo.nodePath = pathStr;
                if (userInfo[1].equals("false")) {
                    nodeLockInfo.canAccess = true;
                    break;
                }
                nodeLockInfo.canAccess = false;
                break;
            }
            if (nodeLockInfo.canAccess) {
                String[] userInfo = new String[]{user.getHostAddr(), lockChildren ? "true" : "false"};
                this.lockedNodeTable.put(testPathStr, userInfo);
            }
        }
        finally {
            this.lock.releaseReadLock();
        }
        return nodeLockInfo;
    }

    synchronized void releaseNodeLock(int user, XmlNodePath nodePath, boolean releaseChildren) {
        String pathStr = nodePath.toString();
        Object obj = this.lockedNodeTable.get(pathStr);
        if (obj != null) {
            this.lockedNodeTable.remove(pathStr);
        }
    }

    synchronized DataRegNode getNodeState(XmlNodePath nodePath) {
        DataRegNode node = this.nodeStates.get(nodePath);
        if (node == null) {
            node = this.nodeStates.put(nodePath);
        }
        return node;
    }

    private void readLatest(boolean fromLoadBalancer) throws Exception {
        if (!this.file.exists()) {
            this.root = ReadXMLTable.getDefaultDataSources();
        } else if (this.lastRead != this.file.lastModified()) {
            this.parseEncoding(this.file);
            this.root = this.readXML.getDataSources(this.filename, fromLoadBalancer);
            try {
                DefaultDataSourceNode dsNode = (DefaultDataSourceNode)this.root;
                try {
                    Integer.parseInt(dsNode.getRegistryID());
                }
                catch (NumberFormatException e) {
                    dsNode.setRegistryID("0");
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    private void parseEncoding(File xml) throws IOException {
        BufferedReader in = new BufferedReader(new FileReader(xml));
        String line = in.readLine();
        int index = line.indexOf("encoding");
        if (index == -1) {
            return;
        }
        int start = line.indexOf(34, index + 8);
        if (start == -1) {
            return;
        }
        int end = line.indexOf(34, start + 1);
        if (end == -1) {
            return;
        }
        this.encoding = line.substring(start + 1, end).trim();
    }

    private void insertNode(XmlNodePath dest, DefaultMutableTreeNode node) {
        if (dest.isLeaf()) {
            return;
        }
        DataRegState.insertNode(this.root, dest, node);
    }

    static void insertNode(DefaultMutableTreeNode root, XmlNodePath dest, DefaultMutableTreeNode node) {
        if (dest.isLeaf()) {
            return;
        }
        Object userObj = root.getUserObject();
        if (userObj == null) {
            return;
        }
        if (!userObj.toString().equals(dest.nodeName())) {
            return;
        }
        if (dest.next().isLeaf()) {
            root.add(node);
        } else {
            for (int i = 0; i < root.getChildCount(); ++i) {
                TreeNode child = root.getChildAt(i);
                DataRegState.insertNode((DefaultMutableTreeNode)child, dest.next(), node);
            }
        }
    }

    private DefaultMutableTreeNode copyNode(DefaultMutableTreeNode node, String newName) {
        if (node == null) {
            return null;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        if (parent.getUserObject().equals("Queries")) {
            parent = (DefaultMutableTreeNode)parent.getParent();
        }
        if (parent == null) {
            return null;
        }
        if (node instanceof QueryNode) {
            return this.getNewQueryNode((QueryNode)node, newName, parent);
        }
        if (node instanceof DataViewNode) {
            return this.getNewDataViewNode((DataViewNode)node, newName, parent);
        }
        if (node instanceof DataViewQueryNode) {
            return this.getNewDataViewQueryNode((DataViewQueryNode)node, newName, parent);
        }
        if (node instanceof DataViewQueryNode) {
            return this.getNewDataViewQueryNode((DataViewQueryNode)node, newName, parent);
        }
        if (node instanceof DatabaseNode) {
            return this.getNewDatabaseNode((DatabaseNode)node, newName, parent);
        }
        return null;
    }

    private DatabaseNode getNewDatabaseNode(DatabaseNode oldNode, String newNodeName, DefaultMutableTreeNode parent) {
        DatabaseNode dbNode = oldNode instanceof BigDataNode ? new BigDataNode(newNodeName) : new DatabaseNode(newNodeName);
        dbNode.setID(this.getNextId());
        dbNode.setDriver(oldNode.getDriver());
        dbNode.setURL(oldNode.getURL());
        dbNode.setUserName(oldNode.getUserName());
        dbNode.setPassword(oldNode.getPassword());
        dbNode.setLoginRequired(oldNode.isLoginRequired());
        dbNode.setAutoJoin(oldNode.isAutoJoin());
        dbNode.setTableNameFormat(oldNode.getTableNameFormat());
        int numChild = oldNode.getChildCount();
        DefaultMutableTreeNode old_parent = parent;
        parent = dbNode;
        for (int i = 0; i < numChild; ++i) {
            DefaultDataSourceNode newNextLevelNode;
            DefaultDataSourceNode oldNextLevelNode = (DefaultDataSourceNode)oldNode.getChildAt(i);
            if (oldNextLevelNode.getUserObject().equals("Queries")) {
                newNextLevelNode = new DefaultDataSourceNode("Queries");
                dbNode.add(newNextLevelNode);
                for (int j = 0; j < oldNextLevelNode.getChildCount(); ++j) {
                    if (!(oldNextLevelNode.getChildAt(j) instanceof QueryNode)) continue;
                    QueryNode oldQueryNode = (QueryNode)oldNextLevelNode.getChildAt(j);
                    QueryNode newQueryNode = this.getNewQueryNode(oldQueryNode, oldQueryNode.getName(), parent);
                    newNextLevelNode.add(newQueryNode);
                }
                continue;
            }
            if (!oldNextLevelNode.getUserObject().equals("Data Views")) continue;
            newNextLevelNode = new DefaultDataSourceNode("Data Views");
            dbNode.add(newNextLevelNode);
            for (int k = 0; k < oldNextLevelNode.getChildCount(); ++k) {
                if (!(oldNextLevelNode.getChildAt(k) instanceof DataViewNode)) continue;
                DataViewNode oldDataViewNode = (DataViewNode)oldNextLevelNode.getChildAt(k);
                DataViewNode newDataViewNode = this.getNewDataViewNode(oldDataViewNode, oldDataViewNode.getName(), parent);
                newNextLevelNode.add(newDataViewNode);
            }
        }
        parent = old_parent;
        DataRegState.debug("DataRegServer dbNode num of Child: " + dbNode.getChildCount());
        return dbNode;
    }

    private QueryNode getNewQueryNode(QueryNode oldNode, String newNodeName, DefaultMutableTreeNode parent) {
        QueryNode newQueryNode = new QueryNode(newNodeName);
        newQueryNode.setID(this.getNextId());
        newQueryNode.setSQL(oldNode.getSQL());
        newQueryNode.setQueryBuilderUsed(oldNode.isQueryBuilderUsed());
        String oldQueryFile = oldNode.getQueryFile();
        if (oldNode.isQueryBuilderUsed() && oldQueryFile != null) {
            String newQueryFile = this.getNewQueryFile(newNodeName, false, false, parent);
            newQueryNode.setQueryFile(newQueryFile);
            CopyFile.copy(QueryMain.QUERYDIR + oldQueryFile + QUERYFILEEXT, QueryMain.QUERYDIR + newQueryFile + QUERYFILEEXT);
        }
        newQueryNode.setDictionaryCompatible(oldNode.isDictionaryCompatible());
        newQueryNode.setInSet(oldNode.getInSet());
        return newQueryNode;
    }

    private DataViewNode getNewDataViewNode(DataViewNode oldNode, String newNodeName, DefaultMutableTreeNode parent) {
        DataViewNode dvNode = new DataViewNode(newNodeName);
        dvNode.setID(this.getNextId());
        dvNode.setSQL(oldNode.getSQL());
        String newQueryFile = this.getNewQueryFile(newNodeName, true, false, parent);
        dvNode.setQueryFile(newQueryFile);
        String oldQueryFile = oldNode.getQueryFile();
        if (oldQueryFile != null) {
            CopyFile.copy(QueryMain.QUERYDIR + oldQueryFile + DATAVIEWFILEEXT, QueryMain.QUERYDIR + newQueryFile + DATAVIEWFILEEXT);
        }
        DefaultMutableTreeNode old_parent = parent;
        parent = dvNode;
        for (int i = 0; i < oldNode.getChildCount(); ++i) {
            if (!(oldNode.getChildAt(i) instanceof DataViewQueryNode)) continue;
            DataViewQueryNode newQuery = this.getNewDataViewQueryNode((DataViewQueryNode)oldNode.getChildAt(i), ((DataViewQueryNode)oldNode.getChildAt(i)).getName(), parent);
            dvNode.add(newQuery);
        }
        parent = old_parent;
        return dvNode;
    }

    private DataViewQueryNode getNewDataViewQueryNode(DataViewQueryNode oldNode, String newNodeName, DefaultMutableTreeNode parent) {
        String newQueryFile;
        DataViewQueryNode dvQueryNode = new DataViewQueryNode(newNodeName);
        dvQueryNode.setID(this.getNextId());
        dvQueryNode.setSQL(oldNode.getSQL());
        String newDataViewFile = this.getNewQueryFile(newNodeName, false, true, parent);
        dvQueryNode.setDataViewFile(newDataViewFile);
        String oldQueryFile = oldNode.getQueryFile();
        String oldDataViewFile = oldNode.getDataViewFile();
        if (oldQueryFile.startsWith("queries/") || oldQueryFile.startsWith("queries\\")) {
            oldQueryFile = QueryMain.QUERYDIR + oldQueryFile.substring(8);
        }
        String tmp = newQueryFile = newDataViewFile + "_query";
        int ct = 0;
        try {
            while (new FileInfo(QueryMain.QUERYDIR + newQueryFile + DATAVIEWFILEEXT).exists()) {
                newQueryFile = tmp + "_" + ct++;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        newQueryFile = QueryMain.QUERYDIR + newQueryFile;
        dvQueryNode.setQueryFile(newQueryFile);
        CopyFile.copy(QueryMain.QUERYDIR + oldDataViewFile + DATAVIEWFILEEXT, QueryMain.QUERYDIR + newDataViewFile + DATAVIEWFILEEXT);
        CopyFile.copy(oldQueryFile + DATAVIEWFILEEXT, newQueryFile + DATAVIEWFILEEXT);
        return dvQueryNode;
    }

    private String getNewQueryFile(String newNodeName, boolean forDataViewNode, boolean forDataViewQueryNode, DefaultMutableTreeNode parent) {
        String ext = forDataViewNode || forDataViewQueryNode ? DATAVIEWFILEEXT : QUERYFILEEXT;
        String fileprefix = this.filename;
        fileprefix = fileprefix.substring(fileprefix.lastIndexOf(47) + 1);
        fileprefix = fileprefix.substring(fileprefix.lastIndexOf(92) + 1);
        fileprefix = fileprefix.substring(0, fileprefix.toUpperCase().indexOf(".XML"));
        fileprefix = forDataViewQueryNode ? fileprefix + "_" + ((DataViewNode)parent).getName() + "_" : fileprefix + "_" + ((DefaultDataSourceNode)parent).getUserObject() + "_";
        String newQueryFile = fileprefix + newNodeName;
        String tmp = newQueryFile = newQueryFile.replace(' ', '_');
        int ct = 0;
        try {
            while (new FileInfo(QueryMain.QUERYDIR + newQueryFile + ext).exists()) {
                newQueryFile = tmp + "_" + ct++;
            }
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
        return newQueryFile;
    }

    static void modifyNode(DefaultMutableTreeNode root, XmlNodePath nodePath, DefaultMutableTreeNode changedNode, boolean addNode) {
        DefaultMutableTreeNode node = DataRegState.findNode(root, nodePath);
        if (node == null) {
            return;
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            String childName = node.getChildAt(i).toString();
            if (childName == null || !childName.equals(changedNode.toString())) continue;
            node.remove(i);
            node.insert(changedNode, i);
            return;
        }
        if (addNode) {
            String nextId = DataRegState.getNextId(root);
            node.add(changedNode);
            ((DefaultDataSourceNode)changedNode).setID(nextId);
            return;
        }
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        for (int i = 0; i < parent.getChildCount(); ++i) {
            if (parent.getChildAt(i) != node) continue;
            parent.remove(i);
            parent.insert(changedNode, i);
            return;
        }
    }

    static String getNextId(DefaultMutableTreeNode root) {
        DefaultDataSourceNode dsNode = (DefaultDataSourceNode)root;
        int lastid = -1;
        try {
            lastid = Integer.parseInt(dsNode.getLastID());
        }
        catch (NumberFormatException e) {
            lastid = DataRegState.getMaxId(root);
        }
        dsNode.setLastID(String.valueOf(++lastid));
        return dsNode.getLastID();
    }

    static int getMaxId(DefaultMutableTreeNode node) {
        int max = -1;
        if (node instanceof DefaultDataSourceNode) {
            DefaultDataSourceNode dn = (DefaultDataSourceNode)node;
            try {
                max = Integer.parseInt(dn.getID());
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
        for (int i = 0; i < node.getChildCount(); ++i) {
            DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
            int temp = DataRegState.getMaxId(child);
            if (temp <= max) continue;
            max = temp;
        }
        return max;
    }

    private String getNextId() {
        return DataRegState.getNextId(this.root);
    }

    static void removeNode(DefaultMutableTreeNode root, XmlNodePath nodePath) {
        DefaultMutableTreeNode node = DataRegState.findNode(root, nodePath);
        DefaultMutableTreeNode parent = (DefaultMutableTreeNode)node.getParent();
        for (int i = 0; i < parent.getChildCount(); ++i) {
            if (parent.getChildAt(i) != node) continue;
            parent.remove(i);
            return;
        }
    }

    static DefaultMutableTreeNode findNode(DefaultMutableTreeNode node, XmlNodePath nodePath) {
        if (node.getUserObject().toString().equals(nodePath.nodeName())) {
            if (nodePath.isLeaf()) {
                return node;
            }
            for (int i = 0; i < node.getChildCount(); ++i) {
                DefaultMutableTreeNode child = (DefaultMutableTreeNode)node.getChildAt(i);
                DefaultMutableTreeNode next = DataRegState.findNode(child, nodePath.next());
                if (next == null) continue;
                return next;
            }
        }
        return null;
    }

    static void copy(String file1, String file2) throws IOException {
        int data;
        File f1 = new File(file1);
        File f2 = new File(file2);
        if (!f1.exists()) {
            return;
        }
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(f1));
        BufferedOutputStream out = new BufferedOutputStream(new FileOutputStream(f2));
        while ((data = ((InputStream)in).read()) != -1) {
            ((OutputStream)out).write(data);
        }
        ((OutputStream)out).flush();
        ((OutputStream)out).close();
    }

    static void swap(String file1, String file2) throws IOException {
        DataRegState.debug("DataRegServer.swap");
        File f1 = new File(file1);
        File f2 = new File(file2);
        while (f1.exists() && !f1.delete()) {
            System.out.println("failed to delete " + f1.getAbsolutePath());
        }
        int attempts = 100;
        while (!f2.renameTo(f1)) {
            if (f1.exists()) {
                f1.delete();
            }
            if (--attempts != 0) continue;
            throw new IOException("failed to rename " + f2.getAbsolutePath() + " to " + f1.getAbsolutePath());
        }
        DataRegState.debug("DataRegServer.swap end after [" + (101 - attempts) + "] attempts to rename");
    }

    static void debug(String s) {
        if (DEBUG) {
            System.out.println("DEBUG: DataRegState - " + s);
        }
    }

    String getLockedUser(String nodePathStr) {
        Object obj = this.lockedNodeTable.get(nodePathStr);
        if (obj != null) {
            String[] userInfo = (String[])obj;
            return userInfo[0];
        }
        String userHost = "";
        Enumeration pathEnum = this.lockedNodeTable.keys();
        while (pathEnum.hasMoreElements()) {
            String pathStr = (String)pathEnum.nextElement();
            obj = this.lockedNodeTable.get(pathStr);
            if (obj == null) continue;
            if (pathStr.indexOf(nodePathStr) == 0) {
                String[] userInfo = (String[])this.lockedNodeTable.get(pathStr);
                userHost = userInfo[0];
                break;
            }
            if (nodePathStr.indexOf(pathStr) != 0) continue;
            String[] userInfo = (String[])this.lockedNodeTable.get(pathStr);
            if (userInfo[1].equals("true")) {
                userHost = userInfo[0];
                break;
            }
            userHost = "";
            break;
        }
        return userHost;
    }

    String overrideNodeLock(XmlNodePath nodePath, String requestMachine) {
        String nodePathStr = nodePath.toString();
        Object obj = this.lockedNodeTable.get(nodePathStr);
        if (obj == null) {
            String[] ss = new String[]{requestMachine, "true"};
            this.lockedNodeTable.put(nodePathStr, ss);
            return "0";
        }
        String lockedMachine = ((String[])obj)[0];
        Hashtable fromAttr = this.parseClientAddress(lockedMachine);
        String fromUserName = (String)fromAttr.get("OrgUserName");
        String fromUserToken = (String)fromAttr.get("OrgUserToken");
        Hashtable currAttr = this.parseClientAddress(requestMachine);
        String currUserName = (String)currAttr.get("OrgUserName");
        String currUserToken = (String)currAttr.get("OrgUserToken");
        if (fromUserName == null || currUserName == null || fromUserToken == null || currUserToken == null) {
            return "";
        }
        if ((fromUserName.equals(currUserName) || OrganizerDataImpl.isAdmin((String)currUserName)) && !fromUserToken.equals(currUserToken)) {
            String[] lockStrs = (String[])obj;
            lockStrs[0] = requestMachine;
            lockStrs[1] = nodePath.isLeaf() ? "false" : "true";
            this.lockedNodeTable.put(nodePathStr, lockStrs);
            obj = this.overrideNodeTable.get(nodePathStr);
            Vector machineList = new Vector();
            if (obj != null) {
                machineList = (Vector)obj;
            }
            boolean found = false;
            for (int i = 0; i < machineList.size(); ++i) {
                if (!lockedMachine.equals(machineList.elementAt(i))) continue;
                found = true;
                break;
            }
            if (!found) {
                machineList.add(lockedMachine);
            }
            this.overrideNodeTable.put(nodePathStr, machineList);
            return "0";
        }
        return "0";
    }

    String getOverrideNodeInfo(String nodePathStr, String currUserHost) {
        Object userHosts = this.overrideNodeTable.get(nodePathStr);
        if (userHosts == null) {
            return "";
        }
        Vector v = (Vector)userHosts;
        for (int i = 0; i < v.size(); ++i) {
            if (!currUserHost.equals(v.elementAt(i))) continue;
            return currUserHost;
        }
        return "";
    }

    String clearOverrideNode(String userHostAddr) {
        Enumeration nodeEnum = this.overrideNodeTable.keys();
        while (nodeEnum.hasMoreElements()) {
            String lockedNodePath = (String)nodeEnum.nextElement();
            Object obj = this.overrideNodeTable.get(lockedNodePath);
            if (obj == null) continue;
            Vector overrideList = (Vector)obj;
            for (int i = overrideList.size() - 1; i >= 0; --i) {
                String hostAddr = (String)overrideList.elementAt(i);
                if (!hostAddr.equals(userHostAddr)) continue;
                overrideList.remove(i);
            }
            if (overrideList.size() == 0) {
                this.overrideNodeTable.remove(lockedNodePath);
                continue;
            }
            this.overrideNodeTable.put(lockedNodePath, overrideList);
        }
        return "";
    }

    void clearDeadOverride() {
    }

    private Hashtable parseClientAddress(String clientAddress) {
        Hashtable<String, String> kvPair = new Hashtable<String, String>();
        int loc = clientAddress.indexOf(63);
        if (loc < 0) {
            kvPair.put("IPAddress", clientAddress);
            return kvPair;
        }
        kvPair.put("IPAddress", clientAddress.substring(0, loc));
        String kvStr = clientAddress.substring(loc + 1);
        StringTokenizer st = new StringTokenizer(kvStr, "&");
        while (st.hasMoreTokens()) {
            String pairStr = st.nextToken();
            loc = pairStr.indexOf(61);
            String key = pairStr.substring(0, loc);
            String val = pairStr.substring(loc + 1);
            kvPair.put(key, val);
        }
        return kvPair;
    }

    static void print(DefaultMutableTreeNode node, String lead) {
        System.out.println(lead + "node name = " + ((DefaultDataSourceNode)node).getUserObject());
        if (node.getChildCount() == 0) {
            return;
        }
        System.out.println();
        for (int i = 0; i < node.getChildCount(); ++i) {
            System.out.print("child [" + i + "]:");
            DataRegState.print((DefaultDataSourceNode)node.getChildAt(i), lead + "  ");
        }
        System.out.println();
    }

    public Hashtable getLockedNodeTable() {
        return this.lockedNodeTable;
    }

    public Hashtable getOverrideNodeTable() {
        return this.overrideNodeTable;
    }
}

