/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server.datareg;

class Lock {
    private int readers = 0;
    private int writers = 0;
    private boolean writing = false;

    public synchronized void getReadLock() throws InterruptedException {
        while (this.writers > 0) {
            this.wait();
        }
        ++this.readers;
    }

    public synchronized void releaseReadLock() {
        --this.readers;
        if (this.readers == 0 && this.writers > 0) {
            this.notifyAll();
        }
    }

    public synchronized void getWriteLock() throws InterruptedException {
        ++this.writers;
        try {
            while (this.readers > 0 || this.writing) {
                this.wait();
            }
            this.writing = true;
        }
        catch (InterruptedException e) {
            --this.writers;
            throw e;
        }
    }

    public synchronized void releaseWriteLock() {
        --this.writers;
        this.writing = false;
        this.notifyAll();
    }
}

