/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server.datareg;

import quadbase.common.server.datareg.DataRegNode;
import quadbase.common.server.datareg.DataRegTreeNode;
import quadbase.common.server.datareg.XmlNodePath;

class NodeStateTable {
    DataRegTreeNode root = new DataRegTreeNode("DataSources");

    NodeStateTable() {
    }

    DataRegNode get(XmlNodePath nodePath) {
        return NodeStateTable.get(this.root, nodePath);
    }

    DataRegNode put(XmlNodePath nodePath) {
        if (!nodePath.nodeName().equals(this.root.name())) {
            throw new IllegalArgumentException("XmlNodePath root must be [DataSources]");
        }
        return NodeStateTable.put(this.root, nodePath);
    }

    private static DataRegNode get(DataRegTreeNode tree, XmlNodePath nodePath) {
        if (!tree.name().equals(nodePath.nodeName())) {
            return null;
        }
        if (nodePath.isLeaf()) {
            return tree.getState();
        }
        for (int i = 0; i < tree.getChildCount(); ++i) {
            DataRegNode temp = NodeStateTable.get(tree.getChildAt(i), nodePath.next());
            if (temp == null) continue;
            return temp;
        }
        return null;
    }

    private static DataRegNode put(DataRegTreeNode tree, XmlNodePath nodePath) {
        if (!tree.name().equals(nodePath.nodeName())) {
            throw new IllegalArgumentException("internal error in put method");
        }
        if (nodePath.isLeaf()) {
            return tree.getState();
        }
        DataRegTreeNode subTree = null;
        String nextNodePath = nodePath.next().nodeName();
        for (int i = 0; i < tree.getChildCount(); ++i) {
            DataRegTreeNode child = tree.getChildAt(i);
            if (!child.name().equals(nextNodePath)) continue;
            subTree = child;
            break;
        }
        if (subTree == null) {
            subTree = new DataRegTreeNode(nextNodePath);
            tree.addChild(subTree);
        }
        return NodeStateTable.put(subTree, nodePath.next());
    }
}

