/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.server.datareg;

import javax.swing.tree.DefaultMutableTreeNode;

public class XmlNodePath {
    private XmlNodePath next;
    private String nodeName;

    public XmlNodePath(String nodeName) {
        this.nodeName = nodeName;
    }

    public String nodeName() {
        return this.nodeName;
    }

    public void setNodeName(String name) {
        this.nodeName = name;
    }

    public boolean isLeaf() {
        return this.next() == null;
    }

    public XmlNodePath next() {
        return this.next;
    }

    public void setNext(XmlNodePath next) {
        this.next = next;
    }

    public void add(String name) {
        XmlNodePath leaf = this;
        while (!leaf.isLeaf()) {
            leaf = leaf.next();
        }
        leaf.setNext(new XmlNodePath(name));
    }

    public XmlNodePath copy() {
        if (this.isLeaf()) {
            return new XmlNodePath(this.nodeName());
        }
        XmlNodePath node = new XmlNodePath(this.nodeName());
        node.setNext(this.next().copy());
        return node;
    }

    public String getLeafName() {
        if (this.isLeaf()) {
            return this.nodeName();
        }
        return this.next().getLeafName();
    }

    public static XmlNodePath valueOf(DefaultMutableTreeNode node) {
        if (node == null) {
            return null;
        }
        XmlNodePath root = new XmlNodePath(node.getUserObject().toString());
        while (!root.nodeName().equals("DataSources")) {
            node = (DefaultMutableTreeNode)node.getParent();
            XmlNodePath temp = new XmlNodePath(node.getUserObject().toString());
            temp.setNext(root);
            root = temp;
        }
        return root;
    }

    public String toString() {
        if (this.isLeaf()) {
            return this.nodeName();
        }
        return this.nodeName + "/" + this.next().toString();
    }
}

