/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.event.MouseEvent;
import quadbase.common.swing.PanelAction;

public class ArrowButton
extends PanelAction {
    public static final int UP = 0;
    public static final int DOWN = 1;
    public static final int LEFT = 2;
    public static final int RIGHT = 3;
    private int direction;
    private boolean mouse_press = false;

    public ArrowButton(int direction) {
        this.addMouseListener(this);
        this.direction = direction;
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(10, 10);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public void paintComponent(Graphics g) {
        int[] ypoints;
        int[] xpoints;
        int width = this.getSize().width;
        int height = this.getSize().height;
        g.setColor(Color.lightGray);
        g.fill3DRect(0, 0, width, height, true);
        if (this.mouse_press) {
            g.setColor(Color.black);
            g.drawLine(0, 0, width, 0);
            g.drawLine(0, 0, 0, height);
            g.setColor(Color.white);
            g.drawLine(width, 0, width, height);
            g.drawLine(0, height, width, height);
        }
        g.setColor(Color.black);
        int w45 = 4 * (width /= 5);
        int h45 = 4 * (height /= 5);
        int w2 = 5 * width / 2;
        int h2 = 5 * height / 2;
        switch (this.direction) {
            case 0: {
                xpoints = new int[]{w2, width, w45};
                ypoints = new int[]{height, h45, h45};
                break;
            }
            case 1: {
                xpoints = new int[]{width, w45, w2};
                ypoints = new int[]{height + 1, height + 1, h45};
                break;
            }
            case 3: {
                xpoints = new int[]{width, w45, width};
                ypoints = new int[]{height, h2, h45};
                break;
            }
            default: {
                xpoints = new int[]{w45, width, w45};
                ypoints = new int[]{height, h2, h45};
            }
        }
        g.fillPolygon(xpoints, ypoints, 3);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        this.mouse_press = true;
        this.fireEvent(this, 0);
        this.repaint();
    }

    @Override
    public void mouseReleased(MouseEvent e) {
        this.mouse_press = false;
        this.repaint();
    }
}

