/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing;

import java.applet.AppletContext;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.JSlider;
import quadbase.common.swing.CanShowHint;

public class ArrowSlideBar
extends JSlider
implements MouseListener {
    private static final double PRECISION = 100.0;
    CanShowHint hint;
    String hintText;
    AppletContext app;

    public ArrowSlideBar(double min, double max, boolean horz) {
        super(horz ? 0 : 1, (int)(min * 100.0), (int)(max * 100.0), (int)(min * 100.0));
    }

    public double getDValue() {
        double val = 1.0 * (double)super.getValue() / 100.0;
        return val;
    }

    public void setDValue(double f) {
        super.setValue((int)(f * 100.0));
    }

    public float getFValue() {
        float val = (float)(1.0 * (double)super.getValue() / 100.0);
        return val;
    }

    public void setFValue(float f) {
        super.setValue((int)((double)f * 100.0));
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
        if (this.hint != null) {
            this.hint.showHint(this.hintText);
        }
        if (this.app != null) {
            this.app.showStatus(this.hintText);
        }
    }

    @Override
    public void mouseExited(MouseEvent e) {
        if (this.hint != null) {
            this.hint.showHint("");
        }
        if (this.app != null) {
            this.app.showStatus("");
        }
    }

    public final void setHint(Object app, String hintText) {
        this.setToolTipText(hintText);
        this.addMouseListener(this);
        if (app instanceof CanShowHint) {
            this.hint = (CanShowHint)app;
            this.hintText = hintText;
        } else if (app instanceof AppletContext) {
            this.app = (AppletContext)app;
            this.hintText = hintText;
        }
    }
}

