/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing;

import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.File;
import javax.swing.AbstractCellEditor;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JTable;
import javax.swing.table.TableCellEditor;
import javax.swing.table.TableCellRenderer;
import quadbase.common.swing.BrowseDialog;

public class BrowseButtonForTableCell
extends AbstractCellEditor
implements TableCellEditor,
TableCellRenderer,
ActionListener {
    JDialog parent;
    String currentPath;
    JButton editButton;
    JButton renderButton;

    public BrowseButtonForTableCell(JDialog parent, String buttonText) {
        this.parent = parent;
        this.editButton = new JButton(buttonText);
        this.editButton.addActionListener(this);
        this.renderButton = new JButton(buttonText);
    }

    @Override
    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        return this.renderButton;
    }

    @Override
    public Object getCellEditorValue() {
        return this.currentPath;
    }

    @Override
    public Component getTableCellEditorComponent(JTable table, Object value, boolean isSelected, int row, int column) {
        this.currentPath = (String)value;
        return this.editButton;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String dir = new File(this.currentPath).getParent();
        BrowseDialog browseDialog = BrowseDialog.create(this.parent, dir);
        browseDialog.setVisible(true);
        String path = browseDialog.getSelectedFile(false);
        if (path != null) {
            this.currentPath = path;
        }
        this.fireEditingStopped();
    }
}

