/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.Graphics2D;
import java.awt.GraphicsConfiguration;
import java.awt.GridLayout;
import java.awt.Image;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.imageio.ImageIO;
import javax.swing.AbstractButton;
import javax.swing.ButtonGroup;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTextField;
import javax.swing.JToggleButton;
import javax.swing.ListCellRenderer;
import javax.swing.border.EmptyBorder;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ReadURL;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LCKey;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.common.util.internal.QbUtil;
import quadbase.common.util.internal.ReadDataFile;
import quadbase.reportorganizer.data.FileList;

public class BrowseDialog
extends JDialog
implements ActionListener,
ItemListener,
ListSelectionListener {
    private static final Logger LOGGER = Logger.getLogger(BrowseDialog.class.getName());
    public static final String SUPPORTED_TYPES = "Supported Types";
    public static final String ALL_TYPES = "All Types";
    private JList filesListBox;
    private String currentDir;
    private String[] validExtension;
    private JButton goUp;
    private JButton myFilesButton;
    private JButton ok;
    private JButton cancel;
    protected JTextField dirField;
    private String selectedFile = null;
    private List<String> selectedFiles = new ArrayList<String>();
    private FileInfo fileInfo;
    private JComboBox rootList;
    private static String separator = "/";
    private static String GO_UP = ".." + separator;
    private static boolean isGoUpEnabled = true;
    private static String defaultDir;
    private String absDefaultDir;
    private boolean absolutePath = true;
    public String rootDir;
    private JToggleButton smallIcon;
    private JToggleButton mediumIcon;
    private JToggleButton largeIcon;
    private static final int SMALL_ICON = 0;
    private static final int MEDIUM_ICON = 1;
    private static final int LARGE_ICON = 2;
    private boolean isImageDialog = false;
    private int iconSize = 0;
    private JComboBox typeField;
    private Map<String, ImageIcon> icons = Collections.synchronizedMap(new HashMap());
    private DownloadImagesThread downloadThread;
    private static final String FILE_IMAGE = "browserimages/file.gif";
    private ImageIcon fileImageIcon;

    protected BrowseDialog(Frame frame, String curDir, String[] ext) {
        this(frame, curDir, ext, true);
    }

    protected BrowseDialog(Frame frame, String curDir, String[] ext, boolean absolutePath) {
        this(frame, curDir, ext, absolutePath, false, null);
    }

    private BrowseDialog(Frame frame, String curDir, String[] ext, boolean absolutePath, boolean imageDialog, String selectedFile) {
        super(frame, LanguageEncoder.getText("Browse Dialog"), true);
        this.setup(curDir, ext, absolutePath, imageDialog, selectedFile);
    }

    private BrowseDialog(JDialog parent, String curDir, String[] ext, boolean absolutePath, boolean imageDialog, String selectedFile) {
        super(parent, LanguageEncoder.getText("Browse Dialog"), true);
        this.setup(curDir, ext, absolutePath, imageDialog, selectedFile);
    }

    public static BrowseDialog create(Frame frame, String curDir) {
        return BrowseDialog.create(frame, curDir, null);
    }

    public static BrowseDialog create(Frame frame, String curDir, String[] ext) {
        return BrowseDialog.create(frame, curDir, ext, false, false);
    }

    public static BrowseDialog create(Frame frame, String curDir, String[] ext, boolean absolutePath, boolean imageDialog) {
        return BrowseDialog.create(frame, curDir, ext, absolutePath, imageDialog, null);
    }

    public static BrowseDialog create(Frame frame, String curDir, String[] ext, boolean absolutePath, boolean imageDialog, String selectedFile) {
        return new BrowseDialog(frame, curDir, ext, absolutePath, imageDialog, selectedFile);
    }

    public static BrowseDialog create(JDialog parent, String curDir) {
        return BrowseDialog.create(parent, curDir, null);
    }

    public static BrowseDialog create(JDialog parent, String curDir, String[] ext) {
        return BrowseDialog.create(parent, curDir, ext, false);
    }

    public static BrowseDialog create(JDialog parent, String curDir, String[] ext, boolean absolutePath) {
        return BrowseDialog.create(parent, curDir, ext, absolutePath, false, null);
    }

    public static BrowseDialog create(JDialog parent, String curDir, String[] ext, boolean absolutePath, boolean imageDialog, String selectedFile) {
        return new BrowseDialog(parent, curDir, ext, absolutePath, imageDialog, selectedFile);
    }

    protected BrowseDialog(Dialog dialog, String curDir, String[] ext, boolean absolutePath) {
        super(dialog, LanguageEncoder.getText("Browse Dialog"), true);
        this.absolutePath = absolutePath;
        this.validExtension = ext == null ? new String[]{"*"} : ext;
        this.currentDir = curDir == null ? "" : curDir;
        this.currentDir = this.currentDir.replace('\\', '/');
        if (defaultDir != null) {
            this.currentDir = defaultDir;
        }
        try {
            this.fileInfo = new FileInfo(this.currentDir);
            if (absolutePath) {
                this.currentDir = this.fileInfo.getAbsolutePath();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rootDir = this.currentDir;
        this.init();
        this.setPosition();
    }

    private void setup(String curDir, String[] ext, boolean absolutePath, boolean imageDialog, String selectedFile) {
        this.absolutePath = absolutePath;
        this.isImageDialog = imageDialog;
        this.validExtension = ext == null ? new String[]{"*"} : ext;
        this.currentDir = curDir == null ? "" : curDir;
        this.currentDir = this.currentDir.replace('\\', '/');
        if (defaultDir != null) {
            this.currentDir = defaultDir;
        }
        try {
            this.fileInfo = new FileInfo(this.currentDir);
            if (absolutePath) {
                this.currentDir = this.fileInfo.getAbsolutePath();
                if (this.currentDir != null) {
                    this.currentDir = this.currentDir.replace('\\', '/');
                }
                String sep = "/";
                int index = this.currentDir.indexOf(92);
                if (index > 0) {
                    sep = "\\";
                }
                if (!this.currentDir.endsWith(sep)) {
                    this.currentDir = this.currentDir + sep;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.rootDir = this.currentDir;
        this.init();
        this.setPosition();
        this.filesListBox.setSelectedValue(selectedFile, true);
        this.listClickedOnce();
    }

    void setPosition() {
        this.pack();
        Dimension screenSize = this.getToolkit().getScreenSize();
        Dimension dim = this.getPreferredSize();
        if (this.isImageDialog) {
            dim.width = screenSize.width / 2;
            dim.height = screenSize.height / 2;
        } else {
            dim.width = screenSize.width / 3;
            dim.height = screenSize.height / 3;
        }
        this.setSize(dim);
        this.setLocationRelativeTo(this.getParent());
    }

    void init() {
        block10: {
            this.setDefaultCloseOperation(2);
            this.dirField = new JTextField(this.currentDir);
            this.dirField.addActionListener(this);
            try {
                String absDir = this.fileInfo.getAbsolutePath();
                this.rootList = new JComboBox<String>(this.fileInfo.listRoots());
                if (this.rootList.getItemCount() <= 0) break block10;
                for (int i = 0; i < this.rootList.getItemCount(); ++i) {
                    if (!absDir.toLowerCase().startsWith(((String)this.rootList.getItemAt(i)).toLowerCase())) continue;
                    this.rootList.setSelectedIndex(i);
                    break;
                }
            }
            catch (Exception ex) {
                if (this.rootList != null) break block10;
                this.rootList = new JComboBox();
            }
        }
        this.rootList.addActionListener(this);
        this.goUp = new JButton();
        this.addNewButton(this.goUp, LanguageEncoder.getText("Go Up"), "NEW", "goUp.gif");
        this.myFilesButton = new JButton(LanguageEncoder.getText("My Files"));
        this.myFilesButton.addActionListener(this);
        this.smallIcon = new JToggleButton();
        this.addNewButton(this.smallIcon, LanguageEncoder.getText("Small Icon"), "NEW", "listIcon.gif");
        this.mediumIcon = new JToggleButton();
        this.addNewButton(this.mediumIcon, LanguageEncoder.getText("Medium Icon"), "NEW", "thumbIcon.gif");
        this.largeIcon = new JToggleButton();
        this.addNewButton(this.largeIcon, LanguageEncoder.getText("Large Icon"), "NEW", "largeIcon.gif");
        this.smallIcon.addItemListener(this);
        this.mediumIcon.addItemListener(this);
        this.largeIcon.addItemListener(this);
        ButtonGroup bg = new ButtonGroup();
        bg.add(this.smallIcon);
        bg.add(this.mediumIcon);
        bg.add(this.largeIcon);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        this.putButtonsIntoPanel(buttonPanel);
        this.filesListBox = new JList();
        this.filesListBox.setLayoutOrientation(0);
        this.setSeparator();
        this.filesListBox.addMouseListener(new MouseAdapter(){

            @Override
            public void mouseClicked(MouseEvent e) {
                if (e.getClickCount() == 1) {
                    BrowseDialog.this.listClickedOnce();
                } else if (e.getClickCount() == 2) {
                    BrowseDialog.this.listClickedTwice();
                }
            }
        });
        this.filesListBox.setCellRenderer(new BrowseItemCellRenderer());
        this.filesListBox.setBackground(Color.white);
        this.filesListBox.setSelectionMode(this.isImageDialog ? 0 : 2);
        this.filesListBox.getSelectionModel().addListSelectionListener(this);
        JScrollPane scrollPane = new JScrollPane(this.filesListBox);
        scrollPane.setHorizontalScrollBarPolicy(31);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        contentPane.setLayout(new BorderLayout());
        JPanel mainPanel = new JPanel();
        mainPanel.setLayout(new BorderLayout());
        mainPanel.add("Center", scrollPane);
        JPanel bottomLeftPanel = new JPanel();
        bottomLeftPanel.setLayout(new GridLayout(-1, 1, 5, 5));
        bottomLeftPanel.add(new JLabel(LanguageEncoder.getText("Files Of Type")));
        JPanel bottomRightPanel = new JPanel();
        bottomRightPanel.setLayout(new GridLayout(-1, 1, 0, 5));
        this.typeField = new JComboBox();
        this.typeField.setEditable(false);
        String extensionStr = this.validExtension[0];
        if (extensionStr.endsWith(SUPPORTED_TYPES)) {
            this.validExtension = FileList.getSupportedFileTypes();
            this.typeField.addItem(extensionStr);
            this.typeField.addItem(ALL_TYPES);
        } else {
            if (!extensionStr.equals("*")) {
                extensionStr = "*." + extensionStr;
            }
            for (int i = 1; i < this.validExtension.length; ++i) {
                extensionStr = extensionStr + ", *." + this.validExtension[i];
            }
            extensionStr = "(" + extensionStr + ")";
            this.typeField.addItem(extensionStr);
        }
        this.typeField.addItemListener(this);
        bottomRightPanel.add(this.typeField);
        if (this.absolutePath && isGoUpEnabled) {
            bottomLeftPanel.add(new JLabel(LanguageEncoder.getText("Drive")));
            bottomRightPanel.add(this.rootList);
        }
        JPanel bottomPanel = new JPanel();
        bottomPanel.setLayout(new BorderLayout());
        bottomPanel.setBorder(new EmptyBorder(5, 0, 5, 0));
        bottomPanel.add("West", bottomLeftPanel);
        bottomPanel.add("Center", bottomRightPanel);
        mainPanel.add("South", bottomPanel);
        contentPane.add("Center", mainPanel);
        JPanel dirSlot = new JPanel();
        dirSlot.setBorder(new EmptyBorder(3, 3, 3, 3));
        dirSlot.setLayout(new BorderLayout());
        dirSlot.add("West", new JLabel(LanguageEncoder.getText("Path")));
        dirSlot.add("Center", this.dirField);
        JPanel sizePanel = new JPanel();
        sizePanel.setLayout(new GridLayout(1, -1, 0, 0));
        sizePanel.add(this.goUp);
        if ((LCKey.isERES() || LCKey.isDashboard()) && this.userFileFolderExists()) {
            sizePanel.add(this.myFilesButton);
        }
        dirSlot.add("East", sizePanel);
        if (this.isImageDialog) {
            sizePanel.add(this.smallIcon);
            sizePanel.add(this.mediumIcon);
            sizePanel.add(this.largeIcon);
            this.iconSize = 2;
            this.setIcon();
        }
        contentPane.add("North", dirSlot);
        contentPane.add("Center", mainPanel);
        contentPane.add("South", buttonPanel);
        this.getFileList(this.currentDir, this.validExtension);
    }

    protected void putButtonsIntoPanel(JPanel panel) {
        this.ok = new JButton(LanguageEncoder.getText("OK"));
        this.cancel = new JButton(LanguageEncoder.getText("Cancel"));
        this.ok.addActionListener(this);
        this.cancel.addActionListener(this);
        panel.add(this.ok);
        panel.add(this.cancel);
    }

    void setIcon() {
        switch (this.iconSize) {
            case 0: {
                this.smallIcon.setSelected(true);
                this.filesListBox.setLayoutOrientation(0);
                break;
            }
            case 1: {
                this.mediumIcon.setSelected(true);
                this.filesListBox.setLayoutOrientation(2);
                this.filesListBox.setVisibleRowCount(-1);
                break;
            }
            case 2: {
                this.largeIcon.setSelected(true);
                this.filesListBox.setLayoutOrientation(2);
                this.filesListBox.setVisibleRowCount(-1);
            }
        }
    }

    private void addNewButton(AbstractButton newBtn, String tip, String command, String img) {
        img = "browserimages/" + img;
        try {
            ImageIcon imageIcon = this.createIcon(img, -1, -1);
            newBtn.setIcon(imageIcon);
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to load image.", e);
        }
        this.add(newBtn);
        newBtn.setToolTipText(tip);
        newBtn.setMargin(new Insets(0, 0, 0, 0));
        newBtn.addActionListener(this);
        newBtn.setActionCommand(command);
    }

    @Override
    public void valueChanged(ListSelectionEvent e) {
        this.listClickedOnce();
    }

    @Override
    public void addNotify() {
        super.addNotify();
        this.filesListBox.validate();
    }

    private void setSeparator() {
        if (this.filesListBox.getModel().getSize() > 0) {
            int len = this.getItem(0).length() - 1;
            if (len < 0) {
                return;
            }
            String tmp = this.getItem(0).substring(len);
            if (tmp.equals("/") || tmp.equals("\\")) {
                separator = tmp.replace('\\', '/');
                GO_UP = ".." + separator;
                this.setupGoUpButton();
            }
        }
    }

    private String getParent(String curDir) {
        String temp;
        if (curDir.trim().equals("") || curDir.trim().endsWith(GO_UP)) {
            temp = curDir + GO_UP;
        } else {
            int sep2;
            int sep1;
            if (!curDir.endsWith(separator)) {
                curDir = curDir + separator;
            }
            temp = (sep1 = curDir.lastIndexOf(separator, (sep2 = curDir.lastIndexOf(separator)) - 1)) == -1 ? "" : curDir.substring(0, sep1 + 1);
        }
        return temp;
    }

    private int getItemCount() {
        return this.filesListBox.getModel().getSize();
    }

    private String getItem(int i) {
        return (String)this.filesListBox.getModel().getElementAt(i);
    }

    private void goUpOneLevel() {
        this.setNewList(this.getParent(this.currentDir), true);
    }

    private void goToMyFilesFolder() {
        if (ServerMessage.getOrgUserName() != null) {
            this.goUp.setEnabled(true);
            this.setNewList("UserFiles/" + ServerMessage.getOrgUserName() + "/", true);
        }
    }

    private boolean userFileFolderExists() {
        FileInfo fileInfo = new FileInfo("UserFiles/" + ServerMessage.getOrgUserName());
        try {
            return fileInfo.exists();
        }
        catch (Exception e) {
            LOGGER.log(Level.WARNING, "Failed to check userfile folder.", e);
            return false;
        }
    }

    public String getSelectedFile() {
        return this.getSelectedFile(true);
    }

    public String getSelectedFile(boolean returnRelative) {
        if (this.selectedFiles != null && this.selectedFiles.size() > 0) {
            this.selectedFile = this.selectedFiles.get(0);
        }
        if (this.selectedFile != null && returnRelative && new File(this.selectedFile).isAbsolute()) {
            String relativeTo;
            try {
                relativeTo = new FileInfo("").getAbsolutePath();
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Browse Dialog - Failed to get an absolute path from FileInfo.", e);
                relativeTo = ServerMessage.getPath("");
            }
            String val = QbUtil.createRelativePath(this.selectedFile, relativeTo);
            if (val != null) {
                return val;
            }
        }
        return this.selectedFile;
    }

    public String getCurrentDirectory() {
        return this.currentDir;
    }

    public void setCurrentDirectory(String dir) {
        this.currentDir = dir;
    }

    public void listClickedOnce() {
        if (this.filesListBox.isSelectionEmpty()) {
            return;
        }
        String file = (String)this.filesListBox.getSelectedValue();
        if (file == null || file.replace('\\', '/').endsWith("../")) {
            return;
        }
        file = file.replace('\\', '/');
        String temp = null;
        if (file.equals(GO_UP)) {
            temp = this.currentDir;
        } else if (!file.endsWith(separator)) {
            temp = this.currentDir.equals("") || this.currentDir.endsWith(separator) ? this.currentDir : this.currentDir + separator;
        }
        if (temp != null) {
            this.dirField.setText(temp + file);
        }
    }

    public void listClickedTwice() {
        if (this.filesListBox.isSelectionEmpty()) {
            return;
        }
        String file = (String)this.filesListBox.getSelectedValue();
        if (file == null) {
            return;
        }
        if ((file = file.replace('\\', '/')).equals(GO_UP)) {
            this.goUpOneLevel();
            return;
        }
        String temp = this.currentDir.equals("") || this.currentDir.endsWith(separator) ? this.currentDir + file : this.currentDir + separator + file;
        if (!file.endsWith(separator)) {
            this.dirField.setText(temp);
            this.selectedFiles.clear();
            this.selectedFiles.add(this.dirField.getText());
            this.selectedFile = this.dirField.getText();
            this.setVisible(false);
            this.dispose();
        } else {
            this.setNewList(temp, true);
        }
    }

    boolean isImage(String link) {
        if (link == null) {
            return false;
        }
        String tmp = link.toUpperCase();
        return tmp.endsWith(".JPG") || tmp.endsWith(".JPEG") || tmp.endsWith(".GIF") || tmp.endsWith(".PNG") || tmp.endsWith(".BMP");
    }

    String createLink(String file) {
        if (this.currentDir.equals("") || this.currentDir.endsWith(separator)) {
            return this.currentDir + file;
        }
        return this.currentDir + separator + file;
    }

    ImageIcon getIconPath(String link, int w, int h, boolean keepRatio) {
        if (this.icons.containsKey(link)) {
            return this.icons.get(link);
        }
        if (LCKey.isERES() || LCKey.isDashboard()) {
            try {
                URL imageUrl = new URL(ServerMessage.getConnectServlet() + ServerMessage.getServletContext() + "/ImageResizeServlet?file=" + BrowseDialog.getAbsolutePath(link.contains("/") ? link : this.createLink(link)) + "&width=" + w + "&height=" + h + "&absolutePath=" + true);
                return new ImageIcon(imageUrl);
            }
            catch (Exception e) {
                LOGGER.log(Level.FINE, "Failed to read image.", e);
            }
        }
        try {
            BufferedImage src = ImageIO.read(new ReadDataFile().getInputStream(link.contains("/") ? link : this.createLink(link)));
            if (src == null) {
                return null;
            }
            return new ImageIcon(this.resizeImage(src, w, h, keepRatio));
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }

    Image resizeImage(Image src, int w, int h, boolean keepRatio) {
        AffineTransform trans;
        GraphicsConfiguration config;
        if (w <= 0 || h <= 0) {
            return src;
        }
        double xScale = (double)w / (double)src.getWidth(null);
        double yScale = (double)h / (double)src.getHeight(null);
        if (keepRatio) {
            if (xScale < yScale) {
                yScale = xScale;
            } else {
                xScale = yScale;
            }
        }
        if ((config = this.getGraphicsConfiguration()) == null) {
            return src;
        }
        BufferedImage buff = config.createCompatibleImage(w, h, 2);
        Graphics2D g = (Graphics2D)buff.getGraphics();
        if (xScale >= 1.0 && yScale >= 1.0) {
            int x = (w - src.getWidth(null)) / 2;
            int y = h - src.getHeight(null);
            trans = new AffineTransform(1.0f, 0.0f, 0.0f, 1.0f, x, y);
        } else {
            trans = AffineTransform.getScaleInstance(xScale, yScale);
        }
        g.drawImage(src, trans, null);
        return buff;
    }

    ImageIcon createIcon(String link, int w, int h) {
        return this.getIconPath(link, w, h, true);
    }

    private void setNewList(String temp, boolean setText) {
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (!isGoUpEnabled && !this.isAllowed(temp)) {
            this.setCursor(Cursor.getPredefinedCursor(0));
            return;
        }
        if (!this.getFileList(temp, this.validExtension)) {
            if (setText) {
                this.dirField.setText(temp);
            } else {
                this.rootList.setSelectedItem(temp);
            }
            return;
        }
        this.currentDir = setText ? temp : this.dirField.getText();
        this.currentDir = this.currentDir.replace('\\', '/');
        if (setText) {
            this.dirField.setText(temp);
        } else {
            this.rootList.setSelectedItem(temp);
        }
        this.filesListBox.clearSelection();
        this.filesListBox.validate();
    }

    private boolean isAllowed(String temp) {
        try {
            FileInfo fileInfo = new FileInfo(temp);
            if (!fileInfo.exists()) {
                return false;
            }
            String tempFile = fileInfo.getAbsolutePath();
            if (this.absDefaultDir == null) {
                FileInfo fileInfo2 = new FileInfo(defaultDir);
                this.absDefaultDir = fileInfo2.getAbsolutePath();
            }
            return tempFile.indexOf(this.absDefaultDir) >= 0;
        }
        catch (Exception ex) {
            return false;
        }
    }

    private boolean getFileList(String dirName, String[] validExtension) {
        String[] filenameList;
        String absDirName = BrowseDialog.getAbsolutePath(dirName);
        String userFilesDir = BrowseDialog.getAbsolutePath("UserFiles/");
        this.setCursor(Cursor.getPredefinedCursor(3));
        if (!ServerMessage.isAdmin() && absDirName.startsWith(userFilesDir) && !absDirName.equals(userFilesDir) && !absDirName.startsWith(userFilesDir + ServerMessage.getOrgUserName())) {
            if (!this.absolutePath) {
                userFilesDir = "UserFiles/";
            }
            this.currentDir = userFilesDir;
            this.dirField.setText(userFilesDir);
            return this.getFileList(userFilesDir, validExtension);
        }
        try {
            filenameList = ReadURL.getFilename(absDirName, validExtension, defaultDir, isGoUpEnabled);
        }
        catch (Exception ex) {
            if (ex.toString().indexOf("You don't currently have permission to access this folder.") >= 0) {
                String msg = LanguageEncoder.getText("You don't currently have permission to access this folder.");
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), msg, 6);
                this.setCursor(Cursor.getPredefinedCursor(0));
                return false;
            }
            ex.printStackTrace();
            this.setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        if (filenameList == null || filenameList.length == 0) {
            this.filesListBox.setListData(filenameList);
            this.setCursor(Cursor.getPredefinedCursor(0));
            return false;
        }
        this.currentDir = dirName;
        if (this.currentDir.trim().equals("")) {
            int len = filenameList.length;
            String[] tempList = new String[len - 1];
            System.arraycopy(filenameList, 1, tempList, 0, len - 1);
            filenameList = tempList;
        }
        if (absDirName.equals(userFilesDir) && !ServerMessage.isAdmin() && filenameList.length > 0) {
            if (this.userFileFolderExists()) {
                String[] tempList = new String[]{filenameList[0], ServerMessage.getOrgUserName() + "/"};
                filenameList = tempList;
            } else {
                String[] tempList = new String[]{filenameList[0]};
                filenameList = tempList;
            }
        }
        if (this.downloadThread != null) {
            this.downloadThread.stopThread();
        }
        this.icons = Collections.synchronizedMap(new HashMap());
        if (this.fileImageIcon == null) {
            this.fileImageIcon = this.createIcon(FILE_IMAGE, -1, -1);
        }
        for (String fname : filenameList) {
            if (!this.isImage(fname)) continue;
            this.icons.put(fname, this.fileImageIcon);
        }
        this.filesListBox.setListData(filenameList);
        if (LCKey.isERES() || LCKey.isDashboard()) {
            this.downloadThread = new DownloadImagesThread();
            this.downloadThread.start();
        }
        this.setupGoUpButton();
        this.setCursor(Cursor.getPredefinedCursor(0));
        return true;
    }

    private void setupGoUpButton() {
        if (this.getItemCount() > 0 && !this.getItem(0).replace('\\', '/').equals(GO_UP)) {
            this.goUp.setEnabled(false);
        } else {
            this.goUp.setEnabled(true);
        }
    }

    public void refreshFileList() {
        this.getFileList(this.currentDir, this.validExtension);
    }

    public static String getAbsolutePath(String path) {
        String absPath = "";
        FileInfo userFilesInfo = new FileInfo(path);
        try {
            absPath = userFilesInfo.getAbsolutePath().replace('\\', '/') + separator;
        }
        catch (Exception e) {
            LOGGER.log(Level.FINE, "Browse Dialog - Failed to get an absolute path from FileInfo.", e);
        }
        return absPath;
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (e.getSource() == this.typeField && e.getStateChange() == 1) {
            String fileTypes = (String)this.typeField.getSelectedItem();
            if (fileTypes.equals(SUPPORTED_TYPES)) {
                this.getFileList(this.currentDir, FileList.getSupportedFileTypes());
            } else if (fileTypes.equals(ALL_TYPES)) {
                this.getFileList(this.currentDir, new String[]{"*"});
            } else {
                this.refreshFileList();
            }
            return;
        }
        if (this.smallIcon.isSelected()) {
            this.iconSize = 0;
            this.filesListBox.setLayoutOrientation(0);
        }
        if (this.mediumIcon.isSelected()) {
            this.iconSize = 1;
            this.filesListBox.setLayoutOrientation(2);
            this.filesListBox.setVisibleRowCount(-1);
        }
        if (this.largeIcon.isSelected()) {
            this.iconSize = 2;
            this.filesListBox.setLayoutOrientation(2);
            this.filesListBox.setVisibleRowCount(-1);
        }
        if (this.iconSize == 2) {
            this.filesListBox.setFixedCellWidth(110);
            this.filesListBox.setFixedCellHeight(120);
        }
        if (this.iconSize == 1) {
            this.filesListBox.setFixedCellWidth(60);
            this.filesListBox.setFixedCellHeight(70);
        } else {
            this.filesListBox.setFixedCellWidth(-1);
            this.filesListBox.setFixedCellHeight(-1);
        }
        this.filesListBox.validate();
        this.filesListBox.repaint();
        this.filesListBox.clearSelection();
        this.filesListBox.validate();
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target == this.cancel) {
            this.setVisible(false);
            this.dispose();
        } else if (target == this.goUp) {
            this.goUpOneLevel();
        } else if (target == this.myFilesButton) {
            this.goToMyFilesFolder();
        } else if (target == this.ok) {
            String fileName = this.dirField.getText();
            if (defaultDir != null) {
                String s1;
                try {
                    s1 = new FileInfo(fileName).getAbsolutePath();
                }
                catch (Exception ex) {
                    LOGGER.log(Level.WARNING, "Failed to get absolute path", ex);
                    s1 = fileName;
                }
                String s2 = defaultDir.replace('\\', '/');
                if (s1.indexOf(s2) != 0) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), "The file path is out side of the preset browse bound");
                    return;
                }
            }
            this.selectedFiles.clear();
            int[] selectedIndices = this.filesListBox.getSelectedIndices();
            String folder = this.dirField.getText().replace('\\', '/');
            if (!folder.endsWith("/") && folder.lastIndexOf("/") != -1) {
                folder = folder.substring(0, folder.lastIndexOf("/") + 1);
            } else if (folder.lastIndexOf("/") == -1) {
                folder = "";
            }
            for (int index : selectedIndices) {
                this.selectedFiles.add(folder + this.getItem(index));
            }
            if (this.selectedFiles.isEmpty()) {
                this.selectedFiles.add(folder);
            }
            this.setVisible(false);
            this.dispose();
        } else if (target == this.dirField) {
            this.setNewList(this.dirField.getText(), false);
        } else if (target == this.rootList) {
            this.setNewList((String)this.rootList.getSelectedItem(), true);
            this.dirField.setText(this.dirField.getText().replace('\\', '/'));
        }
    }

    public List<String> getSelectedFiles() {
        return this.selectedFiles;
    }

    public int getIconWidth() {
        int w = this.iconSize == 1 ? 50 : (this.iconSize == 2 ? 100 : 17);
        return w;
    }

    public int getIconHeight() {
        int h = this.iconSize == 1 ? 50 : (this.iconSize == 2 ? 100 : 13);
        return h;
    }

    public static void setPresetDirectory(String dir) {
        defaultDir = dir;
    }

    public static String getPresetDirectory() {
        return defaultDir;
    }

    public static void setGoUpEnabled(boolean b) {
        isGoUpEnabled = b;
    }

    public static boolean isGoUpEnabled() {
        return isGoUpEnabled;
    }

    public class DownloadImagesThread
    extends Thread {
        private boolean continueDownloadThreadExecution = true;

        public void stopThread() {
            this.continueDownloadThreadExecution = false;
        }

        @Override
        public void run() {
            URL imageUrl = null;
            block4: for (String key : BrowseDialog.this.icons.keySet()) {
                try {
                    imageUrl = new URL(ServerMessage.getConnectServlet() + ServerMessage.getServletContext() + "/ImageResizeServlet?file=" + QbUtil.urlEncode(BrowseDialog.getAbsolutePath(BrowseDialog.this.createLink(key))) + "&width=" + BrowseDialog.this.getIconWidth() + "&height=" + BrowseDialog.this.getIconHeight() + "&absolutePath=" + true);
                }
                catch (MalformedURLException e) {
                    LOGGER.log(Level.WARNING, "Browse Dialog - Cannot read an imageUrl - " + imageUrl, e);
                }
                BufferedImage image = null;
                try {
                    image = ImageIO.read(imageUrl);
                }
                catch (IOException e) {
                    LOGGER.log(Level.WARNING, "Browse Dialog - Cannot read an imageUrl - " + imageUrl, e);
                }
                if (!this.continueDownloadThreadExecution) {
                    return;
                }
                if (image == null) continue;
                BrowseDialog.this.icons.put(key, new ImageIcon(image));
                for (int a = 0; a < BrowseDialog.this.filesListBox.getModel().getSize(); ++a) {
                    String element = (String)BrowseDialog.this.filesListBox.getModel().getElementAt(a);
                    if (!element.equals(key)) continue;
                    BrowseDialog.this.filesListBox.repaint(BrowseDialog.this.filesListBox.getCellBounds(a, a));
                    continue block4;
                }
            }
        }
    }

    class BrowseItemCellRenderer
    extends JLabel
    implements ListCellRenderer {
        private static final long serialVersionUID = -724502884100464552L;
        ImageIcon dirIcon;
        ImageIcon fileIcon;
        String dir = "browserimages/TreeClosed.gif";
        String file = "browserimages/file.gif";

        BrowseItemCellRenderer() {
            if (BrowseDialog.this.isImageDialog) {
                this.dir = "browserimages/TreeClosed_100.gif";
                this.file = "browserimages/file_100.gif";
            }
            this.dirIcon = BrowseDialog.this.createIcon(this.dir, -1, -1);
            this.fileIcon = BrowseDialog.this.createIcon(this.file, -1, -1);
        }

        ImageIcon getDirIcon(int w, int h) {
            if (this.dirIcon == null || this.dirIcon.getIconWidth() != w || this.dirIcon.getIconHeight() != h) {
                this.dirIcon = BrowseDialog.this.createIcon(this.dir, w, h);
            }
            return this.dirIcon;
        }

        ImageIcon getFileIcon(int w, int h) {
            if (this.fileIcon == null || this.fileIcon.getIconWidth() != w || this.fileIcon.getIconHeight() != h) {
                this.fileIcon = BrowseDialog.this.createIcon(this.file, w, h);
            }
            return this.fileIcon;
        }

        public Component getListCellRendererComponent(JList list, Object value, int index, boolean isSelected, boolean celHasFocus) {
            int w = 17;
            int h = 13;
            if (BrowseDialog.this.iconSize == 1) {
                w = 50;
                h = 50;
            } else if (BrowseDialog.this.iconSize == 2) {
                w = 100;
                h = 100;
            }
            String val = ((String)value).replace('\\', '/');
            if (val.endsWith(separator)) {
                this.setIcon(this.getDirIcon(w, h));
            } else if (BrowseDialog.this.isImage(val)) {
                ImageIcon icon = BrowseDialog.this.getIconPath(val, w, h, false);
                if (icon != null) {
                    this.setIcon(icon);
                } else {
                    this.setIcon(this.getFileIcon(w, h));
                }
            } else {
                this.setIcon(this.getFileIcon(w, h));
            }
            if (isSelected) {
                JTextField label = new JTextField("TEMP");
                this.setForeground(label.getSelectedTextColor());
                this.setBackground(label.getSelectionColor());
            } else {
                this.setBackground(list.getBackground());
                this.setForeground(list.getForeground());
            }
            String displayText = val;
            if (displayText.endsWith(separator)) {
                displayText = displayText.substring(0, displayText.length() - 1);
            }
            this.setText(displayText);
            if (BrowseDialog.this.iconSize == 0) {
                this.setVerticalTextPosition(0);
                this.setHorizontalTextPosition(4);
                this.setHorizontalAlignment(2);
                this.setSize(w + 50, h);
            } else {
                this.setVerticalTextPosition(3);
                this.setHorizontalTextPosition(0);
                this.setHorizontalAlignment(0);
                this.setSize(w + 10, h + 20);
            }
            return this;
        }

        @Override
        public boolean isOpaque() {
            return true;
        }
    }
}

