/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing;

import java.awt.BorderLayout;
import java.awt.Button;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.Panel;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Calendar;
import java.util.Date;
import javax.swing.JDialog;
import javax.swing.JLabel;
import javax.swing.JPanel;
import quadbase.common.swing.JCalendar;
import quadbase.common.swing.JSpinField;
import quadbase.common.util.internal.LanguageEncoder;

public class CalendarDialog
extends JDialog
implements ActionListener {
    JCalendar calendar;
    TimePanel timePanel;
    private int sqlType;
    private Button okButton;
    private Button cancelButton;
    private boolean isCancel = true;

    public CalendarDialog(Frame frame, int sqlType) {
        super(frame, LanguageEncoder.getText("Calendar"), true);
        this.sqlType = sqlType;
        this.init();
    }

    public CalendarDialog(Dialog dialog, int sqlType) {
        super(dialog, LanguageEncoder.getText("Calendar"), true);
        this.sqlType = sqlType;
        this.init();
    }

    private void init() {
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        if (this.sqlType == 91) {
            this.calendar = new JCalendar();
            contentPane.add("Center", this.calendar);
        } else if (this.sqlType == 92) {
            this.timePanel = new TimePanel();
            contentPane.add("Center", this.timePanel);
        } else if (this.sqlType == 93) {
            this.calendar = new JCalendar();
            contentPane.add("North", this.calendar);
            this.timePanel = new TimePanel();
            contentPane.add("Center", this.timePanel);
        }
        Panel butPanel = new Panel();
        butPanel.setLayout(new GridLayout(1, 2, 5, 5));
        this.okButton = new Button("Ok");
        butPanel.add(this.okButton);
        this.okButton.addActionListener(this);
        this.cancelButton = new Button("Cancel");
        butPanel.add(this.cancelButton);
        this.cancelButton.addActionListener(this);
        contentPane.add("South", butPanel);
        this.pack();
        Dimension screensize = this.getToolkit().getScreenSize();
        int width = this.getSize().width;
        int height = this.getSize().height;
        this.setBounds((screensize.width - width) / 2, (screensize.height - height) / 2, width, height);
    }

    public void setTime(Date date) {
        Calendar cal = Calendar.getInstance();
        cal.setTime(date);
        if (this.calendar != null) {
            this.calendar.setCalendar(cal);
        }
        if (this.timePanel != null) {
            this.timePanel.setValues(cal);
        }
    }

    public Date getTime() {
        Calendar cal = this.calendar != null ? this.calendar.getCalendar() : Calendar.getInstance();
        if (this.timePanel != null) {
            cal.set(11, this.timePanel.getHour());
            cal.set(12, this.timePanel.getMinute());
            cal.set(13, this.timePanel.getSecond());
            cal.set(14, this.timePanel.getMilliSecond());
        }
        if (this.sqlType == 91) {
            return new java.sql.Date(cal.getTime().getTime());
        }
        if (this.sqlType == 92) {
            return new Time(cal.getTime().getTime());
        }
        if (this.sqlType == 93) {
            return new Timestamp(cal.getTime().getTime());
        }
        return null;
    }

    public boolean isCancelled() {
        return this.isCancel;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.okButton) {
            this.isCancel = false;
        }
        this.setVisible(false);
        this.dispose();
    }

    public class TimePanel
    extends JPanel {
        JSpinField hour;
        JSpinField min;
        JSpinField sec;
        JSpinField msec;

        public TimePanel() {
            this.setLayout(new GridLayout(1, 8, 5, 5));
            this.hour = new JSpinField();
            this.hour.setMinimum(0);
            this.hour.setMaximum(23);
            this.hour.setValue(0);
            this.add(this.hour);
            this.add(new JLabel(LanguageEncoder.getText("HRS")));
            this.min = new JSpinField();
            this.min.setMinimum(0);
            this.min.setMaximum(59);
            this.min.setValue(0);
            this.add(this.min);
            this.add(new JLabel(LanguageEncoder.getText("MINS")));
            this.sec = new JSpinField();
            this.sec.setMinimum(0);
            this.sec.setMaximum(59);
            this.sec.setValue(0);
            this.add(this.sec);
            this.add(new JLabel(LanguageEncoder.getText("SECS")));
            this.msec = new JSpinField();
            this.msec.setMinimum(0);
            this.msec.setMaximum(59);
            this.msec.setValue(0);
            this.add(this.msec);
            this.add(new JLabel(LanguageEncoder.getText("MILLISECS")));
        }

        public int getHour() {
            return this.hour.getValue();
        }

        public int getMinute() {
            return this.min.getValue();
        }

        public int getSecond() {
            return this.sec.getValue();
        }

        public int getMilliSecond() {
            return this.msec.getValue();
        }

        public void setValues(Calendar cal) {
            this.hour.setValue(cal.get(11));
            this.min.setValue(cal.get(12));
            this.sec.setValue(cal.get(13));
            this.msec.setValue(cal.get(14));
        }

        @Override
        public void setEnabled(boolean b) {
            this.hour.setEnabled(b);
            this.min.setEnabled(b);
            this.sec.setEnabled(b);
            this.msec.setEnabled(b);
        }
    }
}

