/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing;

import java.awt.Component;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.awt.event.MouseEvent;
import java.util.EventObject;
import javax.swing.AbstractCellEditor;
import javax.swing.JCheckBox;
import javax.swing.JTree;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.TreeCellEditor;
import javax.swing.tree.TreePath;
import quadbase.common.swing.CheckBoxTreeNode;
import quadbase.common.swing.CheckBoxTreeNodeRenderer;

public class CheckBoxTreeNodeEditor
extends AbstractCellEditor
implements TreeCellEditor {
    private CheckBoxTreeNodeRenderer renderer = new CheckBoxTreeNodeRenderer();
    private JTree tree;

    public CheckBoxTreeNodeEditor(JTree tree) {
        this.tree = tree;
    }

    @Override
    public Object getCellEditorValue() {
        JCheckBox checkbox = this.renderer.getLeafRenderer();
        CheckBoxTreeNode checkBoxNode = new CheckBoxTreeNode(checkbox.getText(), checkbox.isSelected());
        return checkBoxNode;
    }

    @Override
    public boolean isCellEditable(EventObject event) {
        Object node;
        MouseEvent mouseEvent;
        TreePath path;
        boolean returnValue = false;
        if (event instanceof MouseEvent && (path = this.tree.getPathForLocation((mouseEvent = (MouseEvent)event).getX(), mouseEvent.getY())) != null && (node = path.getLastPathComponent()) != null && node instanceof DefaultMutableTreeNode) {
            DefaultMutableTreeNode treeNode = (DefaultMutableTreeNode)node;
            Object userObject = treeNode.getUserObject();
            returnValue = treeNode.isLeaf() && userObject instanceof CheckBoxTreeNode;
        }
        return returnValue;
    }

    @Override
    public Component getTreeCellEditorComponent(JTree tree, Object value, boolean selected, boolean expanded, boolean leaf, int row) {
        Component editor = this.renderer.getTreeCellRendererComponent(tree, value, true, expanded, leaf, row, true);
        ItemListener itemListener = new ItemListener(){

            @Override
            public void itemStateChanged(ItemEvent itemEvent) {
                if (CheckBoxTreeNodeEditor.this.stopCellEditing()) {
                    CheckBoxTreeNodeEditor.this.fireEditingStopped();
                }
            }
        };
        if (editor instanceof JCheckBox) {
            ((JCheckBox)editor).addItemListener(itemListener);
        }
        return editor;
    }
}

