/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.sql.Date;
import java.sql.Time;
import java.sql.Timestamp;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import quadbase.common.swing.LocaleDateTimeDialog;
import quadbase.common.swing.PanelAction;
import quadbase.common.swing.StandardDateTimeDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.DateTimeFormat;
import quadbase.util.IFormat;
import quadbase.util.LocaleDateTimeFormat;

public class DateTimePanel
extends PanelAction
implements ItemListener {
    static Timestamp timestamp_demo = new Timestamp(97, 10, 10, 22, 19, 4, 2000);
    static Time time_demo = new Time(22, 19, 4);
    static Date date_demo = new Date(97, 10, 1);
    JFrame frame;
    JRadioButton chkLocale;
    JRadioButton chkStandard;
    JButton btnFormat;
    boolean showDate;
    boolean showTime;
    boolean showHide;
    DateTimeFormat dtf;
    LocaleDateTimeFormat ldtf;
    ButtonGroup bg;

    public DateTimePanel(JFrame frame, IFormat format, boolean showDate, boolean showTime, boolean showHide) {
        this.frame = frame;
        this.showDate = showDate;
        this.showTime = showTime;
        this.showHide = showHide;
        this.init(format);
    }

    private void init(IFormat format) {
        JPanel plLocale = new JPanel(new FlowLayout(0));
        this.chkLocale = new JRadioButton(LanguageEncoder.getText("Locale-specific"), true);
        plLocale.add(this.chkLocale);
        this.chkLocale.addItemListener(this);
        JPanel plBottom = new JPanel(new BorderLayout());
        JPanel plStandard = new JPanel(new FlowLayout(0));
        this.chkStandard = new JRadioButton(LanguageEncoder.getText("Standard"), false);
        plStandard.add(this.chkStandard);
        this.chkStandard.addItemListener(this);
        this.bg = new ButtonGroup();
        this.bg.add(this.chkLocale);
        this.bg.add(this.chkStandard);
        JPanel plFormat = new JPanel(new FlowLayout(2));
        this.btnFormat = new JButton(LanguageEncoder.getText("Format..."));
        this.btnFormat.addActionListener(this);
        plFormat.add(this.btnFormat);
        plBottom.add("West", plStandard);
        plBottom.add("East", plFormat);
        this.setLayout(new BorderLayout());
        this.add("North", plLocale);
        this.add("South", plBottom);
        if (format instanceof DateTimeFormat) {
            this.dtf = (DateTimeFormat)format;
            this.chkStandard.setSelected(true);
        } else if (format instanceof LocaleDateTimeFormat) {
            this.ldtf = (LocaleDateTimeFormat)format;
            this.chkLocale.setSelected(true);
        } else {
            System.out.println("DateTimePanel: should not happen");
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (!this.chkStandard.isSelected() && !this.chkLocale.isSelected()) {
            return;
        }
        if (this.chkStandard.isSelected()) {
            if (this.dtf == null) {
                this.dtf = new DateTimeFormat();
            }
        } else if (this.chkLocale.isSelected() && this.ldtf == null) {
            if (this.showDate && !this.showTime) {
                this.ldtf = LocaleDateTimeFormat.getDateInstance();
            } else if (!this.showDate && this.showTime) {
                this.ldtf = LocaleDateTimeFormat.getTimeInstance();
            } else if (this.showDate && this.showTime) {
                this.ldtf = LocaleDateTimeFormat.getDateTimeInstance();
            }
        }
        this.fireEvent(this, 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.chkStandard.isSelected() && !this.chkLocale.isSelected()) {
            return;
        }
        this.showFormatDialog();
        this.fireEvent(this, 0);
    }

    private void showFormatDialog() {
        if (this.chkLocale.isSelected()) {
            LocaleDateTimeDialog ldtd = new LocaleDateTimeDialog(this.frame, LanguageEncoder.getText("Locale-specific..."), this.ldtf);
            ldtd.setVisible(true);
            this.ldtf = ldtd.getFormat();
        } else if (this.chkStandard.isSelected()) {
            StandardDateTimeDialog sdtd = new StandardDateTimeDialog(this.frame, LanguageEncoder.getText("Standard..."), this.dtf, this.showDate, this.showTime, this.showHide);
            sdtd.setVisible(true);
            this.dtf = sdtd.getFormat();
        }
    }

    public String formatValue(String value) {
        int spacePos = value.indexOf(32);
        if (this.showTime) {
            int dotPos;
            if (this.showDate) {
                return this.formatValue(Timestamp.valueOf(value));
            }
            if (spacePos != -1) {
                value = value.substring(spacePos + 1);
            }
            if ((dotPos = value.indexOf(46)) != -1) {
                value = value.substring(0, dotPos);
            }
            return this.formatValue(Time.valueOf(value));
        }
        if (spacePos != -1) {
            value = value.substring(0, spacePos);
        }
        return this.formatValue(Date.valueOf(value));
    }

    public String formatValue(Date value) {
        return this.getFormat().format(value);
    }

    public String formatValue(Time value) {
        return this.getFormat().format(value);
    }

    public String formatValue(Timestamp value) {
        return this.getFormat().format(value);
    }

    public IFormat getFormat() {
        if (this.chkLocale.isSelected()) {
            return this.ldtf;
        }
        if (this.chkStandard.isSelected()) {
            return this.dtf;
        }
        return null;
    }

    public String getSampleText() {
        if (this.showTime) {
            if (this.showDate) {
                return this.formatValue(timestamp_demo);
            }
            return this.formatValue(time_demo);
        }
        return this.formatValue(date_demo);
    }
}

