/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing;

import java.awt.BorderLayout;
import java.awt.Font;
import java.awt.GraphicsEnvironment;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.TitledBorder;
import quadbase.common.swing.PanelAction;
import quadbase.common.swing.SpinBox;
import quadbase.common.util.internal.LanguageEncoder;

public class FontPanel
extends PanelAction
implements ItemListener {
    JComboBox ftypeChoice;
    JComboBox fstyleChoice;
    SpinBox fsizeSpinner;
    SpinBox fangleSpinner;
    String[] fontList;
    int size = 10;
    int angle;
    boolean settingFont = false;
    int lastTypeIdx = -1;
    int lastStyleIdx = -1;

    public FontPanel(Font font) {
        this(font, 0);
    }

    public FontPanel(Font font, int angle) {
        this.angle = angle;
        if (font != null) {
            this.size = font.getSize();
        }
        this.setLayout(new BorderLayout());
        JPanel fpanel = new JPanel();
        fpanel.setBorder(new TitledBorder(LanguageEncoder.getText("Font")));
        this.ftypeChoice = new JComboBox();
        this.fstyleChoice = new JComboBox();
        this.fontList = GraphicsEnvironment.getLocalGraphicsEnvironment().getAvailableFontFamilyNames();
        for (int i = 0; i < this.fontList.length; ++i) {
            this.ftypeChoice.addItem(this.getDisplayName(this.fontList[i]));
        }
        this.fstyleChoice.addItem(LanguageEncoder.getText("Plain"));
        this.fstyleChoice.addItem(LanguageEncoder.getText("Bold"));
        this.fstyleChoice.addItem(LanguageEncoder.getText("Italic"));
        this.fstyleChoice.addItem(LanguageEncoder.getText("Bolditalic"));
        fpanel.setLayout(new BorderLayout(0, 5));
        fpanel.add("North", this.ftypeChoice);
        fpanel.add("Center", this.fstyleChoice);
        JPanel gridpanel = new JPanel();
        gridpanel.setLayout(new GridLayout(2, 2, 0, 5));
        gridpanel.add(new JLabel(LanguageEncoder.getText("Size") + " "));
        this.fsizeSpinner = new SpinBox(4, 500);
        gridpanel.add(this.fsizeSpinner);
        gridpanel.add(new JLabel(LanguageEncoder.getText("Angle")));
        this.fangleSpinner = new SpinBox(-360, 360);
        gridpanel.add(this.fangleSpinner);
        fpanel.add("South", gridpanel);
        this.add("Center", fpanel);
        this.setFont(font, angle);
        this.ftypeChoice.addItemListener(this);
        this.fstyleChoice.addItemListener(this);
        this.fangleSpinner.addActionListener(this);
        this.fsizeSpinner.addActionListener(this);
    }

    public void setNewFont(Font font) {
        this.setFont(font, 0);
    }

    public void setAngle(int angle) {
        this.angle = angle;
        this.fangleSpinner.setValue(angle);
    }

    @Override
    public void setEnabled(boolean enable) {
        this.ftypeChoice.setEnabled(enable);
        this.fstyleChoice.setEnabled(enable);
        this.fsizeSpinner.setEnabled(enable);
        this.fangleSpinner.setEnabled(enable);
    }

    public void setFont(Font font, int angle) {
        this.angle = angle;
        if (font != null) {
            this.settingFont = true;
            this.size = font.getSize();
            this.ftypeChoice.setSelectedIndex(this.getName(font.getName()));
            this.fstyleChoice.setSelectedIndex(font.getStyle());
            this.lastTypeIdx = this.ftypeChoice.getSelectedIndex();
            this.lastStyleIdx = this.fstyleChoice.getSelectedIndex();
            this.fsizeSpinner.setValue(this.size);
            this.settingFont = false;
            this.setEnabled(true);
        }
        this.fangleSpinner.setValue(angle);
    }

    public int getAngle() {
        return this.angle;
    }

    public Font getNewFont() {
        return new Font(this.fontList[this.ftypeChoice.getSelectedIndex()], this.fstyleChoice.getSelectedIndex(), this.size);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (this.settingFont) {
            return;
        }
        if (e.getSource() == this.fsizeSpinner) {
            this.size = this.fsizeSpinner.getValue();
        } else {
            this.angle = this.fangleSpinner.getValue();
        }
        this.fireEvent(this, 0);
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.settingFont) {
            return;
        }
        if (this.ftypeChoice.getSelectedIndex() == this.lastTypeIdx && this.fstyleChoice.getSelectedIndex() == this.lastStyleIdx) {
            return;
        }
        this.lastTypeIdx = this.ftypeChoice.getSelectedIndex();
        this.lastStyleIdx = this.fstyleChoice.getSelectedIndex();
        this.fireEvent(this, 0);
    }

    int getName(String str) {
        int lastDot = (str = str.toLowerCase()).lastIndexOf(46);
        if (lastDot > -1) {
            str = str.substring(0, lastDot);
        }
        for (int i = 0; i < this.fontList.length; ++i) {
            if (!str.equals(this.fontList[i].toLowerCase())) continue;
            return i;
        }
        String[] newFontList = new String[this.fontList.length + 1];
        for (int i = 0; i < this.fontList.length; ++i) {
            newFontList[i] = this.fontList[i];
        }
        newFontList[this.fontList.length] = str;
        this.ftypeChoice.addItem(this.getDisplayName(str));
        this.fontList = newFontList;
        return newFontList.length - 1;
    }

    private String getDisplayName(String orgName) {
        if (orgName.length() > 15) {
            return orgName.substring(0, 12) + "...";
        }
        return orgName;
    }
}

