/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing;

import java.awt.Color;
import java.awt.FlowLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.event.EventListenerList;
import quadbase.common.swing.HexUpdateEvent;
import quadbase.common.swing.HexUpdateEventListener;
import quadbase.common.swing.JTextFieldLimit;
import quadbase.common.util.internal.HexColor;
import quadbase.common.util.internal.LanguageEncoder;

public class HexPanel
extends JPanel {
    private JTextField txtHexCode;
    private JLabel lHexcode;
    private JLabel message;
    private Color updatedColor;
    private boolean isHexField;
    protected EventListenerList listenerList = new EventListenerList();

    public JTextField getTxtHexCode() {
        return this.txtHexCode;
    }

    public void setTxtHexCode(JTextField txtHexCode) {
        this.txtHexCode = txtHexCode;
    }

    public boolean isHexField() {
        return this.isHexField;
    }

    public void setIsHexField(boolean isHexField) {
        this.isHexField = isHexField;
    }

    public void setUpdatedColor(Color updatedColor) {
        this.updatedColor = updatedColor;
    }

    public Color getUpdatedColor() {
        return this.updatedColor;
    }

    public HexPanel(Color color) {
        this.setLayout(new FlowLayout(0));
        this.lHexcode = new JLabel(LanguageEncoder.getText("Hex #"));
        this.lHexcode.setToolTipText("RRGGBB or RGB, i.e. ffffff or fff");
        this.add(this.lHexcode);
        this.txtHexCode = new JTextField(7);
        this.txtHexCode.setDocument(new JTextFieldLimit(7));
        if (color != null && !color.equals(this.getUpdatedColor())) {
            this.updateTxtHexcode(color);
        }
        this.txtHexCode.setToolTipText("RRGGBB or RGB, i.e. ffffff or fff");
        this.txtHexCode.getDocument().addDocumentListener(new MyDocumentListener());
        this.add(this.txtHexCode);
        this.message = new JLabel(LanguageEncoder.getText("RRGGBB/RGB"));
        this.message.setForeground(Color.DARK_GRAY);
        this.add(this.message);
        this.setIsHexField(false);
        if (this.updatedColor == null) {
            this.updatedColor = color;
        }
    }

    public void addHexUpdateEventListener(HexUpdateEventListener listener) {
        this.listenerList.add(HexUpdateEventListener.class, listener);
    }

    public void removeHexUpdateEventListener(HexUpdateEventListener listener) {
        this.listenerList.remove(HexUpdateEventListener.class, listener);
    }

    void fireHexUpdateEvent(HexUpdateEvent evt) {
        Object[] listeners = this.listenerList.getListenerList();
        for (int i = 0; i < listeners.length; i += 2) {
            if (listeners[i] != HexUpdateEventListener.class) continue;
            ((HexUpdateEventListener)listeners[i + 1]).hexUpdated(evt);
        }
    }

    public void updateTxtHexcode(Color color) {
        if (color == null) {
            return;
        }
        if (!this.isHexField) {
            String rgb = Integer.toHexString(color.getRGB());
            rgb = rgb.substring(2, rgb.length());
            this.txtHexCode.setText(rgb);
        }
    }

    class MyDocumentListener
    implements DocumentListener {
        MyDocumentListener() {
        }

        @Override
        public void insertUpdate(DocumentEvent e) {
            this.check();
        }

        @Override
        public void removeUpdate(DocumentEvent e) {
            this.check();
        }

        @Override
        public void changedUpdate(DocumentEvent e) {
            this.check();
        }

        public void check() {
            HexPanel.this.isHexField = true;
            String hexCode = HexPanel.this.txtHexCode.getText();
            if (!hexCode.startsWith("#")) {
                hexCode = "#" + hexCode;
            }
            if (HexColor.validate(hexCode)) {
                HexPanel.this.setUpdatedColor(HexColor.decode(hexCode));
                HexUpdateEvent evt = new HexUpdateEvent(HexPanel.this.txtHexCode);
                HexPanel.this.fireHexUpdateEvent(evt);
                HexPanel.this.message.setText("RRGGBB/RGB");
                HexPanel.this.message.setForeground(Color.DARK_GRAY);
                HexPanel.this.txtHexCode.setToolTipText("RRGGBB or RGB, i.e. ffffff or fff");
                HexPanel.this.lHexcode.setToolTipText("RRGGBB or RGB, i.e. ffffff or fff");
            } else {
                HexPanel.this.txtHexCode.setToolTipText("Invalid hex color code. valid format: RRGGBB or RGB. valid input: 0~9, A~F");
                HexPanel.this.lHexcode.setToolTipText("Invalid hex color code. valid format: RRGGBB or RGB. valid input: 0~9, A~F");
                HexPanel.this.message.setText("Invalid");
                HexPanel.this.message.setForeground(Color.RED);
            }
        }
    }
}

