/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing;

import java.awt.Canvas;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Toolkit;
import java.awt.image.ImageObserver;
import java.net.URL;
import quadbase.common.util.internal.LanguageEncoder;

public class ImageCanvas
extends Canvas
implements ImageObserver {
    private Image im = null;
    private URL url = null;
    private String justify = "Center";
    private boolean bDontCheck = false;

    public ImageCanvas() {
    }

    public ImageCanvas(URL uRL) {
        this.getImage(uRL);
    }

    public ImageCanvas(Image im) {
        this.im = im;
    }

    public void setJustify(String string) {
        this.justify = string;
    }

    public void getImage(URL imURL) {
        try {
            this.im = Toolkit.getDefaultToolkit().getImage(imURL);
            this.prepareImage(this.im, this);
            this.url = imURL;
        }
        catch (Exception ex) {
            System.out.println("Failed to load " + imURL);
            this.im = null;
            this.url = null;
        }
    }

    public void clear() {
        this.im = null;
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        int y;
        int x;
        Dimension d = this.getSize();
        if (this.im == null) {
            g.drawString(LanguageEncoder.getText("No Image"), 10, d.height / 2);
            return;
        }
        if (!this.bDontCheck && (this.checkImage(this.im, null) & 0x20) == 0) {
            g.drawString(LanguageEncoder.getText("Loading") + (this.url == null ? LanguageEncoder.getText("something") : this.url.getFile()), 10, d.height / 2);
            return;
        }
        int w = this.im.getWidth(null);
        int h = this.im.getHeight(null);
        if (this.justify.equals("Left")) {
            x = 0;
            y = (d.height - h) / 2;
        } else if (this.justify.equals("Right")) {
            x = d.width - w;
            y = (d.height - h) / 2;
        } else if (this.justify.equals("Top")) {
            x = (d.width - w) / 2;
            y = 0;
        } else if (this.justify.equals("Bottom")) {
            x = (d.width - w) / 2;
            y = d.height - h;
        } else if (this.justify.equals("Fill")) {
            x = 0;
            y = 0;
            w = d.width;
            h = d.height;
        } else {
            x = (d.width - w) / 2;
            y = (d.height - h) / 2;
        }
        g.drawImage(this.im, x, y, w, h, this);
    }

    @Override
    public boolean imageUpdate(Image image, int info, int x, int y, int w, int h) {
        if ((info & 0x20) <= 0) {
            return true;
        }
        for (Container container = this.getParent(); container != null; container = container.getParent()) {
            container.doLayout();
        }
        this.repaint();
        return false;
    }

    @Override
    public Dimension getPreferredSize() {
        if (this.im == null) {
            return new Dimension(300, 25);
        }
        if (!this.bDontCheck && (this.checkImage(this.im, null) & 0x20) <= 0) {
            return new Dimension(300, 25);
        }
        int i = this.im.getWidth(null);
        int j = this.im.getHeight(null);
        return new Dimension(i, j);
    }
}

