/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing;

import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import java.text.DateFormatSymbols;
import java.util.Calendar;
import java.util.Locale;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import quadbase.common.swing.JDayChooser;

public class JMonthChooser
extends JComboBox
implements ItemListener {
    private Locale locale;
    private int month;
    private JDayChooser dayChooser;
    private boolean initialized = false;

    public JMonthChooser() {
        this.addItemListener(this);
        this.dayChooser = null;
        this.locale = Locale.getDefault();
        this.initNames();
        this.setMonth(Calendar.getInstance().get(2));
        this.initialized = true;
    }

    public void initNames() {
        DateFormatSymbols dateFormatSymbols = new DateFormatSymbols(this.locale);
        String[] monthNames = dateFormatSymbols.getMonths();
        if (this.getItemCount() == 12) {
            this.removeAllItems();
        }
        for (int i = 0; i < 12; ++i) {
            this.addItem(monthNames[i]);
        }
        this.setSelectedIndex(this.month);
    }

    @Override
    public void itemStateChanged(ItemEvent iEvt) {
        int index = this.getSelectedIndex();
        if (index >= 0) {
            this.setMonth(index, false);
        }
    }

    private void setMonth(int newMonth, boolean select) {
        int oldMonth = this.month;
        this.month = newMonth;
        if (select) {
            this.setSelectedIndex(this.month);
        }
        if (this.dayChooser != null) {
            this.dayChooser.setMonth(this.month);
        }
        this.firePropertyChange("month", oldMonth, this.month);
    }

    public void setMonth(int newMonth) {
        this.setMonth(newMonth, true);
    }

    public int getMonth() {
        return this.month;
    }

    public void setDayChooser(JDayChooser dayChooser) {
        this.dayChooser = dayChooser;
    }

    @Override
    public Locale getLocale() {
        return this.locale;
    }

    @Override
    public void setLocale(Locale l) {
        if (!this.initialized) {
            super.setLocale(l);
        } else {
            this.locale = l;
            this.initNames();
        }
    }

    public static void main(String[] s) {
        JFrame frame = new JFrame("MonthChooser");
        frame.getContentPane().add(new JMonthChooser());
        frame.pack();
        frame.setVisible(true);
    }
}

