/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.Point;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.BorderFactory;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIManager;
import javax.swing.border.Border;
import javax.swing.plaf.BorderUIResource;
import javax.swing.table.AbstractTableModel;
import javax.swing.table.DefaultTableCellRenderer;
import javax.swing.table.DefaultTableModel;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;
import quadbase.common.swing.SwingUtil;
import quadbase.common.util.internal.LanguageEncoder;

public class JSpreadsheetTable
extends JScrollPane {
    private JTable table = null;
    private JTable rowHeaders;
    private Object[][] data;
    private String[] columnNames;

    public JSpreadsheetTable(Object[][] data, String[] columnNames) {
        super(20, 30);
        this.data = data;
        this.columnNames = columnNames;
        if (data == null || data.length == 0) {
            this.createEmptyDataPanel();
        } else {
            this.init();
        }
    }

    public int getFirstSelectedRowIndex() {
        if (this.table == null) {
            return -1;
        }
        return this.table.getSelectionModel().getMinSelectionIndex();
    }

    public int getLastSelectedRowIndex() {
        if (this.table == null) {
            return -1;
        }
        return this.table.getSelectionModel().getMaxSelectionIndex();
    }

    public int getFirstSelectedColumnIndex() {
        if (this.table == null) {
            return -1;
        }
        return this.table.getColumnModel().getSelectionModel().getMinSelectionIndex();
    }

    public int getLastSelectedColumnIndex() {
        if (this.table == null) {
            return -1;
        }
        return this.table.getColumnModel().getSelectionModel().getMaxSelectionIndex();
    }

    public void setSelection(int minRow, int minColumn, int maxRow, int maxColumn) {
        if (this.table == null) {
            return;
        }
        if (minRow < 0 || minColumn < 0 || maxRow < 0 || maxColumn < 0) {
            this.clearSelection();
        } else {
            this.table.getColumnModel().getSelectionModel().setSelectionInterval(minColumn, maxColumn);
            this.table.getSelectionModel().setSelectionInterval(minRow, maxRow);
        }
    }

    public void clearSelection() {
        this.table.clearSelection();
    }

    public int getRowCount() {
        if (this.table == null) {
            return -1;
        }
        return this.table.getRowCount();
    }

    public int getColumnCount() {
        if (this.table == null) {
            return -1;
        }
        return this.table.getColumnCount();
    }

    private void createEmptyDataPanel() {
        JPanel p = new JPanel(new BorderLayout());
        p.setBorder(BorderFactory.createEmptyBorder(20, 20, 20, 20));
        JLabel l = new JLabel(LanguageEncoder.getText("No data available"));
        p.add("Center", l);
        this.setViewportView(p);
    }

    @Override
    public synchronized void addMouseListener(MouseListener mouselistener) {
        super.addMouseListener(mouselistener);
        if (this.table != null) {
            this.table.addMouseListener(mouselistener);
            this.table.getTableHeader().addMouseListener(mouselistener);
        }
        if (this.rowHeaders != null) {
            this.rowHeaders.addMouseListener(mouselistener);
        }
        if (this.getCorner("UPPER_LEFT_CORNER") != null) {
            this.getCorner("UPPER_LEFT_CORNER").addMouseListener(mouselistener);
        }
    }

    private void init() {
        NotEditableTableModel model = new NotEditableTableModel(this.data, this.columnNames);
        this.table = new JTable(model);
        this.table.getTableHeader().addMouseListener(new SelectColumnMouseListener());
        this.table.getTableHeader().setReorderingAllowed(false);
        this.table.setColumnSelectionAllowed(true);
        this.table.setRowSelectionAllowed(true);
        this.table.setSelectionMode(1);
        SwingUtil.calcColumnWidths(this.table);
        RowNumberModel rowModel = new RowNumberModel(this.data.length);
        this.rowHeaders = new JTable(rowModel);
        this.rowHeaders.addMouseListener(new SelectRowMouseListener());
        this.rowHeaders.getTableHeader().setReorderingAllowed(false);
        this.rowHeaders.setRowSelectionAllowed(false);
        this.rowHeaders.setColumnSelectionAllowed(false);
        this.rowHeaders.getColumnModel().getColumn(0).setCellRenderer(new RowHeaderCellRenderer());
        Dimension d = this.rowHeaders.getPreferredScrollableViewportSize();
        d.width = this.rowHeaders.getPreferredSize().width;
        this.rowHeaders.setPreferredScrollableViewportSize(d);
        this.rowHeaders.setIntercellSpacing(new Dimension(0, 0));
        this.rowHeaders.getTableHeader().addMouseListener(new SelectAllMouseListener());
        this.setViewportView(this.table);
        this.setRowHeaderView(this.rowHeaders);
        this.setCorner("UPPER_LEFT_CORNER", this.rowHeaders.getTableHeader());
    }

    private void handleSelectionKeys(MouseEvent e, ListSelectionModel selection, int index) {
        if (e.isShiftDown()) {
            int anchor = selection.getAnchorSelectionIndex();
            int lead = selection.getLeadSelectionIndex();
            if (anchor != -1) {
                boolean old = selection.getValueIsAdjusting();
                selection.setValueIsAdjusting(true);
                boolean anchorSelected = selection.isSelectedIndex(anchor);
                if (lead != -1) {
                    if (anchorSelected) {
                        selection.removeSelectionInterval(anchor, lead);
                    } else {
                        selection.addSelectionInterval(anchor, lead);
                    }
                }
                if (anchorSelected) {
                    selection.addSelectionInterval(anchor, index);
                } else {
                    selection.removeSelectionInterval(anchor, index);
                }
                selection.setValueIsAdjusting(old);
            } else {
                selection.setSelectionInterval(index, index);
            }
        } else if (e.isControlDown()) {
            if (selection.isSelectedIndex(index)) {
                selection.removeSelectionInterval(index, index);
            } else {
                selection.addSelectionInterval(index, index);
            }
        } else {
            selection.setSelectionInterval(index, index);
        }
    }

    private class SelectColumnMouseListener
    extends MouseAdapter {
        private SelectColumnMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            JTableHeader header = JSpreadsheetTable.this.table.getTableHeader();
            TableColumnModel columns = header.getColumnModel();
            if (!columns.getColumnSelectionAllowed()) {
                return;
            }
            int column = header.columnAtPoint(e.getPoint());
            if (column == -1) {
                return;
            }
            int count = JSpreadsheetTable.this.table.getRowCount();
            if (count != 0) {
                JSpreadsheetTable.this.table.setRowSelectionInterval(0, count - 1);
            }
            ListSelectionModel selection = columns.getSelectionModel();
            JSpreadsheetTable.this.handleSelectionKeys(e, selection, column);
        }
    }

    private class SelectRowMouseListener
    extends MouseAdapter {
        private SelectRowMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!JSpreadsheetTable.this.table.getRowSelectionAllowed() || !e.getComponent().isEnabled() || e.getButton() != 1) {
                return;
            }
            Point p = e.getPoint();
            ListSelectionModel columnModel = JSpreadsheetTable.this.table.getColumnModel().getSelectionModel();
            columnModel.setSelectionInterval(0, JSpreadsheetTable.this.table.getColumnCount() - 1);
            int row = JSpreadsheetTable.this.rowHeaders.rowAtPoint(p);
            ListSelectionModel selection = JSpreadsheetTable.this.table.getSelectionModel();
            JSpreadsheetTable.this.handleSelectionKeys(e, selection, row);
        }
    }

    private class SelectAllMouseListener
    extends MouseAdapter {
        private SelectAllMouseListener() {
        }

        @Override
        public void mouseClicked(MouseEvent e) {
            if (!JSpreadsheetTable.this.table.getRowSelectionAllowed() && !JSpreadsheetTable.this.table.getColumnSelectionAllowed() || !e.getComponent().isEnabled() || e.getButton() != 1) {
                return;
            }
            ListSelectionModel columnModel = JSpreadsheetTable.this.table.getColumnModel().getSelectionModel();
            columnModel.setSelectionInterval(0, JSpreadsheetTable.this.table.getColumnCount() - 1);
            ListSelectionModel rowModel = JSpreadsheetTable.this.table.getSelectionModel();
            rowModel.setSelectionInterval(0, JSpreadsheetTable.this.table.getRowCount() - 1);
        }
    }

    private class RowNumberModel
    extends AbstractTableModel {
        private int rowCount;

        public RowNumberModel(int rowCount) {
            this.rowCount = rowCount;
        }

        @Override
        public String getColumnName(int i) {
            return "";
        }

        public Class getColumnClass(int i) {
            return Integer.class;
        }

        @Override
        public int getColumnCount() {
            return 1;
        }

        @Override
        public int getRowCount() {
            return this.rowCount;
        }

        @Override
        public Object getValueAt(int i, int j) {
            return i + 1;
        }

        @Override
        public boolean isCellEditable(int i, int j) {
            return false;
        }
    }

    private class NotEditableTableModel
    extends DefaultTableModel {
        public NotEditableTableModel(Object[][] data, String[] columnNames) {
            super(data, columnNames);
        }

        @Override
        public boolean isCellEditable(int i, int j) {
            return false;
        }
    }

    private class RowHeaderCellRenderer
    extends DefaultTableCellRenderer {
        private Border focusBorder;
        private Border nofocusBorder;

        public RowHeaderCellRenderer() {
            this.setOpaque(true);
        }

        @Override
        public void updateUI() {
            super.updateUI();
            Border cell = UIManager.getBorder("TableHeader.cellBorder");
            Border focus = UIManager.getBorder("Table.focusCellHighlightBorder");
            this.focusBorder = new BorderUIResource.CompoundBorderUIResource(cell, focus);
            Insets i = focus.getBorderInsets(this);
            this.nofocusBorder = new BorderUIResource.CompoundBorderUIResource(cell, BorderFactory.createEmptyBorder(i.top, i.left, i.bottom, i.right));
        }

        @Override
        public Component getTableCellRendererComponent(JTable jTable, Object value, boolean selected, boolean focused, int row, int column) {
            if (jTable != null) {
                JTableHeader tableHeader = jTable.getTableHeader();
                this.setBackground(tableHeader.getBackground());
                this.setForeground(tableHeader.getForeground());
                this.setBorder(tableHeader.getBorder());
                this.setFont(tableHeader.getFont());
                this.setEnabled(tableHeader.isEnabled());
            } else {
                this.setBackground(UIManager.getColor("TableHeader.background"));
                this.setForeground(UIManager.getColor("TableHeader.foreground"));
                this.setFont(UIManager.getFont("TableHeader.font"));
                this.setEnabled(true);
            }
            this.setHorizontalAlignment(0);
            if (focused) {
                this.setBorder(this.focusBorder);
            } else {
                this.setBorder(this.nofocusBorder);
            }
            this.setValue(value);
            return this;
        }
    }
}

