/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.io.Serializable;
import javax.swing.Icon;
import javax.swing.JColorChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.UIManager;
import javax.swing.border.CompoundBorder;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import quadbase.common.swing.JCenterLayout;
import quadbase.common.swing.MainSwatchPanel;
import quadbase.common.swing.RecentSwatchPanel;
import quadbase.common.swing.SwatchPanel;

public class JSwatchChooserPanel
extends AbstractColorChooserPanel {
    SwatchPanel swatchPanel;
    RecentSwatchPanel recentSwatchPanel;
    MouseListener mainSwatchListener;
    MouseListener recentSwatchListener;
    Color[] recentColors = null;
    private static String recentStr = UIManager.getString("ColorChooser.swatchesRecentText");

    public JSwatchChooserPanel() {
    }

    public JSwatchChooserPanel(Color[] colors) {
        this.recentColors = colors;
    }

    @Override
    public String getDisplayName() {
        return UIManager.getString("ColorChooser.swatchesNameText");
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public void installChooserPanel(JColorChooser enclosingChooser) {
        super.installChooserPanel(enclosingChooser);
    }

    @Override
    protected void buildChooser() {
        JPanel superHolder = new JPanel(new BorderLayout());
        this.swatchPanel = new MainSwatchPanel();
        this.swatchPanel.getAccessibleContext().setAccessibleName(this.getDisplayName());
        this.recentSwatchPanel = new RecentSwatchPanel(this.recentColors);
        this.recentSwatchPanel.getAccessibleContext().setAccessibleName(recentStr);
        this.mainSwatchListener = new MainSwatchListener();
        this.swatchPanel.addMouseListener(this.mainSwatchListener);
        this.recentSwatchListener = new RecentSwatchListener();
        this.recentSwatchPanel.addMouseListener(this.recentSwatchListener);
        JPanel mainHolder = new JPanel(new BorderLayout());
        CompoundBorder border = new CompoundBorder(new LineBorder(Color.black), new LineBorder(Color.white));
        mainHolder.setBorder(border);
        mainHolder.add((Component)this.swatchPanel, "Center");
        superHolder.add((Component)mainHolder, "Center");
        JPanel recentHolder = new JPanel(new BorderLayout());
        this.recentSwatchPanel.addMouseListener(this.recentSwatchListener);
        recentHolder.setBorder(border);
        recentHolder.add((Component)this.recentSwatchPanel, "Center");
        JPanel recentLabelHolder = new JPanel(new BorderLayout());
        recentLabelHolder.add((Component)recentHolder, "Center");
        JLabel l = new JLabel(recentStr);
        l.setLabelFor(this.recentSwatchPanel);
        recentLabelHolder.add((Component)l, "North");
        JPanel recentHolderHolder = new JPanel(new JCenterLayout());
        recentHolderHolder.setBorder(new EmptyBorder(2, 10, 2, 2));
        recentHolderHolder.add(recentLabelHolder);
        superHolder.add((Component)recentHolderHolder, "East");
        this.add(superHolder);
    }

    @Override
    public void uninstallChooserPanel(JColorChooser enclosingChooser) {
        super.uninstallChooserPanel(enclosingChooser);
        this.swatchPanel.removeMouseListener(this.mainSwatchListener);
        this.recentSwatchPanel.removeMouseListener(this.recentSwatchListener);
        this.swatchPanel = null;
        this.recentSwatchPanel = null;
        this.mainSwatchListener = null;
        this.recentSwatchListener = null;
        this.removeAll();
    }

    @Override
    public void updateChooser() {
    }

    class MainSwatchListener
    extends MouseAdapter
    implements Serializable {
        MainSwatchListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Color color = JSwatchChooserPanel.this.swatchPanel.getColorForLocation(e.getX(), e.getY());
            JSwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
        }
    }

    class RecentSwatchListener
    extends MouseAdapter
    implements Serializable {
        RecentSwatchListener() {
        }

        @Override
        public void mousePressed(MouseEvent e) {
            Color color = JSwatchChooserPanel.this.recentSwatchPanel.getColorForLocation(e.getX(), e.getY());
            JSwatchChooserPanel.this.getColorSelectionModel().setSelectedColor(color);
        }
    }
}

