/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.text.NumberFormat;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.LocaleNumericFormat;

public class LocaleFixedPointDialog
extends JDialog
implements ActionListener {
    LocaleNumericFormat lnf;
    ButtonGroup group;
    JRadioButton chkNumeric;
    JRadioButton chkCurrency;
    JRadioButton chkPercent;
    JCheckBox chkIsGroupingUsed;
    JCheckBox chkParseIntegerOnly;
    JTextField spinMaximumFractionDigits;
    JTextField spinMinimumFractionDigits;
    JTextField spinMaximumIntegerDigits;
    JTextField spinMinimumIntegerDigits;
    JButton btnOk;
    JButton btnCancel;

    public LocaleFixedPointDialog(JFrame frame, String title, LocaleNumericFormat lnf) {
        super(frame, title, true);
        this.init(lnf);
        this.setPosition();
    }

    void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init(LocaleNumericFormat lnf) {
        this.lnf = lnf;
        this.setBackground(Color.lightGray);
        JPanel plMain = new JPanel();
        plMain.setBorder(new TitledBorder(LanguageEncoder.getText("Format")));
        plMain.setLayout(new BorderLayout());
        JPanel panelTop = new JPanel(new FlowLayout(0));
        panelTop.add(new JLabel(LanguageEncoder.getText("Type:")));
        this.group = new ButtonGroup();
        this.chkNumeric = new JRadioButton(LanguageEncoder.getText("Number"), true);
        panelTop.add(this.chkNumeric);
        this.group.add(this.chkNumeric);
        this.chkCurrency = new JRadioButton(LanguageEncoder.getText("Currency"), false);
        this.group.add(this.chkCurrency);
        panelTop.add(this.chkCurrency);
        this.chkPercent = new JRadioButton(LanguageEncoder.getText("Percent"), false);
        this.group.add(this.chkPercent);
        panelTop.add(this.chkPercent);
        plMain.add("North", panelTop);
        JPanel panelCenter = new JPanel();
        panelCenter.setLayout(new GridLayout(5, 2, 5, 5));
        panelCenter.add(new JLabel(LanguageEncoder.getText("Maximum integer digits")));
        this.spinMaximumIntegerDigits = new JTextField(2);
        panelCenter.add(this.spinMaximumIntegerDigits);
        panelCenter.add(new JLabel(LanguageEncoder.getText("Minimum integer digits")));
        this.spinMinimumIntegerDigits = new JTextField(2);
        panelCenter.add(this.spinMinimumIntegerDigits);
        panelCenter.add(new JLabel(LanguageEncoder.getText("Maximum fraction digits")));
        this.spinMaximumFractionDigits = new JTextField(2);
        panelCenter.add(this.spinMaximumFractionDigits);
        panelCenter.add(new JLabel(LanguageEncoder.getText("Minimum fraction digits")));
        this.spinMinimumFractionDigits = new JTextField(2);
        panelCenter.add(this.spinMinimumFractionDigits);
        this.chkIsGroupingUsed = new JCheckBox(LanguageEncoder.getText("Use Grouping"));
        panelCenter.add(this.chkIsGroupingUsed);
        this.chkParseIntegerOnly = new JCheckBox(LanguageEncoder.getText("Parse integer only"));
        panelCenter.add(this.chkParseIntegerOnly);
        plMain.add("Center", panelCenter);
        JPanel plButton = new JPanel(new FlowLayout(2));
        this.btnOk = new JButton(LanguageEncoder.getText("OK"));
        this.btnOk.addActionListener(this);
        this.btnCancel = new JButton(LanguageEncoder.getText("Cancel"));
        this.btnCancel.addActionListener(this);
        plButton.add(this.btnOk);
        plButton.add(this.btnCancel);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("North", plMain);
        contentPane.add("Center", plButton);
        int instanceType = lnf.getInstanceType();
        if (instanceType == 1) {
            this.chkNumeric.setSelected(true);
        } else if (instanceType == 0) {
            this.chkCurrency.setSelected(true);
        } else if (instanceType == 2) {
            this.chkPercent.setSelected(true);
        } else {
            System.out.println("LocaleFixedPointDialog: Should not happen");
        }
        NumberFormat nf = lnf.getNumberFormat();
        this.chkIsGroupingUsed.setSelected(nf.isGroupingUsed());
        this.chkParseIntegerOnly.setSelected(nf.isParseIntegerOnly());
        this.spinMaximumFractionDigits.setText(nf.getMaximumFractionDigits() + "");
        this.spinMinimumFractionDigits.setText(nf.getMinimumFractionDigits() + "");
        this.spinMaximumIntegerDigits.setText(nf.getMaximumIntegerDigits() + "");
        this.spinMinimumIntegerDigits.setText(nf.getMinimumIntegerDigits() + "");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnOk) {
            if (this.chkNumeric.isSelected()) {
                this.lnf = LocaleNumericFormat.getNumberInstance();
            } else if (this.chkCurrency.isSelected()) {
                this.lnf = LocaleNumericFormat.getCurrencyInstance();
            } else if (this.chkPercent.isSelected()) {
                this.lnf = LocaleNumericFormat.getPercentInstance();
            }
            NumberFormat nf = this.lnf.getNumberFormat();
            nf.setGroupingUsed(this.chkIsGroupingUsed.isSelected());
            nf.setParseIntegerOnly(this.chkParseIntegerOnly.isSelected());
            try {
                int maxF = Integer.parseInt(this.spinMaximumFractionDigits.getText());
                maxF = maxF > 15 ? 15 : (maxF < 0 ? 0 : maxF);
                int minF = Integer.parseInt(this.spinMinimumFractionDigits.getText());
                minF = minF > 15 ? 15 : (minF < 0 ? 0 : minF);
                int maxI = Integer.parseInt(this.spinMaximumIntegerDigits.getText());
                maxI = maxI > 15 ? 15 : (maxI < 0 ? 0 : maxI);
                int minI = Integer.parseInt(this.spinMinimumIntegerDigits.getText());
                minI = minI > 15 ? 15 : (minI < 0 ? 0 : minI);
                nf.setMaximumFractionDigits(maxF);
                nf.setMinimumFractionDigits(minF);
                nf.setMaximumIntegerDigits(maxI);
                nf.setMinimumIntegerDigits(minI);
            }
            catch (Exception ex) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Max/Min Digits : Integer only!"));
                return;
            }
        }
        this.dispose();
    }

    LocaleNumericFormat getFormat() {
        return this.lnf;
    }
}

