/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing;

import java.awt.BorderLayout;
import java.awt.GridLayout;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.TitledBorder;
import quadbase.common.swing.PanelAction;
import quadbase.common.util.internal.LanguageEncoder;

public class LogicalPanel
extends PanelAction
implements ItemListener {
    ButtonGroup group;
    JRadioButton[] boxes;
    static final String[] formatSpec = new String[]{"T/F", "True/False", "Yes/No", "Y/N", "1/0"};

    public LogicalPanel() {
        this.setLayout(new BorderLayout());
        JPanel bpanel = new JPanel();
        bpanel.setBorder(new TitledBorder(LanguageEncoder.getText("Logical Format")));
        bpanel.setLayout(new GridLayout(5, 1));
        this.addCheckBox(bpanel);
        this.add("Center", bpanel);
    }

    void addCheckBox(JPanel panel) {
        this.boxes = new JRadioButton[5];
        this.group = new ButtonGroup();
        for (int i = 0; i < 5; ++i) {
            this.boxes[i] = new JRadioButton(formatSpec[i], i == 0);
            panel.add(this.boxes[i]);
            this.group.add(this.boxes[i]);
            this.boxes[i].addItemListener(this);
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        this.fireEvent(this, 0);
    }

    public String formatValue(String value) {
        String format = this.boxes[this.getFormatInt()].getLabel();
        if (Character.toUpperCase(value.charAt(0)) == 'T') {
            return format.substring(0, format.indexOf(47));
        }
        return format.substring(format.indexOf(47) + 1);
    }

    public String getSampleText() {
        return this.formatValue("T");
    }

    public void setFormat(String format) {
        this.setFormat(Integer.parseInt(format.substring(1)));
    }

    public void setFormat(int format) {
        this.boxes[format].setSelected(true);
    }

    public static String format(Boolean value, int format) {
        String s = formatSpec[format];
        if (value.booleanValue()) {
            return s.substring(0, s.indexOf(47));
        }
        return s.substring(s.indexOf(47) + 1);
    }

    public String getFormatString() {
        return "L" + this.getFormatInt();
    }

    public int getFormatInt() {
        int i;
        for (i = 0; i < this.boxes.length && !this.boxes[i].isSelected(); ++i) {
        }
        return i;
    }
}

