/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing;

import java.awt.BorderLayout;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.util.StringTokenizer;
import javax.swing.JButton;
import javax.swing.JPanel;
import javax.swing.JTextArea;
import quadbase.common.swing.QbDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class MessageDialog
extends QbDialog {
    JTextArea ta;
    private boolean useOnce = false;
    private String lastActionCommand = "";

    public MessageDialog(Frame f, String title, boolean modal, boolean once, String button) {
        super(f, title, modal);
        if (button == null) {
            this.init("OK");
        } else {
            this.init(button);
        }
        this.useOnce = once;
    }

    public MessageDialog(Dialog d, String title, boolean modal, boolean once, String button) {
        super(d, title, modal);
        if (button == null) {
            this.init("OK");
        } else {
            this.init(button);
        }
        this.useOnce = once;
    }

    public MessageDialog(Frame f, String title, boolean modal) {
        this(f, title, modal, false, null);
    }

    public MessageDialog(Frame f, boolean once) {
        this(f, "", true, once, null);
    }

    public MessageDialog(Frame f) {
        this(f, "", true, false, null);
    }

    public MessageDialog(Frame f, String title) {
        this(f, title, true, false, null);
    }

    public MessageDialog(Frame f, String title, String button) {
        this(f, title, true, true, button);
    }

    public static void showError(Frame f, boolean modal, String msg) {
        new MessageDialog(f, LanguageEncoder.getText("Error"), modal, true, null).show(msg);
    }

    public static void showError(Dialog d, boolean modal, String msg) {
        new MessageDialog(d, LanguageEncoder.getText("Error"), modal, true, null).show(msg);
    }

    protected void init(String str) {
        JPanel contentPane = (JPanel)this.getContentPane();
        this.ta = new JTextArea(8, 40);
        this.ta.setLineWrap(true);
        this.ta.setWrapStyleWord(true);
        this.ta.setEditable(false);
        JPanel buttonPanel = new JPanel();
        buttonPanel.setLayout(new FlowLayout(2));
        StringTokenizer st = new StringTokenizer(str, ",");
        while (st.hasMoreTokens()) {
            String label = st.nextToken();
            JButton but = new JButton(label);
            buttonPanel.add(but);
            but.addActionListener(this);
            but.setActionCommand(label);
        }
        contentPane.setLayout(new BorderLayout());
        contentPane.add("Center", this.ta);
        contentPane.add("South", buttonPanel);
        this.pack();
        this.setSize(this.getPreferredSize());
        this.setResizable(false);
    }

    public JTextArea getTextArea() {
        return this.ta;
    }

    public void show(String s) {
        this.ta.setText(s);
        this.setVisible(true);
    }

    public void show(String s, Frame f) {
        this.ta.setText(s);
        this.setVisible(true);
        this.setLocationRelativeTo(f);
    }

    public void onClose() {
        if (this.useOnce) {
            this.dispose();
        } else {
            this.setVisible(false);
        }
    }

    public String getLastActionCommand() {
        return this.lastActionCommand;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.onClose();
        this.lastActionCommand = e.getActionCommand();
        this.fireEvent(this, 0, e.getActionCommand());
    }
}

