/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing;

import java.awt.BorderLayout;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import quadbase.common.swing.FixedPointDialog;
import quadbase.common.swing.LocaleFixedPointDialog;
import quadbase.common.swing.PanelAction;
import quadbase.common.swing.ScientificDialog;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.IFormat;
import quadbase.util.LocaleNumericFormat;
import quadbase.util.NumericFormat;

public class NumericPanel
extends PanelAction
implements ItemListener {
    JFrame frame;
    ButtonGroup group;
    JRadioButton chkLocaleFixed;
    JRadioButton chkFixed;
    JRadioButton chkBarcode;
    JRadioButton chkScientific;
    JButton btnFormat;
    NumericFormat nf;
    LocaleNumericFormat lnf;

    public NumericPanel(JFrame frame, IFormat format) {
        this.frame = frame;
        this.init(format);
    }

    private void init(IFormat format) {
        this.group = new ButtonGroup();
        JPanel plLocaleFixed = new JPanel(new FlowLayout(0));
        this.chkLocaleFixed = new JRadioButton(LanguageEncoder.getText("Locale-specific fixed point"), true);
        plLocaleFixed.add(this.chkLocaleFixed);
        this.chkLocaleFixed.addItemListener(this);
        this.group.add(this.chkLocaleFixed);
        JPanel plFixed = new JPanel(new FlowLayout(0));
        this.chkFixed = new JRadioButton(LanguageEncoder.getText("Fixed point"), false);
        plFixed.add(this.chkFixed);
        this.chkFixed.addItemListener(this);
        this.group.add(this.chkFixed);
        JPanel plBottom = new JPanel(new BorderLayout());
        JPanel plScientific = new JPanel(new FlowLayout(0));
        this.chkScientific = new JRadioButton(LanguageEncoder.getText("Scientific"), false);
        plScientific.add(this.chkScientific);
        this.chkScientific.addItemListener(this);
        this.group.add(this.chkScientific);
        JPanel plFormat = new JPanel(new FlowLayout(2));
        this.btnFormat = new JButton(LanguageEncoder.getText("Format..."));
        this.btnFormat.addActionListener(this);
        plFormat.add(this.btnFormat);
        plBottom.add("West", plScientific);
        plBottom.add("East", plFormat);
        this.setLayout(new GridLayout(3, 1, 5, 5));
        this.add(plLocaleFixed);
        this.add(plFixed);
        this.add(plBottom);
        if (format instanceof NumericFormat) {
            this.nf = (NumericFormat)format;
            if (this.nf.sciExp) {
                this.chkScientific.setSelected(true);
            } else {
                this.chkFixed.setSelected(true);
            }
        } else if (format instanceof LocaleNumericFormat) {
            this.lnf = (LocaleNumericFormat)format;
            this.chkLocaleFixed.setSelected(true);
        } else {
            System.out.println("NumericPanel: should not happen");
        }
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        if (this.chkFixed.isSelected()) {
            if (this.nf == null) {
                this.nf = new NumericFormat();
            }
            this.nf.sciExp = false;
        } else if (this.chkScientific.isSelected()) {
            if (this.nf == null) {
                this.nf = new NumericFormat();
            }
            this.nf.sciExp = true;
        } else if (this.chkLocaleFixed.isSelected() && this.lnf == null) {
            this.lnf = LocaleNumericFormat.getNumberInstance();
        }
        this.fireEvent(this, 0);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.showFormatDialog();
        this.fireEvent(this, 0);
    }

    private void showFormatDialog() {
        if (this.chkLocaleFixed.isSelected()) {
            LocaleFixedPointDialog lfpd = new LocaleFixedPointDialog(this.frame, LanguageEncoder.getText("Locale-specific fixed point..."), this.lnf);
            lfpd.setVisible(true);
            this.lnf = lfpd.getFormat();
        } else if (this.chkFixed.isSelected()) {
            FixedPointDialog fpd = new FixedPointDialog(this.frame, LanguageEncoder.getText("Fixed Point..."), this.nf);
            fpd.setVisible(true);
            this.nf = fpd.getFormat();
        } else if (this.chkScientific.isSelected()) {
            ScientificDialog sd = new ScientificDialog(this.frame, LanguageEncoder.getText("Scientific..."), this.nf);
            sd.setVisible(true);
            this.nf = sd.getFormat();
        }
    }

    public String formatValue(String value) {
        double d;
        try {
            d = Double.valueOf(value);
        }
        catch (NumberFormatException ex) {
            return value;
        }
        try {
            if (this.chkLocaleFixed.isSelected()) {
                return this.lnf.format(d);
            }
            if (this.chkFixed.isSelected() || this.chkScientific.isSelected()) {
                return this.nf.format(d);
            }
            return value;
        }
        catch (Throwable t) {
            return value;
        }
    }

    public IFormat getformat() {
        if (this.chkLocaleFixed.isSelected()) {
            return this.lnf;
        }
        if (this.chkFixed.isSelected() || this.chkScientific.isSelected()) {
            return this.nf;
        }
        return null;
    }

    public String getSampleText() {
        if (this.getformat() != null) {
            return this.getformat().format(-9.99999999999999E8);
        }
        return null;
    }
}

