/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing;

import java.awt.Color;
import java.awt.Dialog;
import java.awt.FlowLayout;
import java.awt.Frame;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.io.File;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.common.client.ServerMessage;
import quadbase.common.swing.BrowseDialog;
import quadbase.common.swing.ExtensionFilter;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class OpenFileDialog
extends JDialog
implements ActionListener,
WindowListener {
    JTextField tf;
    JButton browseButton;
    JButton okButton;
    JButton cancelButton;
    JFileChooser fileChooser;
    BrowseDialog browseDialog;
    String selectedFile = "";
    String[] ext;
    String currentDir = null;
    String defaultDir = "";
    String defaultExt = null;
    boolean showBrowseButton = true;
    boolean isClosed = false;

    public OpenFileDialog(Frame frame, String title, String fileName, String[] ext) {
        this(frame, title, fileName, ext, null);
    }

    public OpenFileDialog(Frame frame, String title, String fileName, String[] ext, String currentDir) {
        this(frame, title, fileName, ext, currentDir, true);
    }

    public OpenFileDialog(Frame frame, String title, String fileName, String[] ext, String currentDir, boolean showBrowseButton) {
        this(frame, title, fileName, ext, currentDir, showBrowseButton, null);
    }

    public OpenFileDialog(Frame frame, String title, String fileName, String[] ext, String currentDir, boolean showBrowseButton, String defaultExt) {
        super(frame, title, true);
        this.commonConstructor(fileName, ext, currentDir, showBrowseButton, defaultExt, true);
    }

    public OpenFileDialog(JDialog parent, String title, String fileName, String[] ext, String currentDir, boolean showBrowseButton) {
        super(parent, title, true);
        this.commonConstructor(fileName, ext, currentDir, showBrowseButton, this.defaultExt, true);
    }

    public OpenFileDialog(JDialog parent, String title, String fileName, String[] ext, String currentDir, boolean showBrowseButton, boolean useForcedSaveDirectory) {
        super(parent, title, true);
        this.commonConstructor(fileName, ext, currentDir, showBrowseButton, this.defaultExt, useForcedSaveDirectory);
    }

    private void commonConstructor(String fileName, String[] ext, String currentDir, boolean showBrowseButton, String defaultExt, boolean useForcedSaveDirectory) {
        this.setResizable(false);
        this.ext = ext;
        this.showBrowseButton = showBrowseButton;
        this.currentDir = currentDir;
        if (defaultExt != null) {
            this.defaultExt = defaultExt;
        } else if (ext != null && ext.length > 0) {
            this.defaultExt = ext[0].toLowerCase();
        }
        this.selectedFile = fileName;
        if (useForcedSaveDirectory && ServerMessage.getForcedSaveDirectory() != null) {
            currentDir = ServerMessage.getForcedSaveDirectory();
        }
        if (currentDir != null) {
            this.defaultDir = (currentDir = currentDir.replace('\\', '/')).endsWith("/") ? currentDir : currentDir + "/";
        }
        this.init();
        this.setPosition();
    }

    void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    void init() {
        this.setBackground(Color.lightGray);
        this.setDefaultCloseOperation(2);
        this.addWindowListener(this);
        this.tf = this.selectedFile != null && !this.selectedFile.equals("") ? new JTextField(this.selectedFile, 25) : new JTextField(this.defaultDir, 25);
        this.tf.addActionListener(this);
        JPanel p1 = new JPanel();
        p1.setLayout(new FlowLayout(1));
        p1.add(new JLabel(LanguageEncoder.getText("Name :") + " "));
        p1.add(this.tf);
        if (this.showBrowseButton) {
            this.browseButton = new JButton(LanguageEncoder.getText("Browse..."));
            this.browseButton.addActionListener(this);
        }
        this.okButton = new JButton(LanguageEncoder.getText("OK"));
        this.okButton.addActionListener(this);
        this.cancelButton = new JButton(LanguageEncoder.getText("Cancel"));
        this.cancelButton.addActionListener(this);
        JPanel p2 = new JPanel();
        p2.setLayout(new FlowLayout(2));
        if (this.showBrowseButton) {
            p2.add(this.browseButton);
        }
        p2.add(this.okButton);
        p2.add(this.cancelButton);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.add("Center", p1);
        contentPane.add("South", p2);
        this.pack();
        this.tf.requestFocus();
    }

    private String loadFile() {
        String filename = null;
        if (!ServerMessage.useServer && ServerMessage.isLoadBalancer) {
            if (this.fileChooser == null) {
                this.fileChooser = new JFileChooser(LanguageEncoder.getText("Select file"));
                ExtensionFilter fileFilter = new ExtensionFilter(this.ext);
                this.fileChooser.addChoosableFileFilter(fileFilter);
                if (this.currentDir == null) {
                    this.fileChooser.setCurrentDirectory(new File(ServerMessage.getWorkingDirectory()));
                } else {
                    this.fileChooser.setCurrentDirectory(new File(this.currentDir));
                }
            }
            this.fileChooser.showDialog(this, null);
            if (this.fileChooser.getSelectedFile() == null) {
                return null;
            }
            filename = this.fileChooser.getSelectedFile().getAbsolutePath();
            this.currentDir = this.fileChooser.getCurrentDirectory().getAbsolutePath();
        } else {
            if (this.browseDialog == null) {
                int lastIndex;
                String file_name = null;
                if (this.selectedFile != null && (lastIndex = this.selectedFile.replace("\\", "/").lastIndexOf(47)) > 0 && lastIndex + 1 < this.selectedFile.length()) {
                    file_name = this.selectedFile.substring(lastIndex + 1);
                }
                this.browseDialog = BrowseDialog.create(this, this.currentDir, this.ext, true, false, file_name);
            }
            this.browseDialog.setVisible(true);
            filename = this.browseDialog.getSelectedFile();
            this.currentDir = this.browseDialog.getCurrentDirectory();
        }
        return filename;
    }

    public String getSelectedFile() {
        return this.selectedFile;
    }

    public boolean isClosed() {
        return this.isClosed;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        String filename = this.tf.getText();
        if (e.getSource() == this.browseButton) {
            String fileText = this.loadFile();
            if (fileText != null) {
                this.tf.setText(fileText);
            }
            return;
        }
        if (e.getSource() == this.okButton || e.getSource() == this.tf) {
            if (filename == null || filename.trim().equals("") || filename.trim().equals(this.defaultDir)) {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Please input a file name"));
                return;
            }
            boolean match = false;
            String extString = "";
            if (this.ext != null) {
                if (this.ext.length == 1 && !filename.toUpperCase().endsWith("." + this.ext[0])) {
                    filename = filename + "." + this.ext[0].toLowerCase();
                }
                for (String element : this.ext) {
                    if (filename.toUpperCase().endsWith("." + element)) {
                        match = true;
                        break;
                    }
                    extString = extString + " " + element;
                }
                if (!match) {
                    new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("please enter file with extention") + extString);
                    return;
                }
            } else {
                new JMessageDialog((Dialog)this, LanguageEncoder.getText("Error"), LanguageEncoder.getText("Please insert valid file name."));
                return;
            }
            this.selectedFile = filename;
        } else if (e.getSource() == this.cancelButton) {
            this.selectedFile = null;
        }
        this.setVisible(false);
        this.dispose();
    }

    public String getCurrentDirectory() {
        return this.currentDir;
    }

    @Override
    public void windowClosing(WindowEvent e) {
        this.selectedFile = null;
        this.isClosed = true;
    }

    @Override
    public void windowOpened(WindowEvent e) {
    }

    @Override
    public void windowClosed(WindowEvent e) {
    }

    @Override
    public void windowIconified(WindowEvent e) {
    }

    @Override
    public void windowDeiconified(WindowEvent e) {
    }

    @Override
    public void windowActivated(WindowEvent e) {
    }

    @Override
    public void windowDeactivated(WindowEvent e) {
    }
}

