/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing;

import java.awt.Dialog;
import java.awt.Frame;
import javax.swing.JDialog;
import quadbase.common.client.FileInfo;
import quadbase.common.client.ServerMessage;
import quadbase.common.util.internal.JMessageDialog;
import quadbase.common.util.internal.LanguageEncoder;

public class OverWriteDialog {
    public static boolean continueSave(Frame frame, String filename) {
        String message = filename + " " + LanguageEncoder.getText("already exists") + "\n" + LanguageEncoder.getText("Do you want to replace it?");
        return OverWriteDialog.continueSave(frame, filename, message);
    }

    public static boolean continueSave(Frame frame, String filename, String message) {
        if (!OverWriteDialog.findFile(filename)) {
            return true;
        }
        JMessageDialog msgDialog = new JMessageDialog(frame, LanguageEncoder.getText("Warning"), message, 2);
        int response = msgDialog.getResponse();
        return response == 4;
    }

    public static boolean continueSave(JDialog parent, String filename) {
        String message = filename + " " + LanguageEncoder.getText("already exists") + "\n" + LanguageEncoder.getText("Do you want to replace it?");
        return OverWriteDialog.continueSave(parent, filename, message);
    }

    public static boolean continueSave(JDialog parent, String filename, String message) {
        if (!OverWriteDialog.findFile(filename)) {
            return true;
        }
        JMessageDialog msgDialog = new JMessageDialog((Dialog)parent, LanguageEncoder.getText("Warning"), message, 2);
        int response = msgDialog.getResponse();
        return response == 4;
    }

    public static boolean isFileExisted(Frame frame, String filename) {
        String message = filename + " " + LanguageEncoder.getText("does not exist!");
        return OverWriteDialog.isFileExisted(frame, filename, message);
    }

    public static boolean isFileExisted(Frame frame, String filename, String message) {
        if (OverWriteDialog.findFile(filename)) {
            return true;
        }
        new JMessageDialog(frame, LanguageEncoder.getText("Error"), message);
        return false;
    }

    public static boolean isFileExisted(JDialog parent, String filename) {
        String message = filename + " " + LanguageEncoder.getText("does not exist!");
        return OverWriteDialog.isFileExisted(parent, filename, message);
    }

    public static boolean isFileExisted(JDialog parent, String filename, String message) {
        if (OverWriteDialog.findFile(filename)) {
            return true;
        }
        new JMessageDialog((Dialog)parent, LanguageEncoder.getText("Error"), message);
        return false;
    }

    public static boolean findFile(String filename) {
        boolean returnValue = false;
        try {
            return new FileInfo(filename).exists();
        }
        catch (Exception ex) {
            returnValue = false;
            return returnValue;
        }
    }

    public static String getNextAvailableFileName(String fileName) {
        try {
            FileInfo fInfo = new FileInfo(fileName);
            if (!fInfo.exists()) {
                return fileName;
            }
            JMessageDialog dialog = new JMessageDialog(ServerMessage.getFrame(), "Unpacking report", fileName + " " + LanguageEncoder.getText("already exists! Do you want to replace it?") + "\n" + LanguageEncoder.getText("If not, the system will save it under a different name."), 2);
            int response = dialog.getResponse();
            if (response == 4) {
                return fileName;
            }
            int len = fileName.length() - 4;
            int ct = 0;
            while (Character.isDigit(fileName.charAt(len - 1))) {
                --len;
            }
            if (len < fileName.length() - 4) {
                String ctstring = fileName.substring(len, fileName.length() - 4);
                ct = Integer.parseInt(ctstring);
            }
            String tmp = fileName.substring(0, len);
            String newFile = tmp + ct;
            while (new FileInfo(newFile + fileName.substring(fileName.length() - 4, fileName.length())).exists()) {
                newFile = tmp + ct++;
            }
            return newFile + fileName.substring(fileName.length() - 4, fileName.length());
        }
        catch (Exception ex) {
            ex.printStackTrace();
            return null;
        }
    }
}

