/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing;

import java.awt.Color;
import java.awt.Dimension;
import javax.swing.UIManager;
import quadbase.common.swing.SwatchPanel;

class RecentSwatchPanel
extends SwatchPanel {
    public RecentSwatchPanel(Color[] colors) {
        super(colors);
    }

    @Override
    protected void initValues() {
        this.swatchSize = UIManager.getDimension("ColorChooser.swatchesRecentSwatchSize");
        this.numSwatches = new Dimension(5, 7);
        this.gap = new Dimension(1, 1);
    }

    @Override
    protected void initColors() {
        Color defaultRecentColor = UIManager.getColor("ColorChooser.swatchesDefaultRecentColor");
        int numColors = this.numSwatches.width * this.numSwatches.height;
        this.colors = new Color[numColors];
        if (this.recentColors != null) {
            if (this.recentColors.length > numColors) {
                for (int i = 0; i < numColors; ++i) {
                    this.colors[i] = this.recentColors[i];
                }
            } else {
                int i;
                for (i = 0; i < this.recentColors.length; ++i) {
                    this.colors[i] = this.recentColors[i];
                }
                for (i = this.recentColors.length; i < numColors; ++i) {
                    this.colors[i] = defaultRecentColor;
                }
            }
        } else {
            for (int i = 0; i < numColors; ++i) {
                this.colors[i] = defaultRecentColor;
            }
        }
    }

    public void setMostRecentColor(Color c) {
        System.arraycopy(this.colors, 0, this.colors, 1, this.colors.length - 1);
        this.colors[0] = c;
        this.repaint();
    }
}

