/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.FlowLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import javax.swing.JButton;
import javax.swing.JDialog;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JTextField;
import javax.swing.border.TitledBorder;
import quadbase.common.util.internal.LanguageEncoder;
import quadbase.util.NumericFormat;

public class ScientificDialog
extends JDialog
implements ActionListener {
    NumericFormat nf;
    JTextField spinDecimals;
    JButton btnOk;
    JButton btnCancel;

    public ScientificDialog(JFrame frame, String title, NumericFormat nf) {
        super(frame, title, true);
        this.init(nf);
        this.setPosition();
    }

    void setPosition() {
        this.pack();
        this.setLocationRelativeTo(this.getParent());
    }

    private void init(NumericFormat nf) {
        this.nf = nf;
        this.setBackground(Color.lightGray);
        JPanel plMain = new JPanel();
        plMain.setBorder(new TitledBorder(LanguageEncoder.getText("Format")));
        plMain.setLayout(new BorderLayout());
        this.spinDecimals = new JTextField(3);
        plMain.add("North", this.labelComponent(LanguageEncoder.getText("Decimals:"), this.spinDecimals));
        JPanel plButton = new JPanel(new FlowLayout(2));
        this.btnOk = new JButton(LanguageEncoder.getText("OK"));
        this.btnOk.addActionListener(this);
        this.btnCancel = new JButton(LanguageEncoder.getText("Cancel"));
        this.btnCancel.addActionListener(this);
        plButton.add(this.btnOk);
        plButton.add(this.btnCancel);
        JPanel contentPane = (JPanel)this.getContentPane();
        contentPane.setLayout(new BorderLayout());
        contentPane.add("North", plMain);
        contentPane.add("Center", plButton);
        this.spinDecimals.setText(nf.decimal + "");
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (e.getSource() == this.btnOk) {
            try {
                int dec = Integer.parseInt(this.spinDecimals.getText());
                dec = dec > 15 ? 15 : (dec < 0 ? 0 : dec);
                this.nf = new NumericFormat();
                this.nf.setScientifExp(dec);
            }
            catch (Exception ex) {
                JOptionPane.showMessageDialog(this, LanguageEncoder.getText("Decimals Field : Integer Only!"), LanguageEncoder.getText("Error"), 0);
                return;
            }
        }
        this.dispose();
    }

    NumericFormat getFormat() {
        return this.nf;
    }

    private JPanel labelComponent(String label, Component component) {
        JPanel panel = new JPanel();
        panel.setLayout(new FlowLayout(0, 5, 2));
        panel.add(new JLabel(label));
        panel.add(component);
        return panel;
    }
}

