/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.FocusEvent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JTextField;
import quadbase.common.swing.ArrowButton;
import quadbase.common.swing.PanelAction;

public class SpinBox
extends PanelAction {
    protected int minvalue;
    protected int maxvalue;
    protected int value;
    protected int step;
    protected JTextField textfield;
    protected ArrowButton upbutton;
    protected ArrowButton downbutton;
    protected int digit = -1;

    public SpinBox(int minvalue, int maxvalue) {
        this(minvalue, maxvalue, 1);
    }

    public SpinBox(int min, int max, int step) {
        this(min, max, step, -1);
    }

    public SpinBox(int minvalue, int maxvalue, int step, int digit) {
        this.value = this.minvalue = Math.min(minvalue, maxvalue);
        this.maxvalue = Math.max(minvalue, maxvalue);
        this.digit = digit;
        this.step = step;
        this.upbutton = new ArrowButton(0);
        this.downbutton = new ArrowButton(1);
        this.setLayout(new BorderLayout());
        JPanel arrpanel = new JPanel();
        arrpanel.setLayout(new GridLayout(2, 1));
        arrpanel.add(this.upbutton);
        arrpanel.add(this.downbutton);
        this.textfield = new JTextField(Math.max(this.getMaxDigits(minvalue), this.getMaxDigits(maxvalue)) + 1);
        this.setTextValue(this.value);
        this.textfield.setEditable(true);
        this.textfield.setHorizontalAlignment(4);
        this.upbutton.addActionListener(this);
        this.downbutton.addActionListener(this);
        this.textfield.addActionListener(this);
        this.textfield.addFocusListener(this);
        this.add("Center", this.textfield);
        this.add("East", arrpanel);
    }

    public final void addLabel(String label) {
        this.add("West", new JLabel(label));
    }

    public final void setRange(int min, int max, int step) {
        this.step = step;
        this.maxvalue = max;
        this.minvalue = min;
        this.setValue(this.value);
    }

    protected final int getMaxDigits(int x) {
        if (x == 0) {
            return 1;
        }
        int sign = 0;
        if (x < 0) {
            sign = 1;
            x *= -1;
        }
        return (int)Math.ceil(Math.log(x) / Math.log(10.0)) + sign;
    }

    public final boolean setValue(int value) {
        int newVal = value;
        this.value = value < this.minvalue ? this.minvalue : (value > this.maxvalue ? this.maxvalue : value);
        this.setTextValue(this.value);
        return newVal == this.value;
    }

    public final int getValue() {
        return this.value;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        if (!this.isEnabled()) {
            return;
        }
        Object target = e.getSource();
        if (target == this.textfield) {
            this.trySetValue();
        } else {
            if (target == this.upbutton) {
                this.value += this.step;
            } else if (target == this.downbutton) {
                this.value -= this.step;
            } else {
                return;
            }
            this.setValue(this.value);
            this.fireEvent(this, 0);
        }
    }

    protected final void trySetValue() {
        int newvalue;
        try {
            newvalue = Integer.valueOf(this.textfield.getText());
        }
        catch (Exception ex) {
            this.setTextValue(this.value);
            return;
        }
        if (this.value != newvalue) {
            this.setValue(newvalue);
            this.fireEvent(this, 0);
        }
    }

    @Override
    public void focusLost(FocusEvent e) {
        this.trySetValue();
    }

    public final void setDigit(int i) {
        this.digit = i;
    }

    private final void setTextValue(int i) {
        int len;
        String value = String.valueOf(i);
        if (this.digit > 0 && (len = this.digit - value.length()) > 0) {
            this.textfield.setText(SpinBox.pad('0', len) + value);
            return;
        }
        this.textfield.setText(value);
    }

    private static final String pad(char c, int n) {
        char[] buf = new char[n];
        for (int i = 0; i < n; ++i) {
            buf[i] = c;
        }
        return new String(buf);
    }

    public final String getText() {
        return this.textfield.getText();
    }

    @Override
    public final void setEnabled(boolean state) {
        this.textfield.setEnabled(state);
        if (state) {
            this.textfield.setBackground(Color.white);
        } else {
            JLabel label = new JLabel("ABC");
            this.textfield.setBackground(label.getBackground());
        }
        super.setEnabled(state);
    }
}

