/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing;

import java.awt.event.MouseEvent;
import javax.swing.table.JTableHeader;
import javax.swing.table.TableColumnModel;

public class TooltipTableHeader
extends JTableHeader {
    private String[] toolTips = null;

    public TooltipTableHeader(TableColumnModel model) {
        super(model);
    }

    @Override
    public String getToolTipText(MouseEvent e) {
        String retStr;
        int col = this.columnAtPoint(e.getPoint());
        int modelCol = this.getTable().convertColumnIndexToModel(col);
        if (this.toolTips == null) {
            retStr = (String)this.getTable().getColumnModel().getColumn(modelCol).getHeaderValue();
        } else {
            try {
                retStr = this.toolTips[modelCol];
            }
            catch (NullPointerException ex) {
                retStr = "";
            }
            catch (ArrayIndexOutOfBoundsException ex) {
                retStr = "";
            }
            if (retStr.length() < 1) {
                retStr = super.getToolTipText(e);
            }
        }
        return retStr;
    }

    public void setToolTipStrings(String[] toolTips) {
        this.toolTips = toolTips;
    }
}

