/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing;

import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import javax.swing.AbstractAction;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.event.UndoableEditEvent;
import javax.swing.event.UndoableEditListener;
import javax.swing.text.Document;
import javax.swing.undo.CannotRedoException;
import javax.swing.undo.CannotUndoException;
import javax.swing.undo.UndoManager;

public class UndoTextArea
extends JTextArea {
    private UndoManager undo = new UndoManager();

    public UndoTextArea() {
        this.init();
    }

    public UndoTextArea(String text) {
        super(text);
        this.init();
    }

    public UndoTextArea(int rows, int columns) {
        super(rows, columns);
        this.init();
    }

    public UndoTextArea(String text, int rows, int columns) {
        super(text, rows, columns);
        this.init();
    }

    private void init() {
        Document doc = this.getDocument();
        doc.addUndoableEditListener(new UndoableEditListener(){

            @Override
            public void undoableEditHappened(UndoableEditEvent evt) {
                UndoTextArea.this.undo.addEdit(evt.getEdit());
            }
        });
        this.getActionMap().put("Undo", new AbstractAction("Undo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (UndoTextArea.this.undo.canUndo()) {
                        UndoTextArea.this.undo.undo();
                    }
                }
                catch (CannotUndoException cannotUndoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(90, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "Undo");
        this.getActionMap().put("Redo", new AbstractAction("Redo"){

            @Override
            public void actionPerformed(ActionEvent evt) {
                try {
                    if (UndoTextArea.this.undo.canRedo()) {
                        UndoTextArea.this.undo.redo();
                    }
                }
                catch (CannotRedoException cannotRedoException) {
                    // empty catch block
                }
            }
        });
        this.getInputMap().put(KeyStroke.getKeyStroke(89, Toolkit.getDefaultToolkit().getMenuShortcutKeyMask()), "Redo");
    }
}

