/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing.color;

import java.awt.Color;
import java.awt.Component;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import quadbase.common.swing.JRGBChooserPanel;
import quadbase.common.swing.color.DefaultHSBChooserPanel;

public class ColorDialog {
    private static JColorChooser getColorChooser(Color initColor) {
        JColorChooser colorChooser = new JColorChooser();
        AbstractColorChooserPanel[] panels = colorChooser.getChooserPanels();
        AbstractColorChooserPanel[] newPanels = new AbstractColorChooserPanel[]{panels[0], new DefaultHSBChooserPanel(), new JRGBChooserPanel()};
        colorChooser.setChooserPanels(newPanels);
        colorChooser.setColor(initColor);
        return colorChooser;
    }

    public static Color showDialog(Component parent, String title, Color initColor) {
        JColorChooser pane = ColorDialog.getColorChooser(initColor);
        ColorTracker okTracker = new ColorTracker(pane);
        JDialog dialog = JColorChooser.createDialog(parent, title, true, pane, okTracker, null);
        dialog.setVisible(true);
        return okTracker.getColor();
    }

    private static class ColorTracker
    implements ActionListener,
    Serializable {
        JColorChooser chooser;
        Color color;

        public ColorTracker(JColorChooser c) {
            this.chooser = c;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.color = this.chooser.getColor();
        }

        public Color getColor() {
            return this.color;
        }
    }
}

