/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing.color;

import java.awt.Color;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.event.MouseEvent;
import quadbase.common.swing.CanvasAction;

public class ColorPalette
extends CanvasAction {
    int row;
    int col;
    Color[][] palette;
    static final int GAP = 3;
    Color[] grayColor;
    boolean isGrayScale;
    int selectrow;
    int selectcol;

    public ColorPalette() {
        this(6, 6);
    }

    public ColorPalette(int row, int col, Color[][] palette) {
        this.row = row;
        this.col = col;
        this.palette = palette;
        this.setGrayColor();
    }

    public ColorPalette(int row, int col) {
        this(row, col, false);
    }

    public ColorPalette(int row, int col, boolean grayScale) {
        int j;
        int i;
        int blackrow;
        this.isGrayScale = grayScale;
        this.row = row;
        this.col = col;
        this.palette = new Color[row][col];
        int n = blackrow = row > 10 ? 2 : 1;
        if (this.isGrayScale) {
            blackrow = row;
        }
        for (i = 0; i < blackrow; ++i) {
            for (j = 0; j < col; ++j) {
                this.palette[i][j] = Color.getHSBColor(1.0f, 0.0f, ((float)i * (float)col + (float)j) / ((float)blackrow * (float)col - 1.0f));
            }
        }
        if (!this.isGrayScale) {
            for (i = blackrow; i < row; ++i) {
                for (j = 0; j < col; ++j) {
                    this.palette[i][j] = Color.getHSBColor((float)((i - blackrow) * col + j) / ((float)(row - blackrow) * (float)col), 1.0f, 1.0f);
                }
            }
        }
        this.setGrayColor();
    }

    void setGrayColor() {
        this.grayColor = new Color[3];
        for (int i = 0; i < 3; ++i) {
            int c = 255 - i * 255 / 3;
            this.grayColor[i] = new Color(c, c, c);
        }
    }

    public void setColor(int selectrow, int selectcol) {
        if (selectrow >= this.row) {
            selectrow = this.row - 1;
        } else if (selectrow < 0) {
            selectrow = 0;
        }
        if (selectcol >= this.col) {
            selectcol = this.col - 1;
        } else if (selectcol < 0) {
            selectcol = 0;
        }
        this.selectrow = selectrow;
        this.selectcol = selectcol;
        this.repaint();
    }

    public Color getColor() {
        return this.palette[this.selectrow][this.selectcol];
    }

    public void changePalette(int row, int col, Color color) {
        if (row >= this.row || row < 0 || col >= this.col || col < 0) {
            return;
        }
        this.palette[row][col] = color;
        this.repaint();
    }

    public void setPalette(int row, int col, Color[][] palette) {
        this.row = row;
        this.col = col;
        this.palette = palette;
        this.repaint();
    }

    public Color setNearestColor(Color color) {
        float diff = 0.0f;
        boolean first = true;
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                Color c = this.palette[i][j];
                float currdiff = (c.getRed() - color.getRed()) * (c.getRed() - color.getRed()) + (c.getGreen() - color.getGreen()) * (c.getGreen() - color.getGreen()) + (c.getBlue() - color.getBlue()) * (c.getBlue() - color.getBlue());
                if (!first) {
                    if (!(currdiff < diff)) continue;
                    this.selectrow = i;
                    this.selectcol = j;
                    diff = currdiff;
                    continue;
                }
                this.selectrow = i;
                this.selectcol = j;
                diff = currdiff;
                first = false;
            }
        }
        if (diff > 8.0f) {
            this.selectrow = -1;
            this.selectcol = -1;
            this.repaint();
            return null;
        }
        this.repaint();
        return this.palette[this.selectrow][this.selectcol];
    }

    @Override
    public Dimension getMinimumSize() {
        return new Dimension(6 * this.col, 6 * this.row);
    }

    @Override
    public Dimension getPreferredSize() {
        return this.getMinimumSize();
    }

    @Override
    public void paint(Graphics g) {
        int i;
        int width = this.getSize().width;
        int height = this.getSize().height;
        if (width * height <= 0) {
            return;
        }
        Image offScreenImage = this.createImage(width, height);
        Graphics backbuffer = offScreenImage.getGraphics();
        backbuffer.setColor(this.getBackground());
        backbuffer.fillRect(0, 0, width, height);
        double lh = ((double)height - (double)((this.row + 1) * 3)) / (double)this.row;
        double lw = ((double)width - (double)((this.col + 1) * 3)) / (double)this.col;
        for (i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                backbuffer.setColor(this.palette[i][j]);
                backbuffer.fillRect((int)((double)j * (lw + 3.0)) + 3, (int)((double)i * (lh + 3.0)) + 3, (int)lw + 1, (int)lh + 1);
                if (i != this.selectrow || j != this.selectcol) continue;
                this.drawBorder(backbuffer, (int)((double)j * (lw + 3.0)) + 3, (int)((double)i * (lh + 3.0)) + 3, (int)lw + 1, (int)lh + 1);
            }
        }
        for (i = 1; i < this.row; ++i) {
            this.drawHorizontalBar(backbuffer, 0, (int)((double)i * (lh + 3.0)), width);
        }
        for (i = 0; i < this.col; ++i) {
            this.drawVerticalBar(backbuffer, (int)((double)i * (lw + 3.0)), 0, height);
        }
        this.drawVerticalBar(backbuffer, width - 3, 0, height);
        this.drawHorizontalBar(backbuffer, 0, 0, width);
        this.drawHorizontalBar(backbuffer, 0, height - 3, width);
        g.drawImage(offScreenImage, 0, 0, this);
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    void drawHorizontalBar(Graphics g, int x, int y, int w) {
        for (int i = 0; i < 3; ++i) {
            g.setColor(this.grayColor[i]);
            g.drawLine(x, y + i, w, y + i);
        }
    }

    void drawVerticalBar(Graphics g, int x, int y, int h) {
        for (int i = 0; i < 3; ++i) {
            g.setColor(this.grayColor[i]);
            g.drawLine(x + i, y, x + i, h);
        }
    }

    void drawBorder(Graphics g, int x, int y, int w, int h) {
        g.setColor(Color.black);
        for (int i = 0; i < 3; ++i) {
            g.drawRect(x + i - 1, y + i - 1, w - 2 * i, h - 2 * i);
        }
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int width = this.getSize().width;
        int height = this.getSize().height;
        int cellw = width / this.col;
        int cellh = height / this.row;
        int x = e.getX();
        int y = e.getY();
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                if (x < j * cellw || x > (j + 1) * cellw || y < i * cellh || y > (i + 1) * cellh) continue;
                this.selectrow = i;
                this.selectcol = j;
                this.repaint();
                this.fireEvent(this, 0);
            }
        }
    }
}

