/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.Serializable;
import javax.swing.JButton;
import javax.swing.JColorChooser;
import javax.swing.JDialog;
import javax.swing.JPanel;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import quadbase.chart.designer.ChartMain;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.HexPanel;
import quadbase.common.swing.HexUpdateEvent;
import quadbase.common.swing.HexUpdateEventListener;
import quadbase.common.swing.JRGBChooserPanel;
import quadbase.common.swing.JSwatchChooserPanel;
import quadbase.common.swing.PanelAction;
import quadbase.common.swing.color.ColorLabel;
import quadbase.common.swing.color.ColorPalette;
import quadbase.common.swing.color.DefaultHSBChooserPanel;
import quadbase.common.util.internal.LanguageEncoder;

public class ColorPanel
extends PanelAction
implements HexUpdateEventListener {
    Color color;
    ColorPalette colorPalette;
    ColorLabel clabel;
    JButton morebutton;
    public HexPanel hexPanel;
    public JColorChooser colorDialog;
    String url;
    ChartMain chartMain;

    public ColorPanel(ChartMain chartMain, Color color) {
        this(chartMain, color, 10, 5);
    }

    public ColorPanel(ChartMain chartMain, Color color, int row, int col) {
        this.chartMain = chartMain;
        this.color = color;
        this.colorPalette = new ColorPalette(row, col);
        this.colorPalette.setNearestColor(color);
        this.clabel = new ColorLabel(color);
        this.morebutton = new JButton(LanguageEncoder.getText("More..."));
        this.setLayout(new BorderLayout());
        BorderPanel borderPanel = new BorderPanel(LanguageEncoder.getText("Color"));
        borderPanel.setLayout(new BorderLayout());
        borderPanel.add("Center", this.colorPalette);
        JPanel bottompanel = new JPanel();
        bottompanel.setLayout(new BorderLayout());
        bottompanel.add("West", this.clabel);
        bottompanel.add("East", this.morebutton);
        this.hexPanel = new HexPanel(color);
        this.hexPanel.addHexUpdateEventListener(this);
        bottompanel.add("South", this.hexPanel);
        borderPanel.add("South", bottompanel);
        this.add("Center", borderPanel);
        this.colorPalette.addActionListener(this);
        this.morebutton.addActionListener(this);
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.hexPanel.setIsHexField(false);
        Object target = e.getSource();
        if (target == this.morebutton) {
            Color currentColor = this.showDialog(this.chartMain, LanguageEncoder.getText("Colors"), this.color);
            this.setColor(currentColor, true);
            if (currentColor != null) {
                this.chartMain.addRecentColor(currentColor);
            }
            this.fireEvent(this, 0);
        } else {
            this.setColor(this.colorPalette.getColor(), true);
            this.fireEvent(this, 0);
        }
    }

    public void setColor(Color color, boolean repaintPatternLabel) {
        if (color == null) {
            return;
        }
        this.color = color;
        this.colorPalette.setNearestColor(color);
        this.chartMain.patternPanel.setPatternColor(color, repaintPatternLabel);
        this.clabel.setColor(color);
        if (!this.hexPanel.isHexField() && !color.equals(this.hexPanel.getUpdatedColor())) {
            this.hexPanel.updateTxtHexcode(color);
        }
    }

    public Color getColor() {
        return this.color;
    }

    public void setURL(String url) {
        this.url = url;
    }

    private JColorChooser getColorChooser(ChartMain chartMain, Color initColor) {
        JColorChooser colorChooser = new JColorChooser();
        AbstractColorChooserPanel[] panels = colorChooser.getChooserPanels();
        AbstractColorChooserPanel[] newPanels = new AbstractColorChooserPanel[]{new JSwatchChooserPanel(chartMain.getRecentColorArray()), new DefaultHSBChooserPanel(), new JRGBChooserPanel()};
        colorChooser.setChooserPanels(newPanels);
        colorChooser.setColor(initColor);
        return colorChooser;
    }

    public Color showDialog(ChartMain chartMain, String title, Color initColor) {
        JColorChooser pane = this.getColorChooser(chartMain, initColor);
        ColorTracker okTracker = new ColorTracker(pane);
        JDialog dialog = JColorChooser.createDialog(chartMain, title, true, pane, okTracker, null);
        dialog.setVisible(true);
        return okTracker.getColor();
    }

    @Override
    public void hexUpdated(HexUpdateEvent evt) {
        this.hexPanel.setIsHexField(true);
        this.setColor(this.hexPanel.getUpdatedColor(), true);
        this.fireEvent(this, 0);
    }

    class ColorTracker
    implements ActionListener,
    Serializable {
        JColorChooser chooser;
        Color color;

        public ColorTracker(JColorChooser c) {
            this.chooser = c;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            this.color = this.chooser.getColor();
        }

        public Color getColor() {
            return this.color;
        }
    }
}

