/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ItemEvent;
import java.awt.event.ItemListener;
import javax.swing.ButtonGroup;
import javax.swing.JComboBox;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.border.EmptyBorder;
import javax.swing.border.LineBorder;
import quadbase.chart.ChartColorSet;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.PanelAction;
import quadbase.common.util.internal.LanguageEncoder;

public class ColorSetPanel
extends PanelAction
implements ItemListener {
    private static final long serialVersionUID = 1L;
    public static final int VALUE_AXIS_COLOR_SET = 0;
    public static final int SECOND_VALUE_AXIS_COLOR_SET = 1;
    ButtonGroup radioButtonGroup;
    boolean isValueColorSetActive = true;
    boolean isSecondValueColorSetActive = true;
    int selectedValueColorSet = 0;
    int selectedSecondValueColorSet = 6;
    JPanel selectValueAxisPanel;
    JRadioButton[] radioButtonArray;
    JComboBox selectValueAxis = new JComboBox();

    public ColorSetPanel() {
        Color[][] colors = ChartColorSet.colorSetArr;
        this.radioButtonGroup = new ButtonGroup();
        this.radioButtonArray = new JRadioButton[colors.length + 1];
        this.selectValueAxisPanel = new JPanel(new FlowLayout(0));
        JLabel selectValueAxisLabel = new JLabel(LanguageEncoder.getText("Select Axis"));
        this.selectValueAxis.addItem("Value");
        this.selectValueAxis.addItem("2nd Value");
        this.selectValueAxis.setSelectedIndex(0);
        this.selectValueAxis.addItemListener(this);
        this.selectValueAxisPanel.add(selectValueAxisLabel);
        this.selectValueAxisPanel.add(this.selectValueAxis);
        this.selectValueAxisPanel.setVisible(true);
        this.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.setLayout(new BorderLayout(5, 5));
        this.add("North", this.selectValueAxisPanel);
        BorderPanel borderPanel = new BorderPanel(LanguageEncoder.getText("Color Sets"));
        borderPanel.setLayout(new GridLayout(colors.length, 1, 2, 5));
        for (int i = 0; i < colors.length; ++i) {
            JPanel jpanel = new JPanel();
            jpanel.setLayout(new FlowLayout(0));
            this.radioButtonArray[i] = new JRadioButton();
            this.radioButtonArray[i].setActionCommand(Integer.toString(i));
            this.radioButtonArray[i].addActionListener(this);
            jpanel.add(this.radioButtonArray[i]);
            this.createColorPanel(jpanel, colors, i);
            jpanel.addMouseListener(this);
            borderPanel.add(jpanel);
            this.radioButtonGroup.add(this.radioButtonArray[i]);
        }
        JRadioButton hiddenButton = new JRadioButton();
        hiddenButton.setVisible(false);
        this.radioButtonArray[colors.length] = hiddenButton;
        this.radioButtonGroup.add(this.radioButtonArray[colors.length]);
        this.add("Center", borderPanel);
    }

    private void createColorPanel(JPanel parentPanel, Color[][] colors, int colorSetIndex) {
        JPanel innerPanel = new JPanel();
        innerPanel.setLayout(new GridLayout(colors[colorSetIndex].length / 8, 8, 5, 5));
        for (int i = 0; i < colors[colorSetIndex].length; ++i) {
            JPanel panel = new JPanel();
            panel.setBorder(new LineBorder(Color.black, 1));
            panel.setBackground(colors[colorSetIndex][i]);
            innerPanel.add(panel);
        }
        parentPanel.add(innerPanel);
    }

    public int getSelectedValueColorSet() {
        return this.selectedValueColorSet;
    }

    public int getSelectedSecondValueColorSet() {
        return this.selectedSecondValueColorSet;
    }

    public void setSelectedValueColorSet(int i) {
        if (i >= 0 && i < this.radioButtonArray.length - 1) {
            this.selectedValueColorSet = i;
            if (this.selectValueAxis.getSelectedIndex() == 0) {
                this.radioButtonArray[this.selectedValueColorSet].setSelected(true);
            }
        } else {
            this.clearValueColorSetSelection();
        }
    }

    public void setSelectedSecondValueColorSet(int i) {
        if (i >= 0 && i < this.radioButtonArray.length - 1) {
            this.selectedSecondValueColorSet = i;
            if (this.selectValueAxis.getSelectedIndex() == 1) {
                this.radioButtonArray[this.selectedSecondValueColorSet].setSelected(true);
            }
        } else {
            this.clearSecondValueColorSetSelection();
        }
    }

    public void setSelectAxisPanelVisible(boolean visible) {
        this.selectValueAxisPanel.setVisible(visible);
    }

    public void clearValueColorSetSelection() {
        this.isValueColorSetActive = false;
        if (this.selectValueAxis.getSelectedIndex() == 0) {
            this.radioButtonArray[this.radioButtonArray.length - 1].setSelected(true);
        }
    }

    public void clearSecondValueColorSetSelection() {
        this.isSecondValueColorSetActive = false;
        if (this.selectValueAxis.getSelectedIndex() == 1) {
            this.radioButtonArray[this.radioButtonArray.length - 1].setSelected(true);
        }
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        Object target = e.getSource();
        if (target instanceof JRadioButton) {
            if (this.selectValueAxis.getSelectedIndex() == 0) {
                this.selectedValueColorSet = Integer.valueOf(e.getActionCommand());
                this.isValueColorSetActive = true;
            } else {
                this.selectedSecondValueColorSet = Integer.valueOf(e.getActionCommand());
                this.isSecondValueColorSetActive = true;
            }
            this.fireEvent(this, 0);
        }
    }

    public int getSelectedValueAxis() {
        return this.selectValueAxis.getSelectedIndex();
    }

    @Override
    public void itemStateChanged(ItemEvent e) {
        Object target = e.getSource();
        if (target == this.selectValueAxis) {
            if (this.selectValueAxis.getSelectedIndex() == 0) {
                if (this.isValueColorSetActive) {
                    this.setSelectedValueColorSet(this.selectedValueColorSet);
                } else {
                    this.clearValueColorSetSelection();
                }
            } else if (this.isSecondValueColorSetActive) {
                this.setSelectedSecondValueColorSet(this.selectedSecondValueColorSet);
            } else {
                this.clearSecondValueColorSetSelection();
            }
        }
    }
}

