/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Image;
import java.awt.Point;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.HierarchyEvent;
import java.awt.event.HierarchyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseMotionAdapter;
import java.awt.image.ImageConsumer;
import javax.swing.ButtonGroup;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JColorChooser;
import javax.swing.JComponent;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JRadioButton;
import javax.swing.JSlider;
import javax.swing.JSpinner;
import javax.swing.JTextField;
import javax.swing.SpinnerNumberModel;
import javax.swing.UIManager;
import javax.swing.border.EmptyBorder;
import javax.swing.colorchooser.AbstractColorChooserPanel;
import javax.swing.event.ChangeEvent;
import javax.swing.event.ChangeListener;
import quadbase.common.swing.SmartGridLayout;
import quadbase.common.swing.color.SyntheticImage;

public class DefaultHSBChooserPanel
extends AbstractColorChooserPanel
implements ChangeListener,
HierarchyListener {
    private transient HSBImage palette;
    private transient HSBImage sliderPalette;
    private transient Image paletteImage;
    private transient Image sliderPaletteImage;
    private JSlider slider;
    private JSpinner hField;
    private JSpinner sField;
    private JSpinner bField;
    private JTextField redField;
    private JTextField greenField;
    private JTextField blueField;
    private boolean isAdjusting = false;
    private Point paletteSelection = new Point();
    private JLabel paletteLabel;
    private JLabel sliderPaletteLabel;
    private JRadioButton hRadio;
    private JRadioButton sRadio;
    private JRadioButton bRadio;
    private static final int PALETTE_DIMENSION = 200;
    private static final int MAX_HUE_VALUE = 359;
    private static final int MAX_SATURATION_VALUE = 100;
    private static final int MAX_BRIGHTNESS_VALUE = 100;
    private int currentMode = 0;
    private static final int HUE_MODE = 0;
    private static final int SATURATION_MODE = 1;
    private static final int BRIGHTNESS_MODE = 2;

    private void addPaletteListeners() {
        this.paletteLabel.addMouseListener(new MouseAdapter(){

            @Override
            public void mousePressed(MouseEvent e) {
                float[] hsb = new float[3];
                DefaultHSBChooserPanel.this.palette.getHSBForLocation(e.getX(), e.getY(), hsb);
                DefaultHSBChooserPanel.this.updateHSB(hsb[0], hsb[1], hsb[2]);
            }
        });
        this.paletteLabel.addMouseMotionListener(new MouseMotionAdapter(){

            @Override
            public void mouseDragged(MouseEvent e) {
                int labelWidth = DefaultHSBChooserPanel.this.paletteLabel.getWidth();
                int labelHeight = DefaultHSBChooserPanel.this.paletteLabel.getHeight();
                int x = e.getX();
                int y = e.getY();
                if (x >= labelWidth) {
                    x = labelWidth - 1;
                }
                if (y >= labelHeight) {
                    y = labelHeight - 1;
                }
                if (x < 0) {
                    x = 0;
                }
                if (y < 0) {
                    y = 0;
                }
                float[] hsb = new float[3];
                DefaultHSBChooserPanel.this.palette.getHSBForLocation(x, y, hsb);
                DefaultHSBChooserPanel.this.updateHSB(hsb[0], hsb[1], hsb[2]);
            }
        });
    }

    private void updatePalette(float h, float s, float b) {
        int x = 0;
        int y = 0;
        switch (this.currentMode) {
            case 0: {
                if (h != this.palette.getHue()) {
                    this.palette.setHue(h);
                    this.palette.nextFrame();
                }
                x = 200 - (int)(s * 200.0f);
                y = 200 - (int)(b * 200.0f);
                break;
            }
            case 1: {
                if (s != this.palette.getSaturation()) {
                    this.palette.setSaturation(s);
                    this.palette.nextFrame();
                }
                x = (int)(h * 200.0f);
                y = 200 - (int)(b * 200.0f);
                break;
            }
            case 2: {
                if (b != this.palette.getBrightness()) {
                    this.palette.setBrightness(b);
                    this.palette.nextFrame();
                }
                x = (int)(h * 200.0f);
                y = 200 - (int)(s * 200.0f);
            }
        }
        this.paletteSelection.setLocation(x, y);
        this.paletteLabel.repaint();
    }

    private void updateSlider(float h, float s, float b) {
        if (this.currentMode != 0 && h != this.sliderPalette.getHue()) {
            this.sliderPalette.setHue(h);
            this.sliderPalette.nextFrame();
        }
        float value = 0.0f;
        switch (this.currentMode) {
            case 0: {
                value = h;
                break;
            }
            case 1: {
                value = s;
                break;
            }
            case 2: {
                value = b;
            }
        }
        this.slider.setValue(Math.round(value * (float)this.slider.getMaximum()));
    }

    private void updateHSBTextFields(float hue, float saturation, float brightness) {
        int h = Math.round(hue * 359.0f);
        int s = Math.round(saturation * 100.0f);
        int b = Math.round(brightness * 100.0f);
        if ((Integer)this.hField.getValue() != h) {
            this.hField.setValue(h);
        }
        if ((Integer)this.sField.getValue() != s) {
            this.sField.setValue(s);
        }
        if ((Integer)this.bField.getValue() != b) {
            this.bField.setValue(b);
        }
    }

    private void updateRGBTextFields(Color color) {
        this.redField.setText(String.valueOf(color.getRed()));
        this.greenField.setText(String.valueOf(color.getGreen()));
        this.blueField.setText(String.valueOf(color.getBlue()));
    }

    private void updateHSB(float h, float s, float b) {
        if (!this.isAdjusting) {
            this.isAdjusting = true;
            this.updatePalette(h, s, b);
            this.updateSlider(h, s, b);
            this.updateHSBTextFields(h, s, b);
            Color color = Color.getHSBColor(h, s, b);
            this.updateRGBTextFields(color);
            this.getColorSelectionModel().setSelectedColor(color);
            this.isAdjusting = false;
        }
    }

    @Override
    public void updateChooser() {
        if (!this.isAdjusting) {
            float[] hsb = this.getHSBColorFromModel();
            this.updateHSB(hsb[0], hsb[1], hsb[2]);
        }
    }

    @Override
    public void installChooserPanel(JColorChooser enclosingChooser) {
        super.installChooserPanel(enclosingChooser);
        this.setInheritsPopupMenu(true);
        this.addHierarchyListener(this);
    }

    @Override
    public void uninstallChooserPanel(JColorChooser enclosingChooser) {
        super.uninstallChooserPanel(enclosingChooser);
        this.cleanupPalettesIfNecessary();
        this.removeAll();
        this.removeHierarchyListener(this);
    }

    private float[] getHSBColorFromModel() {
        Color color = this.getColorFromModel();
        float[] hsb = new float[3];
        Color.RGBtoHSB(color.getRed(), color.getGreen(), color.getBlue(), hsb);
        return hsb;
    }

    @Override
    protected void buildChooser() {
        this.setLayout(new BorderLayout());
        JComponent spp = this.buildSliderPalettePanel();
        spp.setInheritsPopupMenu(true);
        this.add((Component)spp, "Before");
        JPanel controlHolder = new JPanel(new SmartGridLayout(1, 3));
        JComponent hsbControls = this.buildHSBControls();
        hsbControls.setInheritsPopupMenu(true);
        controlHolder.add(hsbControls);
        controlHolder.add(new JLabel(" "));
        JComponent rgbControls = this.buildRGBControls();
        rgbControls.setInheritsPopupMenu(true);
        controlHolder.add(rgbControls);
        controlHolder.setInheritsPopupMenu(true);
        controlHolder.setBorder(new EmptyBorder(10, 5, 10, 5));
        this.add((Component)controlHolder, "Center");
    }

    private JComponent buildRGBControls() {
        JPanel panel = new JPanel(new SmartGridLayout(2, 3));
        panel.setInheritsPopupMenu(true);
        Color color = this.getColorFromModel();
        this.redField = new JTextField(String.valueOf(color.getRed()), 3);
        this.redField.setEditable(false);
        this.redField.setHorizontalAlignment(4);
        this.redField.setInheritsPopupMenu(true);
        this.greenField = new JTextField(String.valueOf(color.getGreen()), 3);
        this.greenField.setEditable(false);
        this.greenField.setHorizontalAlignment(4);
        this.greenField.setInheritsPopupMenu(true);
        this.blueField = new JTextField(String.valueOf(color.getBlue()), 3);
        this.blueField.setEditable(false);
        this.blueField.setHorizontalAlignment(4);
        this.blueField.setInheritsPopupMenu(true);
        panel.add(new JLabel("R"));
        panel.add(this.redField);
        panel.add(new JLabel("G"));
        panel.add(this.greenField);
        panel.add(new JLabel("B"));
        panel.add(this.blueField);
        return panel;
    }

    private JComponent buildHSBControls() {
        RadioButtonHandler handler = new RadioButtonHandler();
        this.hRadio = new JRadioButton("H");
        this.hRadio.addActionListener(handler);
        this.hRadio.setSelected(true);
        this.hRadio.setInheritsPopupMenu(true);
        this.sRadio = new JRadioButton("S");
        this.sRadio.addActionListener(handler);
        this.sRadio.setInheritsPopupMenu(true);
        this.bRadio = new JRadioButton("B");
        this.bRadio.addActionListener(handler);
        this.bRadio.setInheritsPopupMenu(true);
        ButtonGroup group = new ButtonGroup();
        group.add(this.hRadio);
        group.add(this.sRadio);
        group.add(this.bRadio);
        float[] hsb = this.getHSBColorFromModel();
        this.hField = new JSpinner(new SpinnerNumberModel((int)(hsb[0] * 359.0f), 0, 359, 1));
        this.sField = new JSpinner(new SpinnerNumberModel((int)(hsb[1] * 100.0f), 0, 100, 1));
        this.bField = new JSpinner(new SpinnerNumberModel((int)(hsb[2] * 100.0f), 0, 100, 1));
        this.hField.addChangeListener(this);
        this.sField.addChangeListener(this);
        this.bField.addChangeListener(this);
        this.hField.setInheritsPopupMenu(true);
        this.sField.setInheritsPopupMenu(true);
        this.bField.setInheritsPopupMenu(true);
        JPanel panel = new JPanel(new SmartGridLayout(2, 3));
        panel.add(this.hRadio);
        panel.add(this.hField);
        panel.add(this.sRadio);
        panel.add(this.sField);
        panel.add(this.bRadio);
        panel.add(this.bField);
        panel.setInheritsPopupMenu(true);
        return panel;
    }

    private void setMode(int mode) {
        if (this.currentMode == mode) {
            return;
        }
        this.isAdjusting = true;
        this.currentMode = mode;
        float[] hsb = this.getHSBColorFromModel();
        switch (this.currentMode) {
            case 0: {
                this.slider.setInverted(true);
                this.slider.setMaximum(359);
                this.palette.setValues(0, hsb[0], 1.0f, 1.0f);
                this.sliderPalette.setValues(3, 0.0f, 1.0f, 1.0f);
                break;
            }
            case 1: {
                this.slider.setInverted(false);
                this.slider.setMaximum(100);
                this.palette.setValues(1, hsb[0], hsb[1], 1.0f);
                this.sliderPalette.setValues(4, hsb[0], 1.0f, 1.0f);
                break;
            }
            case 2: {
                this.slider.setInverted(false);
                this.slider.setMaximum(100);
                this.palette.setValues(2, hsb[0], 1.0f, hsb[2]);
                this.sliderPalette.setValues(5, hsb[0], 1.0f, 1.0f);
            }
        }
        this.isAdjusting = false;
        this.palette.nextFrame();
        this.sliderPalette.nextFrame();
        this.updateChooser();
    }

    protected JComponent buildSliderPalettePanel() {
        this.slider = new JSlider(1, 0, 359, 0);
        this.slider.setInverted(true);
        this.slider.setPaintTrack(false);
        this.slider.setInheritsPopupMenu(true);
        this.slider.putClientProperty("Slider.paintThumbArrowShape", Boolean.TRUE);
        this.slider.setPreferredSize(new Dimension(this.slider.getPreferredSize().width + 10, 215));
        this.slider.addChangeListener(this);
        this.paletteLabel = this.createPaletteLabel();
        this.addPaletteListeners();
        this.sliderPaletteLabel = new JLabel();
        JPanel panel = new JPanel();
        panel.add(this.paletteLabel);
        panel.add(this.slider);
        panel.add(this.sliderPaletteLabel);
        this.initializePalettesIfNecessary();
        return panel;
    }

    private void initializePalettesIfNecessary() {
        if (this.palette != null) {
            return;
        }
        float[] hsb = this.getHSBColorFromModel();
        switch (this.currentMode) {
            case 0: {
                this.palette = new HSBImage(0, 200, 200, hsb[0], 1.0f, 1.0f);
                this.sliderPalette = new HSBImage(3, 16, 200, 0.0f, 1.0f, 1.0f);
                break;
            }
            case 1: {
                this.palette = new HSBImage(1, 200, 200, 1.0f, hsb[1], 1.0f);
                this.sliderPalette = new HSBImage(4, 16, 200, 1.0f, 0.0f, 1.0f);
                break;
            }
            case 2: {
                this.palette = new HSBImage(2, 200, 200, 1.0f, 1.0f, hsb[2]);
                this.sliderPalette = new HSBImage(5, 16, 200, 1.0f, 1.0f, 0.0f);
            }
        }
        this.paletteImage = Toolkit.getDefaultToolkit().createImage(this.palette);
        this.sliderPaletteImage = Toolkit.getDefaultToolkit().createImage(this.sliderPalette);
        this.paletteLabel.setIcon(new ImageIcon(this.paletteImage));
        this.sliderPaletteLabel.setIcon(new ImageIcon(this.sliderPaletteImage));
    }

    private void cleanupPalettesIfNecessary() {
        if (this.palette == null) {
            return;
        }
        this.palette.aborted = true;
        this.sliderPalette.aborted = true;
        this.palette.nextFrame();
        this.sliderPalette.nextFrame();
        this.palette = null;
        this.sliderPalette = null;
        this.paletteImage = null;
        this.sliderPaletteImage = null;
        this.paletteLabel.setIcon(null);
        this.sliderPaletteLabel.setIcon(null);
    }

    protected JLabel createPaletteLabel() {
        return new JLabel(){

            @Override
            protected void paintComponent(Graphics g) {
                super.paintComponent(g);
                g.setColor(Color.white);
                g.drawOval(((DefaultHSBChooserPanel)DefaultHSBChooserPanel.this).paletteSelection.x - 4, ((DefaultHSBChooserPanel)DefaultHSBChooserPanel.this).paletteSelection.y - 4, 8, 8);
            }
        };
    }

    @Override
    public String getDisplayName() {
        return "HSB";
    }

    @Override
    public int getMnemonic() {
        return 72;
    }

    @Override
    public int getDisplayedMnemonicIndex() {
        return 0;
    }

    static int getInt(Object key, int defaultValue) {
        Object value = UIManager.get(key);
        if (value instanceof Integer) {
            return (Integer)value;
        }
        if (value instanceof String) {
            try {
                return Integer.parseInt((String)value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return defaultValue;
    }

    @Override
    public Icon getSmallDisplayIcon() {
        return null;
    }

    @Override
    public Icon getLargeDisplayIcon() {
        return null;
    }

    @Override
    public void stateChanged(ChangeEvent e) {
        if (e.getSource() == this.slider) {
            boolean modelIsAdjusting = this.slider.getModel().getValueIsAdjusting();
            if (!modelIsAdjusting && !this.isAdjusting) {
                int sliderValue = this.slider.getValue();
                int sliderRange = this.slider.getMaximum();
                float value = (float)sliderValue / (float)sliderRange;
                float[] hsb = this.getHSBColorFromModel();
                switch (this.currentMode) {
                    case 0: {
                        this.updateHSB(value, hsb[1], hsb[2]);
                        break;
                    }
                    case 1: {
                        this.updateHSB(hsb[0], value, hsb[2]);
                        break;
                    }
                    case 2: {
                        this.updateHSB(hsb[0], hsb[1], value);
                    }
                }
            }
        } else if (e.getSource() instanceof JSpinner) {
            float hue = ((Integer)this.hField.getValue()).floatValue() / 359.0f;
            float saturation = ((Integer)this.sField.getValue()).floatValue() / 100.0f;
            float brightness = ((Integer)this.bField.getValue()).floatValue() / 100.0f;
            this.updateHSB(hue, saturation, brightness);
        }
    }

    @Override
    public void hierarchyChanged(HierarchyEvent he) {
        if ((he.getChangeFlags() & 2L) != 0L) {
            if (this.isDisplayable()) {
                this.initializePalettesIfNecessary();
            } else {
                this.cleanupPalettesIfNecessary();
            }
        }
    }

    class HSBImage
    extends SyntheticImage {
        protected float h;
        protected float s;
        protected float b;
        protected float[] hsb;
        protected boolean isDirty;
        protected int cachedY;
        protected int cachedColor;
        protected int type;
        private static final int HSQUARE = 0;
        private static final int SSQUARE = 1;
        private static final int BSQUARE = 2;
        private static final int HSLIDER = 3;
        private static final int SSLIDER = 4;
        private static final int BSLIDER = 5;

        protected HSBImage(int type, int width, int height, float h, float s, float b) {
            super(width, height);
            this.h = 0.0f;
            this.s = 0.0f;
            this.b = 0.0f;
            this.hsb = new float[3];
            this.isDirty = true;
            this.setValues(type, h, s, b);
        }

        public void setValues(int type, float h, float s, float b) {
            this.type = type;
            this.cachedY = -1;
            this.cachedColor = 0;
            this.setHue(h);
            this.setSaturation(s);
            this.setBrightness(b);
        }

        public final void setHue(float hue) {
            this.h = hue;
        }

        public final void setSaturation(float saturation) {
            this.s = saturation;
        }

        public final void setBrightness(float brightness) {
            this.b = brightness;
        }

        public final float getHue() {
            return this.h;
        }

        public final float getSaturation() {
            return this.s;
        }

        public final float getBrightness() {
            return this.b;
        }

        @Override
        protected boolean isStatic() {
            return false;
        }

        public synchronized void nextFrame() {
            this.isDirty = true;
            this.notifyAll();
        }

        @Override
        public synchronized void addConsumer(ImageConsumer ic) {
            this.isDirty = true;
            super.addConsumer(ic);
        }

        private int getRGBForLocation(int x, int y) {
            if (this.type >= 3 && y == this.cachedY) {
                return this.cachedColor;
            }
            this.getHSBForLocation(x, y, this.hsb);
            this.cachedY = y;
            this.cachedColor = Color.HSBtoRGB(this.hsb[0], this.hsb[1], this.hsb[2]);
            return this.cachedColor;
        }

        public void getHSBForLocation(int x, int y, float[] hsbArray) {
            switch (this.type) {
                case 0: {
                    float saturationStep = (float)x / (float)this.width;
                    float brightnessStep = (float)y / (float)this.height;
                    hsbArray[0] = this.h;
                    hsbArray[1] = this.s - saturationStep;
                    hsbArray[2] = this.b - brightnessStep;
                    break;
                }
                case 1: {
                    float brightnessStep = (float)y / (float)this.height;
                    float step = 1.0f / (float)this.width;
                    hsbArray[0] = (float)x * step;
                    hsbArray[1] = this.s;
                    hsbArray[2] = 1.0f - brightnessStep;
                    break;
                }
                case 2: {
                    float saturationStep = (float)y / (float)this.height;
                    float step = 1.0f / (float)this.width;
                    hsbArray[0] = (float)x * step;
                    hsbArray[1] = 1.0f - saturationStep;
                    hsbArray[2] = this.b;
                    break;
                }
                case 3: {
                    float step = 1.0f / (float)this.height;
                    hsbArray[0] = (float)y * step;
                    hsbArray[1] = this.s;
                    hsbArray[2] = this.b;
                    break;
                }
                case 4: {
                    float saturationStep = (float)y / (float)this.height;
                    hsbArray[0] = this.h;
                    hsbArray[1] = this.s - saturationStep;
                    hsbArray[2] = this.b;
                    break;
                }
                case 5: {
                    float brightnessStep = (float)y / (float)this.height;
                    hsbArray[0] = this.h;
                    hsbArray[1] = this.s;
                    hsbArray[2] = this.b - brightnessStep;
                    break;
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        protected void computeRow(int y, int[] row) {
            if (y == 0) {
                HSBImage hSBImage = this;
                synchronized (hSBImage) {
                    try {
                        while (!this.isDirty) {
                            this.wait();
                        }
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    this.isDirty = false;
                }
            }
            if (this.aborted) {
                return;
            }
            for (int i = 0; i < row.length; ++i) {
                row[i] = this.getRGBForLocation(i, y);
            }
        }
    }

    private class RadioButtonHandler
    implements ActionListener {
        private RadioButtonHandler() {
        }

        @Override
        public void actionPerformed(ActionEvent evt) {
            Object obj = evt.getSource();
            if (obj instanceof JRadioButton) {
                JRadioButton button = (JRadioButton)obj;
                if (button == DefaultHSBChooserPanel.this.hRadio) {
                    DefaultHSBChooserPanel.this.setMode(0);
                } else if (button == DefaultHSBChooserPanel.this.sRadio) {
                    DefaultHSBChooserPanel.this.setMode(1);
                } else if (button == DefaultHSBChooserPanel.this.bRadio) {
                    DefaultHSBChooserPanel.this.setMode(2);
                }
            }
        }
    }
}

