/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing.color;

import java.awt.Dimension;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.TexturePaint;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import javax.swing.JLabel;
import quadbase.chart.QbPattern;

public class PatternLabel
extends JLabel {
    QbPattern pattern;

    public PatternLabel(QbPattern pattern) {
        this.pattern = pattern;
        super.setMinimumSize(new Dimension(50, 20));
        super.setPreferredSize(new Dimension(50, 20));
    }

    @Override
    public void paint(Graphics g) {
        BufferedImage mImage = this.pattern.getPatternImage();
        Rectangle2D.Float r = new Rectangle2D.Float(0.0f, 0.0f, this.getSize().width, this.getSize().height);
        if (mImage == null) {
            g.setColor(this.pattern);
            ((Graphics2D)g).fill(r);
            return;
        }
        Rectangle2D.Double tr = new Rectangle2D.Double(0.0, 0.0, mImage.getWidth(), mImage.getHeight());
        TexturePaint tp = new TexturePaint(mImage, tr);
        ((Graphics2D)g).setPaint(tp);
        ((Graphics2D)g).fill(r);
    }

    public void setPattern(QbPattern pattern) {
        this.pattern = pattern;
        this.repaint();
    }
}

