/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing.color;

import java.awt.Color;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Image;
import java.awt.Paint;
import java.awt.TexturePaint;
import java.awt.event.MouseEvent;
import java.awt.geom.Rectangle2D;
import java.awt.image.BufferedImage;
import quadbase.chart.QbPattern;
import quadbase.common.swing.CanvasAction;

public class PatternPalette
extends CanvasAction {
    int row;
    int col;
    QbPattern[][] palette;
    static final int GAP = 3;
    int selectrow;
    int selectcol;
    Color[] grayColor;
    Color patternColor;

    public PatternPalette() {
        this(6, 6);
    }

    public PatternPalette(int row, int col, QbPattern[][] palette) {
        this.row = row;
        this.col = col;
        this.palette = palette;
        this.setGrayColor();
    }

    public PatternPalette(int row, int col) {
        this.row = row;
        this.col = col;
        this.patternColor = Color.red;
        this.palette = new QbPattern[row][col];
        for (int i = 0; i < row; ++i) {
            for (int j = 0; j < col; ++j) {
                this.palette[i][j] = new QbPattern(Color.red, (i * row + j) % 6);
            }
        }
        this.setGrayColor();
    }

    void drawHorizontalBar(Graphics g, int x, int y, int w) {
        for (int i = 0; i < 3; ++i) {
            g.setColor(this.grayColor[i]);
            g.drawLine(x, y + i, w, y + i);
        }
    }

    void drawVerticalBar(Graphics g, int x, int y, int h) {
        for (int i = 0; i < 3; ++i) {
            g.setColor(this.grayColor[i]);
            g.drawLine(x + i, y, x + i, h);
        }
    }

    void drawBorder(Graphics g, int x, int y, int w, int h) {
        g.setColor(Color.black);
        for (int i = 0; i < 3; ++i) {
            g.drawRect(x + i - 1, y + i - 1, w - 2 * i, h - 2 * i);
        }
    }

    void setGrayColor() {
        this.grayColor = new Color[3];
        for (int i = 0; i < 3; ++i) {
            int c = 255 - i * 255 / 3;
            this.grayColor[i] = new Color(c, c, c);
        }
    }

    public void setPatternColor(Color color) {
        this.patternColor = color;
        for (int i = 0; i < this.palette.length; ++i) {
            for (int j = 0; j < this.palette[i].length; ++j) {
                this.palette[i][j] = new QbPattern(color, this.palette[i][j].getPatternTypeID());
            }
        }
        this.repaint();
    }

    @Override
    public void paint(Graphics g) {
        int i;
        int width = this.getSize().width;
        int height = this.getSize().height;
        if (width * height <= 0) {
            return;
        }
        Image offScreenImage = this.createImage(width, height);
        Graphics backbuffer = offScreenImage.getGraphics();
        backbuffer.setColor(this.getBackground());
        double lh = ((double)height - (double)((this.row + 1) * 3)) / (double)this.row;
        double lw = ((double)width - (double)((this.col + 1) * 3)) / (double)this.col;
        Paint gPaint = ((Graphics2D)g).getPaint();
        for (i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                this.palette[i][j] = new QbPattern(this.patternColor, (i * this.col + j) % 30);
                Rectangle2D.Float r = new Rectangle2D.Float((int)((double)j * (lw + 3.0)) + 3, (int)((double)i * (lh + 3.0)) + 3, (int)lw + 1, (int)lh + 1);
                BufferedImage mImage = this.palette[i][j].getPatternImage();
                if (mImage == null) {
                    backbuffer.setColor(this.palette[i][j]);
                    ((Graphics2D)backbuffer).fill(r);
                } else {
                    Rectangle2D.Double tr = new Rectangle2D.Double(0.0, 0.0, mImage.getWidth(), mImage.getHeight());
                    TexturePaint tp = new TexturePaint(mImage, tr);
                    ((Graphics2D)backbuffer).setPaint(tp);
                    ((Graphics2D)backbuffer).fill(r);
                    ((Graphics2D)backbuffer).setPaint(gPaint);
                }
                if (i != this.selectrow || j != this.selectcol) continue;
                this.drawBorder(backbuffer, (int)((double)j * (lw + 3.0)) + 3, (int)((double)i * (lh + 3.0)) + 3, (int)lw + 1, (int)lh + 1);
            }
        }
        for (i = 1; i < this.row; ++i) {
            this.drawHorizontalBar(backbuffer, 0, (int)((double)i * (lh + 3.0)), width);
        }
        for (i = 0; i < this.col; ++i) {
            this.drawVerticalBar(backbuffer, (int)((double)i * (lw + 3.0)), 0, height);
        }
        this.drawVerticalBar(backbuffer, width - 3, 0, height);
        this.drawHorizontalBar(backbuffer, 0, 0, width);
        this.drawHorizontalBar(backbuffer, 0, height - 3, width);
        ((Graphics2D)g).drawImage(offScreenImage, 0, 0, this);
    }

    public QbPattern getPattern() {
        return this.palette[this.selectrow][this.selectcol];
    }

    public void setSelect(int patternID) {
        if (patternID > 30 || patternID < 0) {
            return;
        }
        this.selectrow = patternID / this.col;
        this.selectcol = patternID % this.col;
        this.repaint();
    }

    @Override
    public void update(Graphics g) {
        this.paint(g);
    }

    @Override
    public void mousePressed(MouseEvent e) {
        int width = this.getSize().width;
        int height = this.getSize().height;
        int cellw = width / this.col;
        int cellh = height / this.row;
        int x = e.getX();
        int y = e.getY();
        for (int i = 0; i < this.row; ++i) {
            for (int j = 0; j < this.col; ++j) {
                if (x < j * cellw || x > (j + 1) * cellw || y < i * cellh || y > (i + 1) * cellh) continue;
                this.selectrow = i;
                this.selectcol = j;
                this.repaint();
                this.fireEvent(this, 0);
            }
        }
    }
}

