/*
 * Decompiled with CFR 0.152.
 */
package quadbase.common.swing.color;

import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.event.ActionEvent;
import javax.swing.JPanel;
import quadbase.chart.QbPattern;
import quadbase.common.swing.BorderPanel;
import quadbase.common.swing.PanelAction;
import quadbase.common.swing.color.PatternLabel;
import quadbase.common.swing.color.PatternPalette;
import quadbase.common.util.internal.LanguageEncoder;

public class PatternPanel
extends PanelAction {
    private QbPattern pattern;
    PatternLabel patternLabel;
    PatternPalette patternPalette;
    Color patternColor = Color.red;

    public PatternPanel(QbPattern pattern, int row, int col) {
        if (pattern == null) {
            pattern = new QbPattern(this.patternColor, 0);
            pattern.getPatternImage();
        }
        this.pattern = pattern;
        this.patternPalette = new PatternPalette(row, col);
        this.patternLabel = new PatternLabel(pattern);
        this.setLayout(new BorderLayout());
        BorderPanel borderPanel = new BorderPanel(LanguageEncoder.getText("Pattern"));
        borderPanel.setLayout(new BorderLayout());
        borderPanel.add("Center", this.patternPalette);
        JPanel bottompanel = new JPanel();
        bottompanel.setLayout(new BorderLayout());
        bottompanel.add("West", this.patternLabel);
        borderPanel.add("South", bottompanel);
        this.add("Center", borderPanel);
        this.patternPalette.addActionListener(this);
    }

    public void setPatternLabel(QbPattern pattern) {
        if (pattern == null) {
            return;
        }
        this.pattern = pattern;
        this.patternLabel.setPattern(pattern);
    }

    public void setPatternColor(Color color) {
        this.setPatternColor(color, false);
    }

    public void setPatternColor(Color color, boolean repaintLabel) {
        this.patternColor = color;
        this.patternPalette.setPatternColor(color);
        if (color instanceof QbPattern) {
            this.patternPalette.setSelect(((QbPattern)color).getPatternTypeID());
        } else {
            this.patternPalette.setSelect(0);
        }
        if (repaintLabel) {
            this.setPatternLabel(this.patternPalette.getPattern());
        }
    }

    public QbPattern getPattern() {
        return this.pattern;
    }

    @Override
    public void actionPerformed(ActionEvent e) {
        this.pattern = this.patternPalette.getPattern();
        this.setPatternLabel(this.pattern);
        this.fireEvent(this, 0);
    }
}

